/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.renderer.gui.professions;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_455;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.remmintan.mods.minefortress.core.interfaces.professions.CountProfessionals;
import net.remmintan.mods.minefortress.core.interfaces.professions.IProfession;
import net.remmintan.mods.minefortress.core.interfaces.professions.IProfessionsManager;
import net.remmintan.mods.minefortress.core.interfaces.professions.ProfessionResearchState;
import org.minefortress.utils.GuiUtils;

public class ProfessionWidget {
    public static final float PROFESSION_WIDGET_WIDTH = 64.0f;
    public static final float PROFESSION_WIDGET_HEIGHT = 35.0f;
    private static final class_2960 WIDGETS_TEXTURE = new class_2960("textures/gui/advancements/widgets.png");
    private ProfessionWidget parent;
    private final List<ProfessionWidget> children = new ArrayList<ProfessionWidget>();
    private final IProfession profession;
    private final IProfessionsManager professionManager;
    private int x = 0;
    private int y = 0;
    private final int width;
    private final class_310 client;

    public ProfessionWidget(IProfession profession, IProfessionsManager professionManager) {
        this.profession = profession;
        this.professionManager = professionManager;
        this.client = class_310.method_1551();
        int maxTextLength = 29 + this.client.field_1772.method_1727(profession.getTitle());
        for (class_2561 text : this.profession.getDescription()) {
            maxTextLength = Math.max(maxTextLength, this.client.field_1772.method_27525((class_5348)text));
        }
        this.width = maxTextLength + 8;
    }

    public void renderLines(class_332 drawContext, int x, int y, boolean bl) {
        if (this.parent != null) {
            int n;
            int i = x + this.parent.x + 13;
            int j = x + this.parent.x + 26 + 22;
            int k = y + this.parent.y + 13;
            int l = x + this.x + 13;
            int m = y + this.y + 13;
            int n2 = n = bl ? -16777216 : -1;
            if (bl) {
                drawContext.method_25292(j, i, k - 1, n);
                drawContext.method_25292(j + 1, i, k, n);
                drawContext.method_25292(j, i, k + 1, n);
                drawContext.method_25292(l, j - 1, m - 1, n);
                drawContext.method_25292(l, j - 1, m, n);
                drawContext.method_25292(l, j - 1, m + 1, n);
                drawContext.method_25301(j - 1, m, k, n);
                drawContext.method_25301(j + 1, m, k, n);
            } else {
                drawContext.method_25292(j, i, k, n);
                drawContext.method_25292(l, j, m, n);
                drawContext.method_25301(j, m, k, n);
            }
        }
        for (ProfessionWidget child : this.children) {
            child.renderLines(drawContext, x, y, bl);
        }
    }

    public void renderWidgets(class_332 drawContext, int x, int y) {
        boolean unlockedWithCount = this.isUnlocked(true) == ProfessionResearchState.UNLOCKED;
        boolean unlocked = this.isUnlocked(false) == ProfessionResearchState.UNLOCKED;
        class_455 status = unlockedWithCount ? class_455.field_2701 : class_455.field_2699;
        int v = 128 + status.method_2320() * 26;
        int u = this.profession.getType().method_832();
        drawContext.method_25302(WIDGETS_TEXTURE, x + this.x + 3, y + this.y, u, v, 26, 26);
        drawContext.method_51427(this.profession.getIcon(), x + this.x + 8, y + this.y + 5);
        class_4587 matrices = drawContext.method_51448();
        matrices.method_22903();
        matrices.method_22904(0.0, 0.0, 200.0);
        if (unlocked) {
            drawContext.method_25303(this.getTextRenderer(), String.valueOf(this.getAmount()), x + this.x + 6, y + this.y + 4, 0xFFFFFF);
        }
        matrices.method_22909();
        String title = this.profession.getTitle().contains("-") ? this.profession.getTitle().split("-")[0] : this.profession.getTitle();
        String trimmedTitle = this.getTextRenderer().method_27523(title, 60);
        int titleWidth = this.getTextRenderer().method_1727(trimmedTitle);
        drawContext.method_25303(this.getTextRenderer(), trimmedTitle, x + this.x + 4 - titleWidth / 2 + 13, y + this.y + 27, 0xFFFFFF);
        for (ProfessionWidget professionWidget : this.children) {
            professionWidget.renderWidgets(drawContext, x, y);
        }
    }

    private class_327 getTextRenderer() {
        return this.getInstance().field_1772;
    }

    private class_310 getInstance() {
        return class_310.method_1551();
    }

    void setParent(ProfessionWidget parent) {
        this.parent = parent;
    }

    void addChild(ProfessionWidget child) {
        this.children.add(child);
    }

    List<ProfessionWidget> getChildren() {
        return this.children;
    }

    void setPos(int column, float row) {
        this.x = class_3532.method_15375((float)((float)column * 64.0f));
        this.y = class_3532.method_15375((float)(row * 35.0f));
    }

    boolean shouldNotRender(int originX, int originY, int mouseX, int mouseY) {
        int i = originX + this.x;
        int j = i + 26;
        int k = originY + this.y;
        int l = k + 26;
        return mouseX < i || mouseX > j || mouseY < k || mouseY > l;
    }

    public void drawTooltip(class_332 drawContext, int originX, int originY, int x, int screenWidth) {
        boolean bl2;
        boolean unlocked = this.isUnlocked(false) == ProfessionResearchState.UNLOCKED;
        boolean unlockedWithCount = this.isUnlocked(true) == ProfessionResearchState.UNLOCKED;
        boolean parentUnlocked = this.isUnlocked(false) != ProfessionResearchState.LOCKED_PARENT;
        class_455 status = unlockedWithCount ? class_455.field_2701 : class_455.field_2699;
        int j = class_3532.method_15375((float)this.width);
        int k = this.width - j;
        int l = originY + this.y;
        boolean bl = x + originX + this.x + this.width + 26 >= screenWidth;
        int m = bl ? originX + this.x - this.width + 26 + 6 : originX + this.x;
        String title = this.profession.getTitle();
        List<class_2561> description = unlockedWithCount ? this.profession.getDescription() : (unlocked ? this.profession.getUnlockMoreMessage() : (!parentUnlocked ? GuiUtils.splitTextInWordsForLength("You need to unlock the parent profession first!") : this.profession.getUnlockMessage()));
        int n = description.size();
        Objects.requireNonNull(this.client.field_1772);
        int n2 = 32 + n * 9;
        int n3 = description.size();
        Objects.requireNonNull(this.client.field_1772);
        boolean bl3 = bl2 = 113 - originY - this.y - 26 <= 6 + n3 * 9;
        if (!description.isEmpty()) {
            if (bl2) {
                this.method_2324(drawContext, WIDGETS_TEXTURE, m, l + 26 - n2, this.width, n2);
            } else {
                this.method_2324(drawContext, WIDGETS_TEXTURE, m, l, this.width, n2);
            }
        }
        drawContext.method_25302(WIDGETS_TEXTURE, m, l, 0, status.method_2320() * 26, j, 26);
        drawContext.method_25302(WIDGETS_TEXTURE, m + j, l, 200 - k, status.method_2320() * 26, k, 26);
        drawContext.method_25302(WIDGETS_TEXTURE, originX + this.x + 3, originY + this.y, this.profession.getType().method_832(), 128 + status.method_2320() * 26, 26, 26);
        class_4587 matrices = drawContext.method_51448();
        matrices.method_22903();
        matrices.method_22904(0.0, 0.0, 200.0);
        if (unlocked) {
            drawContext.method_25303(this.getTextRenderer(), String.valueOf(this.getAmount()), m + 6, originY + this.y + 4, -1);
        }
        matrices.method_22909();
        if (bl) {
            drawContext.method_25303(this.getTextRenderer(), title, m + 5, originY + this.y + 9, -1);
        } else {
            drawContext.method_25303(this.getTextRenderer(), title, originX + this.x + 32, originY + this.y + 9, -1);
        }
        if (bl2) {
            for (int o = 0; o < description.size(); ++o) {
                class_327 class_3272 = this.getTextRenderer();
                Objects.requireNonNull(this.client.field_1772);
                drawContext.method_27535(class_3272, description.get(o), m + 5, l + 26 - n2 + 7 + o * 9, -5592406);
            }
        } else {
            for (int o = 0; o < description.size(); ++o) {
                class_327 class_3273 = this.getTextRenderer();
                Objects.requireNonNull(this.client.field_1772);
                drawContext.method_27535(class_3273, description.get(o), m + 5, originY + this.y + 9 + 17 + o * 9, -5592406);
            }
        }
        drawContext.method_51427(this.profession.getIcon(), originX + this.x + 8, originY + this.y + 5);
    }

    private int getAmount() {
        if (this.profession.getParent() == null) {
            return this.professionManager.getFreeColonists();
        }
        return this.profession.getAmount();
    }

    protected void method_2324(class_332 drawContext, class_2960 identifier, int x, int y, int i, int j) {
        drawContext.method_25302(identifier, x, y, 0, 52, 10, 10);
        this.method_2321(drawContext, identifier, x + 10, y, i - 10 - 10, 10, 10, 52, 180, 26);
        drawContext.method_25302(identifier, x + i - 10, y, 190, 52, 10, 10);
        drawContext.method_25302(identifier, x, y + j - 10, 0, 68, 10, 10);
        this.method_2321(drawContext, identifier, x + 10, y + j - 10, i - 10 - 10, 10, 10, 68, 180, 26);
        drawContext.method_25302(identifier, x + i - 10, y + j - 10, 190, 68, 10, 10);
        this.method_2321(drawContext, identifier, x, y + 10, 10, j - 10 - 10, 0, 62, 200, 6);
        this.method_2321(drawContext, identifier, x + 10, y + 10, i - 10 - 10, j - 10 - 10, 10, 62, 180, 6);
        this.method_2321(drawContext, identifier, x + i - 10, y + 10, 10, j - 10 - 10, 190, 62, 200, 6);
    }

    protected void method_2321(class_332 drawContext, class_2960 identifier, int x, int y, int i, int j, int k, int l, int m, int n) {
        for (int o = 0; o < i; o += m) {
            int p = x + o;
            int q = Math.min(m, i - o);
            for (int r = 0; r < j; r += n) {
                int s = y + r;
                int t = Math.min(n, j - r);
                drawContext.method_25302(identifier, p, s, k, l, q, t);
            }
        }
    }

    int getX() {
        return this.x;
    }

    int getY() {
        return this.y;
    }

    public ProfessionResearchState isUnlocked(boolean countProfessionals) {
        CountProfessionals shouldCountProfs;
        CountProfessionals countProfessionals2 = shouldCountProfs = countProfessionals ? CountProfessionals.INCREASE : CountProfessionals.DONT_COUNT;
        if (this.profession.isHireMenu()) {
            shouldCountProfs = CountProfessionals.DONT_COUNT;
        }
        return this.professionManager.isRequirementsFulfilled(this.profession, shouldCountProfs, true);
    }

    public void onClick(int button) {
        if (button == 0) {
            this.professionManager.findIdFromProfession(this.profession).ifPresent(it -> this.professionManager.increaseAmount((String)it, false));
        } else if (button == 1) {
            this.professionManager.findIdFromProfession(this.profession).ifPresent(this.professionManager::decreaseAmount);
        }
    }

    public ProfessionWidget getParent() {
        return this.parent;
    }
}

