/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.renderer.gui.hud.hints;

import java.util.List;
import net.remmintan.gobi.SelectionType;
import net.remmintan.mods.minefortress.core.interfaces.selections.ISelectionManager;
import net.remmintan.mods.minefortress.core.utils.CoreModUtils;
import org.minefortress.renderer.gui.hud.HudState;
import org.minefortress.renderer.gui.hud.hints.AbstractHintsLayer;

public class ChopTreesHintsLayer
extends AbstractHintsLayer {
    private static final List<String> START_HINTS = List.of("left click - start tree", "selection");
    private static final List<String> CHOPPING_HINTS = List.of("left click - confirm task", "right click - cancel");

    @Override
    protected List<String> getHints() {
        return this.getSelectionManager().isSelecting() ? CHOPPING_HINTS : START_HINTS;
    }

    @Override
    public boolean shouldRender(HudState hudState) {
        ISelectionManager sm = this.getSelectionManager();
        return super.shouldRender(hudState) && hudState == HudState.BUILD && sm.getCurrentSelectionType() == SelectionType.TREE;
    }

    private ISelectionManager getSelectionManager() {
        return CoreModUtils.getMineFortressManagersProvider().get_SelectionManager();
    }
}

