/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.renderer.gui.hud.hints;

import java.util.List;
import net.remmintan.gobi.SelectionType;
import net.remmintan.mods.minefortress.core.interfaces.selections.ISelectionManager;
import net.remmintan.mods.minefortress.core.utils.CoreModUtils;
import org.minefortress.renderer.gui.hud.HudState;
import org.minefortress.renderer.gui.hud.hints.AbstractHintsLayer;

public class BuildRoadsHintsLayer
extends AbstractHintsLayer {
    private static final List<String> START_BUILDING_HINTS = List.of("put any block in your hand", "right click - start road");
    private static final List<String> BUILDING_HINTS = List.of("left click - cancel", "right click - confirm task", "ctrl + E - expand road", "ctrl + Q - shrink road");

    @Override
    protected List<String> getHints() {
        return this.getSelectionManager().isSelecting() ? BUILDING_HINTS : START_BUILDING_HINTS;
    }

    @Override
    public boolean shouldRender(HudState hudState) {
        ISelectionManager sm = this.getSelectionManager();
        return super.shouldRender(hudState) && hudState == HudState.BUILD && sm.getCurrentSelectionType() == SelectionType.ROADS;
    }

    private ISelectionManager getSelectionManager() {
        return CoreModUtils.getMineFortressManagersProvider().get_SelectionManager();
    }
}

