/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.renderer.gui.hud.hints;

import java.util.List;
import java.util.Optional;
import net.remmintan.gobi.SelectionType;
import net.remmintan.mods.minefortress.core.interfaces.selections.ClickType;
import net.remmintan.mods.minefortress.core.interfaces.selections.ISelectionManager;
import net.remmintan.mods.minefortress.core.interfaces.selections.ISelectionType;
import net.remmintan.mods.minefortress.core.utils.CoreModUtils;
import org.minefortress.renderer.gui.hud.HudState;
import org.minefortress.renderer.gui.hud.hints.AbstractHintsLayer;

public class BuildHintsLayer
extends AbstractHintsLayer {
    private static final List<String> START_HINTS = List.of("left click - dig", "right click - build");
    private static final List<String> REMOVE_HINTS = List.of("left click - confirm task", "right click - cancel", "ctrl + E - move up", "ctrl + Q - move down");
    private static final List<String> BUILD_HINTS = List.of("left click - cancel", "right click - confirm task", "ctrl + E - move up", "ctrl + Q - move down");

    @Override
    public boolean shouldRender(HudState hudState) {
        ISelectionType selectType = this.getSelectionManager().getCurrentSelectionType();
        return super.shouldRender(hudState) && hudState == HudState.BUILD && selectType != SelectionType.TREE && selectType != SelectionType.ROADS;
    }

    @Override
    protected List<String> getHints() {
        if (this.getSelectionManager().isSelecting()) {
            if (this.getSelectionManager().getClickType() == ClickType.REMOVE) {
                return REMOVE_HINTS;
            }
            return BUILD_HINTS;
        }
        return START_HINTS;
    }

    @Override
    protected Optional<String> getInfoText() {
        String name = this.getSelectionManager().getCurrentSelectionType().getDisplayName();
        return Optional.of("Selection type: " + name);
    }

    private ISelectionManager getSelectionManager() {
        return CoreModUtils.getMineFortressManagersProvider().get_SelectionManager();
    }
}

