/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.renderer.gui.hud;

import java.util.Arrays;
import java.util.Optional;
import net.minecraft.class_1802;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.remmintan.gobi.SelectionType;
import net.remmintan.mods.minefortress.core.utils.CoreModUtils;
import org.minefortress.renderer.gui.blueprints.BlueprintsScreen;
import org.minefortress.renderer.gui.hud.AbstractHudLayer;
import org.minefortress.renderer.gui.hud.HudState;
import org.minefortress.renderer.gui.widget.HideableButtonWidget;
import org.minefortress.renderer.gui.widget.ItemButtonWidget;
import org.minefortress.renderer.gui.widget.ItemToggleWidget;
import org.minefortress.utils.ModUtils;

public class ToolsHudLayer
extends AbstractHudLayer {
    private final ItemButtonWidget selection;

    protected ToolsHudLayer(class_310 client) {
        super(client);
        this.setBasepoint(-25, 5, AbstractHudLayer.PositionX.RIGHT, AbstractHudLayer.PositionY.TOP);
        this.selection = new ItemButtonWidget(0, 0, class_1802.field_8377, btn -> {
            ItemButtonWidget fortressBtn = (ItemButtonWidget)btn;
            fortressBtn.checked = !fortressBtn.checked;
        }, button -> button.checked ? Optional.empty() : Optional.of("Selection Type"));
        this.addElement(this.selection);
        this.addElement(new ItemToggleWidget(0, 25, class_1802.field_8691, btn -> {
            if (this.blueprintSelected()) {
                ModUtils.getBlueprintManager().clearStructure();
            } else {
                this.client.method_1507((class_437)new BlueprintsScreen());
            }
        }, button -> Optional.of(this.blueprintSelected() ? "Cancel" : "Blueprints"), this::blueprintSelected, () -> !this.treeCutterSelected() && !this.roadsSelected()), new ItemToggleWidget(0, 50, class_1802.field_8556, btn -> {
            if (this.treeCutterSelected()) {
                ModUtils.getSelectionManager().setSelectionType(SelectionType.SQUARES);
            } else {
                ModUtils.getSelectionManager().setSelectionType(SelectionType.TREE);
            }
        }, button -> Optional.of(this.treeCutterSelected() ? "Cancel" : "Chop trees"), this::treeCutterSelected, () -> !this.blueprintSelected() && !this.roadsSelected()), new ItemToggleWidget(0, 75, class_1802.field_8250, btn -> {
            if (this.roadsSelected()) {
                ModUtils.getSelectionManager().setSelectionType(SelectionType.SQUARES);
            } else {
                ModUtils.getSelectionManager().setSelectionType(SelectionType.ROADS);
            }
        }, button -> Optional.of(this.roadsSelected() ? "Cancel" : "Build roads"), this::roadsSelected, () -> !this.blueprintSelected() && !this.treeCutterSelected()));
        SelectionType[] values = (SelectionType[])Arrays.stream(SelectionType.values()).filter(type -> type != SelectionType.TREE).filter(type -> type != SelectionType.ROADS).toArray(SelectionType[]::new);
        int i = 0;
        for (SelectionType type2 : values) {
            this.addElement(new HideableButtonWidget(-35, 25 * i++, 20, 20, type2.getButtonText(), btn -> ModUtils.getSelectionManager().setSelectionType(type2), type2.name(), () -> this.selection.checked));
        }
    }

    @Override
    public boolean shouldRender(HudState hudState) {
        return hudState == HudState.BUILD;
    }

    private boolean treeCutterSelected() {
        return CoreModUtils.getMineFortressManagersProvider().get_SelectionManager().getSelectionTypeIndex() == SelectionType.TREE.ordinal();
    }

    private boolean roadsSelected() {
        return CoreModUtils.getMineFortressManagersProvider().get_SelectionManager().getSelectionTypeIndex() == SelectionType.ROADS.ordinal();
    }

    private boolean blueprintSelected() {
        return CoreModUtils.getMineFortressManagersProvider().get_BlueprintManager().isSelecting();
    }
}

