/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.renderer.gui.hud;

import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_638;
import org.minefortress.renderer.gui.hud.AbstractHudLayer;
import org.minefortress.renderer.gui.hud.HudState;

class TimeHudLayer
extends AbstractHudLayer {
    TimeHudLayer(class_310 client) {
        super(client);
        this.setBasepoint(0, 0, AbstractHudLayer.PositionX.LEFT, AbstractHudLayer.PositionY.TOP);
    }

    @Override
    protected void renderHud(class_332 drawContext, int screenWidth, int screenHeight) {
        Optional<class_638> world = Optional.ofNullable(this.client.field_1687);
        long timeTicks = world.map(class_1937::method_8510).orElse(0L) + 6500L;
        long timeOfDayTicks = (world.map(class_1937::method_8532).orElse(0L) + 6500L) % 24000L;
        int timeDays = (int)Math.floor((double)timeTicks / 24000.0);
        int timeHours = (int)Math.floor((double)timeOfDayTicks / 1000.0);
        int timeMinutes = (int)Math.floor((double)(timeOfDayTicks %= 1000L) / 16.66667);
        String timeText = String.format("Day: %d | %02d:%02d", timeDays, timeHours, timeMinutes);
        drawContext.method_25303(this.textRenderer, timeText, screenWidth - this.textRenderer.method_1727(timeText) - 5, screenHeight - 15, 0xFFFFFF);
    }

    @Override
    public boolean shouldRender(HudState hudState) {
        return hudState != HudState.INITIALIZING;
    }
}

