/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.renderer.gui.hud;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1309;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.remmintan.mods.minefortress.core.interfaces.client.IClientFortressManager;
import net.remmintan.mods.minefortress.core.interfaces.entities.pawns.IHungerAwareEntity;
import net.remmintan.mods.minefortress.core.interfaces.entities.pawns.IProfessional;
import net.remmintan.mods.minefortress.core.interfaces.professions.IProfession;
import org.minefortress.entity.Colonist;
import org.minefortress.renderer.gui.hud.AbstractHudLayer;
import org.minefortress.renderer.gui.hud.HudState;
import org.minefortress.utils.ModUtils;

public class SelectedColonistHudLayer
extends AbstractHudLayer {
    protected SelectedColonistHudLayer(class_310 client) {
        super(client);
        this.setBasepoint(0, 0, AbstractHudLayer.PositionX.RIGHT, AbstractHudLayer.PositionY.TOP);
    }

    @Override
    protected void renderHud(class_332 drawContext, int screenWidth, int screenHeight) {
        IClientFortressManager fortressManager = ModUtils.getFortressClientManager();
        if (fortressManager.isSelectingColonist()) {
            class_1309 pawn = fortressManager.getSelectedPawn();
            boolean colonistWinX = false;
            int colonistWinY = screenHeight - 85;
            int width = 120;
            int height = 85;
            drawContext.method_33284(0, colonistWinY, 0 + width, colonistWinY + 85, -1000, -1072689136, -804253680);
            String name = Optional.ofNullable(pawn.method_5797()).map(class_2561::getString).orElse("");
            drawContext.method_25300(this.textRenderer, name, 0 + width / 2, colonistWinY + 5, 0xFFFFFF);
            String healthString = String.format("%.0f/%.0f", Float.valueOf(pawn.method_6032()), Float.valueOf(pawn.method_6063()));
            int heartIconX = 5;
            Objects.requireNonNull(this.textRenderer);
            int heartIconY = colonistWinY + 9 + 10;
            this.renderIcon(drawContext, heartIconX, heartIconY, 0);
            drawContext.method_25303(this.textRenderer, healthString, heartIconX + 10, heartIconY + 2, 0xFFFFFF);
            if (pawn instanceof IHungerAwareEntity) {
                IHungerAwareEntity hungerAwareEntity = (IHungerAwareEntity)pawn;
                String hungerString = String.format("%d/%d", hungerAwareEntity.getCurrentFoodLevel(), 20);
                int hungerIconX = 0 + width / 2 + 5;
                this.renderIcon(drawContext, hungerIconX, heartIconY, 28);
                drawContext.method_25303(this.textRenderer, hungerString, hungerIconX + 10, heartIconY + 2, 0xFFFFFF);
            }
            if (pawn instanceof IProfessional) {
                IProfessional professional = (IProfessional)pawn;
                String professionId = professional.getProfessionId();
                String professionName = Optional.ofNullable(fortressManager.getProfessionManager().getProfession(professionId)).map(IProfession::getTitle).orElse("");
                Objects.requireNonNull(this.textRenderer);
                drawContext.method_25303(this.textRenderer, "Profession:", 5, heartIconY + 9 + 5, 0xFFFFFF);
                Objects.requireNonNull(this.textRenderer);
                drawContext.method_25303(this.textRenderer, professionName, 5, heartIconY + 2 * 9 + 5, 0xFFFFFF);
            }
            if (pawn instanceof Colonist) {
                Colonist colonist = (Colonist)pawn;
                Objects.requireNonNull(this.textRenderer);
                drawContext.method_25303(this.textRenderer, "Task:", 5, heartIconY + 3 * 9 + 10, 0xFFFFFF);
                String task = colonist.getCurrentTaskDesc();
                Objects.requireNonNull(this.textRenderer);
                drawContext.method_25303(this.textRenderer, task, 5, heartIconY + 4 * 9 + 10, 0xFFFFFF);
            }
        }
    }

    private void renderIcon(class_332 drawContext, int iconX, int iconY, int heartIconV) {
        drawContext.method_25291(class_329.field_44654, iconX, iconY, 110, 52.0f, (float)heartIconV, 8, 8, 256, 256);
    }

    @Override
    public boolean shouldRender(HudState hudState) {
        return hudState == HudState.BUILD;
    }
}

