/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.renderer.gui.hud;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_757;
import net.remmintan.mods.minefortress.core.FortressState;
import net.remmintan.mods.minefortress.core.interfaces.client.IClientFortressManager;
import org.minefortress.blueprints.world.BlueprintsWorld;
import org.minefortress.renderer.gui.hud.AreasHudLayer;
import org.minefortress.renderer.gui.hud.ColonistsHudLayer;
import org.minefortress.renderer.gui.hud.FightHudLayer;
import org.minefortress.renderer.gui.hud.HoveredEntityHudLayer;
import org.minefortress.renderer.gui.hud.HudState;
import org.minefortress.renderer.gui.hud.InluenceHudLayer;
import org.minefortress.renderer.gui.hud.ModeHudLayer;
import org.minefortress.renderer.gui.hud.SelectedColonistHudLayer;
import org.minefortress.renderer.gui.hud.TimeHudLayer;
import org.minefortress.renderer.gui.hud.ToolsHudLayer;
import org.minefortress.renderer.gui.hud.UtilsHudLayer;
import org.minefortress.renderer.gui.hud.hints.BlueprintEditingHintsLayer;
import org.minefortress.renderer.gui.hud.hints.BuildBlueprintHintsLayer;
import org.minefortress.renderer.gui.hud.hints.BuildHintsLayer;
import org.minefortress.renderer.gui.hud.hints.BuildRoadsHintsLayer;
import org.minefortress.renderer.gui.hud.hints.ChopTreesHintsLayer;
import org.minefortress.renderer.gui.hud.hints.CombatHintsLayer;
import org.minefortress.renderer.gui.hud.hints.InitializationHintsLayer;
import org.minefortress.renderer.gui.hud.interfaces.IHintsLayer;
import org.minefortress.renderer.gui.hud.interfaces.IHudLayer;
import org.minefortress.utils.ModUtils;

public class FortressHud {
    private final class_310 client;
    public static final int MOD_GUI_COLOR = 0xF0F0F0;
    private final List<IHintsLayer> hintsLayers = new ArrayList<IHintsLayer>();
    private final List<IHudLayer> hudLayers = new ArrayList<IHudLayer>();

    public FortressHud(class_310 client) {
        this.client = client;
        this.hintsLayers.add(new InitializationHintsLayer());
        this.hintsLayers.add(new BlueprintEditingHintsLayer());
        this.hintsLayers.add(new BuildBlueprintHintsLayer());
        this.hintsLayers.add(new BuildHintsLayer());
        this.hintsLayers.add(new BuildRoadsHintsLayer());
        this.hintsLayers.add(new ChopTreesHintsLayer());
        this.hintsLayers.add(new CombatHintsLayer());
        this.hudLayers.add(new ModeHudLayer(client));
        this.hudLayers.add(new ColonistsHudLayer(client));
        this.hudLayers.add(new SelectedColonistHudLayer(client));
        this.hudLayers.add(new HoveredEntityHudLayer(client));
        this.hudLayers.add(new ToolsHudLayer(client));
        this.hudLayers.add(new TimeHudLayer(client));
        this.hudLayers.add(new FightHudLayer(client));
        this.hudLayers.add(new AreasHudLayer(client));
        this.hudLayers.add(new InluenceHudLayer(client));
        this.hudLayers.add(new UtilsHudLayer(client));
    }

    public void render(class_332 drawContext, float delta) {
        if (this.isHudHidden()) {
            return;
        }
        this.prepareRenderSystem();
        int scaledWidth = this.client.method_22683().method_4486();
        int scaledHeight = this.client.method_22683().method_4502();
        int mouseX = (int)(this.client.field_1729.method_1603() * (double)scaledWidth / (double)this.client.method_22683().method_4480());
        int mouseY = (int)(this.client.field_1729.method_1604() * (double)scaledHeight / (double)this.client.method_22683().method_4507());
        class_327 font = this.client.field_1772;
        for (IHintsLayer iHintsLayer : this.hintsLayers) {
            if (!iHintsLayer.shouldRender(this.getState())) continue;
            iHintsLayer.render(drawContext, font, scaledWidth, scaledHeight, mouseX, mouseY, delta);
        }
        for (IHudLayer iHudLayer : this.hudLayers) {
            if (!iHudLayer.shouldRender(this.getState())) continue;
            iHudLayer.render(drawContext, font, scaledWidth, scaledHeight, mouseX, mouseY, delta);
        }
    }

    private void prepareRenderSystem() {
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShader(class_757::method_34542);
    }

    public void tick() {
        for (IHudLayer layer : this.hudLayers) {
            if (!layer.shouldRender(this.getState())) continue;
            layer.tick();
        }
    }

    public boolean isHovered() {
        if (this.isHudHidden()) {
            return false;
        }
        for (IHudLayer layer : this.hudLayers) {
            if (!layer.shouldRender(this.getState()) || !layer.isHovered()) continue;
            return true;
        }
        return false;
    }

    public void onClick(double mouseX, double mouseY) {
        if (this.isHudHidden()) {
            return;
        }
        for (IHudLayer layer : this.hudLayers) {
            if (!layer.shouldRender(this.getState())) continue;
            layer.onClick(mouseX, mouseY);
        }
    }

    private HudState getState() {
        IClientFortressManager fortressClientManager = ModUtils.getFortressClientManager();
        if (fortressClientManager.notInitialized()) {
            return HudState.BLANK;
        }
        if (fortressClientManager.isCenterNotSet()) {
            return HudState.INITIALIZING;
        }
        if (ModUtils.getBlueprintManager().isSelecting()) {
            return HudState.BLUEPRINT;
        }
        if (BlueprintsWorld.isBlueprintsWorld((class_1937)this.client.field_1687)) {
            return HudState.BLUEPRINT_EDITING;
        }
        return switch (ModUtils.getFortressClientManager().getState()) {
            default -> throw new IncompatibleClassChangeError();
            case FortressState.BUILD -> HudState.BUILD;
            case FortressState.COMBAT -> HudState.COMBAT;
            case FortressState.AREAS_SELECTION -> HudState.AREAS_SELECTION;
        };
    }

    private boolean isHudHidden() {
        return this.client.field_1690.field_1842 || this.client.field_1690.field_1866;
    }
}

