/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.renderer.gui.hud;

import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2470;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.remmintan.mods.minefortress.core.dtos.combat.MousePos;
import net.remmintan.mods.minefortress.core.interfaces.combat.IClientFightSelectionManager;
import net.remmintan.mods.minefortress.core.interfaces.infuence.IClientInfluenceManager;
import net.remmintan.mods.minefortress.core.interfaces.resources.IClientResourceManager;
import net.remmintan.mods.minefortress.core.interfaces.resources.IItemInfo;
import net.remmintan.mods.minefortress.core.utils.CoreModUtils;
import org.minefortress.renderer.gui.blueprints.BlueprintsScreen;
import org.minefortress.renderer.gui.hud.AbstractHudLayer;
import org.minefortress.renderer.gui.hud.HudState;
import org.minefortress.utils.ModUtils;

class FightHudLayer
extends AbstractHudLayer {
    private static final int SELECTION_COLOR = -16711936;

    FightHudLayer(class_310 client) {
        super(client);
        this.setBasepoint(0, 0, AbstractHudLayer.PositionX.LEFT, AbstractHudLayer.PositionY.TOP);
    }

    @Override
    protected void renderHud(class_332 drawContext, int screenWidth, int screenHeight) {
        IClientFightSelectionManager fightSelectionManager;
        IClientInfluenceManager influenceManager = CoreModUtils.getMineFortressManagersProvider().get_InfluenceManager();
        if (influenceManager.isSelecting() && ModUtils.getFortressClientManager().isSurvival()) {
            List<IItemInfo> stacks = influenceManager.getBlockDataProvider().getBlockData("influence_flag", class_2470.field_11467).getStacks();
            IClientResourceManager resourceManager = ModUtils.getFortressClientManager().getResourceManager();
            for (int i1 = 0; i1 < stacks.size(); ++i1) {
                IItemInfo stack = stacks.get(i1);
                boolean hasItem = resourceManager.hasItem(stack, stacks);
                int itemX = screenWidth / 2 - 55 + i1 % 10 * 30;
                int itemY = i1 / 10 * 20 + screenHeight - 40;
                class_1792 convertedItem = BlueprintsScreen.convertItemIconInTheGUI(stack);
                drawContext.method_51427(new class_1799((class_1935)convertedItem), itemX, itemY);
                drawContext.method_51433(this.textRenderer, String.valueOf(stack.amount()), itemX + 17, itemY + 7, hasItem ? 0xFFFFFF : 0xFF0000, false);
            }
        }
        if ((fightSelectionManager = this.getFightSelectionManager()).isSelecting()) {
            MousePos selectionStartPos = fightSelectionManager.getSelectionStartPos();
            MousePos selectionCurPos = fightSelectionManager.getSelectionCurPos();
            double widthScaleFactor = (double)this.client.method_22683().method_4486() / (double)this.client.method_22683().method_4480();
            double heightScaleFactor = (double)this.client.method_22683().method_4502() / (double)this.client.method_22683().method_4507();
            int selectionStartX = (int)(selectionStartPos.x() * widthScaleFactor);
            int selectionStartY = (int)(selectionStartPos.y() * heightScaleFactor);
            int selectionCurX = (int)(selectionCurPos.x() * widthScaleFactor);
            int selectionCurY = (int)(selectionCurPos.y() * heightScaleFactor);
            drawContext.method_25292(selectionStartX, selectionCurX, selectionStartY, -16711936);
            drawContext.method_25301(selectionCurX, selectionStartY, selectionCurY, -16711936);
            drawContext.method_25292(selectionStartX, selectionCurX, selectionCurY, -16711936);
            drawContext.method_25301(selectionStartX, selectionStartY, selectionCurY, -16711936);
        }
    }

    private IClientFightSelectionManager getFightSelectionManager() {
        return ModUtils.getFortressClientManager().getFightManager().getSelectionManager();
    }

    @Override
    public boolean shouldRender(HudState hudState) {
        return hudState == HudState.COMBAT;
    }
}

