/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.renderer.gui.hud;

import net.minecraft.class_1657;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_481;
import net.minecraft.class_7699;
import net.remmintan.mods.minefortress.core.ScreenType;
import net.remmintan.mods.minefortress.core.utils.CoreModUtils;
import net.remmintan.mods.minefortress.networking.c2s.ServerboundOpenCraftingScreenPacket;
import net.remmintan.mods.minefortress.networking.helpers.FortressClientNetworkHelper;
import org.minefortress.fortress.resources.gui.craft.MissingCraftsmanScreen;
import org.minefortress.fortress.resources.gui.smelt.MissingBlacksmithScreen;
import org.minefortress.renderer.gui.ColonistsScreen;
import org.minefortress.renderer.gui.hud.AbstractHudLayer;
import org.minefortress.renderer.gui.hud.HudState;
import org.minefortress.renderer.gui.professions.ProfessionsScreen;
import org.minefortress.renderer.gui.widget.DynamicTextButtonWidget;
import org.minefortress.renderer.gui.widget.ItemButtonWidget;
import org.minefortress.renderer.gui.widget.ItemHudElement;
import org.minefortress.utils.ModUtils;

public class ColonistsHudLayer
extends AbstractHudLayer {
    private final ItemButtonWidget furnaceButton;
    private final ItemButtonWidget craftingButton;

    protected ColonistsHudLayer(class_310 client) {
        super(client);
        this.addElement(new DynamicTextButtonWidget(15, 0, 20, 20, btn -> client.method_1507((class_437)new ColonistsScreen()), "Manage pawns", this::getColonistsCountText));
        this.addElement(new ItemButtonWidget(35, 0, class_1802.field_8575, btn -> client.method_1507((class_437)new ProfessionsScreen(CoreModUtils.getMineFortressManagersProvider())), "Manage professions"));
        this.addElement(new ItemButtonWidget(55, 0, class_1802.field_8106, btn -> client.method_1507((class_437)new class_481((class_1657)client.field_1724, class_7699.method_45397(), false)), "Inventory"));
        this.craftingButton = new ItemButtonWidget(75, 0, class_1802.field_8465, btn -> {
            if (this.hasProfessionInAVillage("crafter")) {
                FortressClientNetworkHelper.send("fortress_open_crafting_table", new ServerboundOpenCraftingScreenPacket(ScreenType.CRAFTING));
            } else {
                this.client.method_1507((class_437)new MissingCraftsmanScreen());
            }
        }, "Crafting");
        this.furnaceButton = new ItemButtonWidget(95, 0, class_1802.field_8732, btn -> {
            if (this.hasProfessionInAVillage("blacksmith")) {
                if (ModUtils.getFortressClientManager().hasRequiredBlock(class_2246.field_10181, true, 0)) {
                    FortressClientNetworkHelper.send("fortress_open_crafting_table", new ServerboundOpenCraftingScreenPacket(ScreenType.FURNACE));
                } else {
                    this.client.method_1507((class_437)new MissingBlacksmithScreen(true));
                }
            } else {
                this.client.method_1507((class_437)new MissingBlacksmithScreen(false));
            }
        }, "Furnace");
        this.addElement(this.craftingButton);
        this.addElement(this.furnaceButton);
        this.addElement(new ItemHudElement(0, 3, class_1802.field_8575));
        this.setBasepoint(-91, -43, AbstractHudLayer.PositionX.CENTER, AbstractHudLayer.PositionY.BOTTOM);
    }

    private String getColonistsCountText() {
        return "x" + ModUtils.getFortressClientManager().getTotalColonistsCount();
    }

    private boolean hasProfessionInAVillage(String professionId) {
        return ModUtils.isClientInFortressGamemode() && ModUtils.getProfessionManager().hasProfession(professionId);
    }

    @Override
    public void tick() {
        super.tick();
        if (ModUtils.getFortressClientManager().isCreative()) {
            this.craftingButton.field_22764 = false;
            this.furnaceButton.field_22764 = false;
        } else {
            this.craftingButton.field_22764 = true;
            this.furnaceButton.field_22764 = true;
        }
    }

    @Override
    public boolean shouldRender(HudState hudState) {
        return hudState == HudState.BUILD;
    }
}

