/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.renderer.gui.hud;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_918;
import org.minefortress.renderer.gui.hud.interfaces.IHudButton;
import org.minefortress.renderer.gui.hud.interfaces.IHudElement;
import org.minefortress.renderer.gui.hud.interfaces.IHudLayer;
import org.minefortress.utils.ModUtils;

public abstract class AbstractHudLayer
implements IHudLayer {
    private final List<IHudElement> fortressHudElements = new ArrayList<IHudElement>();
    protected final class_310 client;
    protected final class_918 itemRenderer;
    protected final class_327 textRenderer;
    private Integer basepointX;
    private Integer basepointY;
    private PositionX positionX;
    private PositionY positionY;
    private boolean initialized = false;

    protected AbstractHudLayer(class_310 client) {
        this.client = client;
        this.itemRenderer = client.method_1480();
        this.textRenderer = client.field_1772;
    }

    protected void init() {
    }

    protected final void setBasepoint(int x, int y, PositionX positionX, PositionY positionY) {
        this.basepointX = x;
        this.basepointY = y;
        this.positionX = positionX;
        this.positionY = positionY;
    }

    protected final void addElement(IHudElement ... buttons) {
        this.fortressHudElements.addAll(Arrays.asList(buttons));
    }

    @Override
    public void tick() {
        if (!this.initialized) {
            this.init();
            this.initialized = true;
        }
        for (IHudElement button : this.fortressHudElements) {
            button.tick();
        }
    }

    @Override
    public final void render(class_332 drawContext, class_327 font, int screenWidth, int screenHeight, double mouseX, double mouseY, float delta) {
        if (this.basepointX == null || this.basepointY == null) {
            throw new IllegalStateException("Basepoint not set!");
        }
        this.renderHud(drawContext, screenWidth, screenHeight);
        int baseX = switch (this.positionX) {
            default -> throw new IncompatibleClassChangeError();
            case PositionX.LEFT -> this.basepointX;
            case PositionX.RIGHT -> screenWidth + this.basepointX;
            case PositionX.CENTER -> screenWidth / 2 + this.basepointX;
        };
        int baseY = switch (this.positionY) {
            default -> throw new IncompatibleClassChangeError();
            case PositionY.TOP -> this.basepointY;
            case PositionY.BOTTOM -> screenHeight + this.basepointY;
            case PositionY.CENTER -> screenHeight / 2 + this.basepointY;
        };
        boolean creative = ModUtils.getFortressClientManager().isCreative();
        for (IHudElement fortressHudButton : this.fortressHudElements) {
            fortressHudButton.setPosBasedOn(baseX, baseY);
            if (!fortressHudButton.shouldRender(creative)) continue;
            fortressHudButton.method_25394(drawContext, (int)mouseX, (int)mouseY, delta);
        }
    }

    protected void renderHud(class_332 drawContext, int screenWidth, int screenHeight) {
    }

    @Override
    public final boolean isHovered() {
        for (IHudElement fortressHudButton : this.fortressHudElements) {
            if (!fortressHudButton.method_49606()) continue;
            return true;
        }
        return false;
    }

    @Override
    public final void onClick(double mouseX, double mouseY) {
        for (IHudElement elem : this.fortressHudElements) {
            if (!(elem instanceof IHudButton)) continue;
            IHudButton btn = (IHudButton)elem;
            if (!elem.method_49606()) continue;
            btn.method_25348(mouseX, mouseY);
            return;
        }
    }

    public static enum PositionX {
        LEFT,
        RIGHT,
        CENTER;

    }

    public static enum PositionY {
        TOP,
        BOTTOM,
        CENTER;

    }
}

