/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.renderer.gui.hire;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_2561;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.remmintan.mods.minefortress.networking.c2s.C2SCloseHireMenuPacket;
import net.remmintan.mods.minefortress.networking.helpers.FortressClientNetworkHelper;
import org.jetbrains.annotations.NotNull;
import org.minefortress.professions.hire.IHireScreenHandler;
import org.minefortress.renderer.gui.WindowScreen;
import org.minefortress.renderer.gui.widget.CostsWidget;
import org.minefortress.renderer.gui.widget.FreePawnsWidget;
import org.minefortress.renderer.gui.widget.ProfessionAmountWidget;
import org.minefortress.renderer.gui.widget.ProfessionNameWidget;
import org.minefortress.renderer.gui.widget.ProfessionQueueWidget;
import org.minefortress.renderer.gui.widget.ProgressArrowWidget;
import org.minefortress.utils.ModUtils;

public class HirePawnScreen
extends WindowScreen {
    private final List<HireButtonWithInfo> hireButtons = new ArrayList<HireButtonWithInfo>();
    private final IHireScreenHandler handler;

    public HirePawnScreen(@NotNull IHireScreenHandler handler) {
        super((class_2561)class_2561.method_43470((String)handler.getScreenName()));
        this.handler = handler;
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        Set<String> professions = this.handler.getProfessions();
        this.hireButtons.clear();
        int startY = this.getScreenTopY() + 40;
        this.method_37060(new FreePawnsWidget(this.getScreenLeftX() + 10, startY - 15));
        int i = 0;
        for (String profId : professions) {
            int rowY = startY + i * 25;
            this.addNewRow(profId, rowY, this.getScreenLeftX(), this.getScreenRightX());
            ++i;
        }
    }

    public void method_25393() {
        super.method_25393();
        for (HireButtonWithInfo btn : this.hireButtons) {
            class_4185 button = btn.button;
            String profId = btn.profId;
            boolean enoughPlaceForNew = this.handler.getCurrentCount(profId) + this.handler.getHireQueue(profId) < this.handler.getMaxCount(profId);
            button.field_22763 = btn.costs.isEnough() && ModUtils.getProfessionManager().getFreeColonists() > 0 && enoughPlaceForNew;
        }
    }

    private void addNewRow(String profId, int rowY, int leftX, int rightX) {
        this.method_37060(new ProgressArrowWidget(rightX - 48, rowY, () -> this.handler.getHireProgress(profId)));
        String string = IHireScreenHandler.getProfessionName(profId);
        Objects.requireNonNull(this.field_22793);
        ProfessionNameWidget professionName = new ProfessionNameWidget(string, leftX + 10, rowY + 9 / 2 + 3);
        this.method_37060(professionName);
        CostsWidget costs = new CostsWidget(leftX + professionName.getOffset() + 15, rowY, this.handler.getCost(profId));
        this.method_37060(costs);
        class_4185 hireButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"+"), btn -> {
            if (this.canIncreaseAmount(costs, profId)) {
                this.handler.increaseAmount(profId);
            }
        }).method_46434(rightX - 100, rowY, 20, 20).method_46431();
        this.method_37063((class_364)hireButton);
        this.hireButtons.add(new HireButtonWithInfo(hireButton, costs, profId));
        this.method_37060(new ProfessionQueueWidget(rightX - 80, rowY, () -> this.handler.getHireQueue(profId)));
        this.method_37060(new ProfessionAmountWidget(rightX - 35, rowY, IHireScreenHandler.getProfessionItem(profId), () -> this.handler.getCurrentCount(profId), () -> this.handler.getMaxCount(profId)));
    }

    private boolean canIncreaseAmount(CostsWidget costs, String profId) {
        boolean enoughPlaceForNew = this.handler.getCurrentCount(profId) + this.handler.getHireQueue(profId) < this.handler.getMaxCount(profId);
        return costs.isEnough() && ModUtils.getProfessionManager().getFreeColonists() > 0 && enoughPlaceForNew;
    }

    public IHireScreenHandler getHandler() {
        return this.handler;
    }

    public void method_25419() {
        super.method_25419();
        C2SCloseHireMenuPacket packet = new C2SCloseHireMenuPacket();
        FortressClientNetworkHelper.send("close_hire_menu", packet);
    }

    private record HireButtonWithInfo(class_4185 button, CostsWidget costs, String profId) {
    }
}

