/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.renderer.gui.fortress;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_1792;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.remmintan.mods.minefortress.core.interfaces.resources.IClientResourceManager;
import net.remmintan.mods.minefortress.networking.c2s.C2SRepairBuilding;
import net.remmintan.mods.minefortress.networking.helpers.FortressClientNetworkHelper;
import org.minefortress.fortress.resources.ItemInfo;
import org.minefortress.renderer.gui.WindowScreen;
import org.minefortress.utils.BlockInfoUtils;
import org.minefortress.utils.ModUtils;

public class RepairBuildingScreen
extends WindowScreen {
    private final UUID buildingId;
    private final Map<class_1792, Long> requiredItems;
    private Map<class_1792, Boolean> hasEnoughResources;
    private final IClientResourceManager clientResourceManager;
    private final Set<class_2338> blocksToRepair;
    private class_4185 confirmationButton;

    public RepairBuildingScreen(UUID buildingId, Map<class_2338, class_2680> blocksToRepair, IClientResourceManager clientResourceManager) {
        super(class_2561.method_30163((String)"Repair Building"));
        this.buildingId = buildingId;
        this.clientResourceManager = clientResourceManager;
        this.blocksToRepair = blocksToRepair.keySet();
        this.requiredItems = BlockInfoUtils.convertBlockStatesMapItemsMap(blocksToRepair);
        this.recalculateResources();
    }

    public void method_25393() {
        super.method_25393();
        this.recalculateResources();
        this.confirmationButton.field_22763 = !this.hasEnoughResources.containsValue(false);
    }

    private void recalculateResources() {
        this.hasEnoughResources = this.requiredItems.entrySet().stream().map(it -> new ItemInfo((class_1792)it.getKey(), ((Long)it.getValue()).intValue())).collect(Collectors.toMap(ItemInfo::item, it -> this.clientResourceManager.hasItems(Collections.singletonList(it))));
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.confirmationButton = class_4185.method_46430((class_2561)class_2561.method_30163((String)"Repair"), button -> {
            UUID taskId = UUID.randomUUID();
            ModUtils.getClientTasksHolder().ifPresent(it -> it.addTask(taskId, this.blocksToRepair));
            C2SRepairBuilding packet = new C2SRepairBuilding(taskId, this.buildingId);
            FortressClientNetworkHelper.send("repair_building", packet);
            Optional.ofNullable(this.field_22787).ifPresent(it -> it.method_1507(null));
        }).method_46434(this.getScreenCenterX() - 10 - 100, this.getScreenBottomY() - 30, 100, 20).method_46431();
        this.method_37063((class_364)this.confirmationButton);
        class_4185 cancel = class_4185.method_46430((class_2561)class_2561.method_30163((String)"Cancel"), button -> this.closeScreen()).method_46434(this.getScreenCenterX() + 10, this.getScreenBottomY() - 30, 100, 20).method_46431();
        this.method_37063((class_364)cancel);
    }

    @Override
    public void method_25394(class_332 drawContext, int mouseX, int mouseY, float delta) {
        super.method_25394(drawContext, mouseX, mouseY, delta);
        class_327 textRenderer = this.field_22793;
        int x = this.getScreenLeftX() + 10;
        int y = this.getScreenTopY() + 30;
        for (class_1792 item : this.requiredItems.keySet()) {
            drawContext.method_51427(item.method_7854(), x, y);
            Long itemsAmount = this.requiredItems.get(item);
            String text = "x" + itemsAmount;
            int color = this.hasEnoughResources.get(item) != false ? 0xFFFFFF : 12066067;
            drawContext.method_51433(textRenderer, text, x + 16 + 2, y + 6, color, false);
            int columnWidth = 16 + textRenderer.method_1727(text);
            if ((x += columnWidth + 5) + columnWidth <= this.getScreenRightX() - 10) continue;
            x = this.getScreenLeftX() + 10;
            y += 20;
        }
    }
}

