/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.renderer.gui.fortress;

import java.util.Optional;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.remmintan.mods.minefortress.core.interfaces.blueprints.IBlueprintMetadata;
import net.remmintan.mods.minefortress.core.interfaces.blueprints.IBlueprintMetadataManager;
import net.remmintan.mods.minefortress.core.interfaces.buildings.IEssentialBuildingInfo;
import net.remmintan.mods.minefortress.core.interfaces.professions.IProfession;
import net.remmintan.mods.minefortress.networking.c2s.C2SDestroyBuilding;
import net.remmintan.mods.minefortress.networking.c2s.C2SOpenRepairBuildingScreen;
import net.remmintan.mods.minefortress.networking.helpers.FortressClientNetworkHelper;
import org.minefortress.renderer.gui.WindowScreen;
import org.minefortress.utils.ModUtils;

public class ManageBuildingScreen
extends WindowScreen {
    private final IEssentialBuildingInfo buildingInfo;
    private final IProfession profession;
    private final class_2561 screenName;

    public ManageBuildingScreen(IEssentialBuildingInfo essentialBuildingInfo) {
        super(class_2561.method_30163((String)"Manage Building"));
        this.buildingInfo = essentialBuildingInfo;
        IBlueprintMetadataManager blueprintMetadataManager = ModUtils.getBlueprintManager().getBlueprintMetadataManager();
        this.screenName = class_2561.method_30163((String)essentialBuildingInfo.getBlueprintId().flatMap(blueprintMetadataManager::getByBlueprintId).map(IBlueprintMetadata::getName).orElse("Unknown"));
        this.profession = ModUtils.getProfessionManager().getByBuildingRequirement(this.buildingInfo.getRequirementId()).orElse(null);
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        class_4185 xBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"X"), button -> super.closeScreen()).method_46434(this.getScreenRightX() - 25, this.getScreenTopY() + 5, 20, 20).method_46431();
        this.method_37063((class_364)xBtn);
        class_4185 destroyBuildingBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Destroy Building"), button -> this.showDestroyConfirmation()).method_46434(this.getScreenCenterX() - 100, this.getScreenTopY() + 55, 200, 20).method_46431();
        this.method_37063((class_364)destroyBuildingBtn);
        if (this.buildingInfo.getHealth() < 100) {
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Repair Building"), button -> this.openRepairBuildingScreen()).method_46434(this.getScreenCenterX() - 100, this.getScreenTopY() + 80, 200, 20).method_46431());
        }
        Optional.ofNullable(this.profession).ifPresent(it -> {
            if (it.isHireMenu()) {
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Hire pawns"), button -> ModUtils.getProfessionManager().increaseAmount(it.getId(), false)).method_46434(this.getScreenCenterX() - 100, this.getScreenTopY() + 105, 200, 20).method_46431());
            }
        });
    }

    @Override
    public void method_25394(class_332 drawContext, int mouseX, int mouseY, float delta) {
        super.method_25394(drawContext, mouseX, mouseY, delta);
        int healthInPercents = this.buildingInfo.getHealth();
        class_2561 healthText = class_2561.method_30163((String)("Health: " + healthInPercents + "%"));
        drawContext.method_51439(this.field_22793, healthText, this.getScreenLeftX() + 30, this.getScreenTopY() + 30, 0xFFFFFF, false);
    }

    private void showDestroyConfirmation() {
        if (this.field_22787 == null) {
            return;
        }
        this.field_22787.method_1507((class_437)new class_410(this::destroyBuilding, class_2561.method_30163((String)"Are you sure you want to destroy this building?"), class_2561.method_30163((String)"You will lose all resources invested in it."), class_2561.method_30163((String)"Destroy"), class_2561.method_30163((String)"Cancel")));
    }

    private void destroyBuilding(boolean confirmed) {
        if (confirmed) {
            C2SDestroyBuilding packet = new C2SDestroyBuilding(this.buildingInfo.getId());
            FortressClientNetworkHelper.send("destroy_building", packet);
            super.closeScreen();
        } else if (this.field_22787 != null) {
            this.field_22787.method_1507(null);
        }
    }

    public class_2561 method_25440() {
        return this.screenName;
    }

    private void openRepairBuildingScreen() {
        C2SOpenRepairBuildingScreen packet = new C2SOpenRepairBuildingScreen(this.buildingInfo.getId());
        FortressClientNetworkHelper.send("open-repair-building-screen", packet);
    }
}

