/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.renderer.gui.blueprints.handler;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_746;
import net.remmintan.mods.minefortress.core.interfaces.blueprints.BlueprintGroup;
import net.remmintan.mods.minefortress.core.interfaces.blueprints.IBlueprintMetadata;
import net.remmintan.mods.minefortress.core.interfaces.blueprints.IClientBlueprintManager;
import net.remmintan.mods.minefortress.core.interfaces.blueprints.IStructureBlockData;
import net.remmintan.mods.minefortress.core.interfaces.client.IClientFortressManager;
import net.remmintan.mods.minefortress.core.interfaces.client.IClientManagersProvider;
import net.remmintan.mods.minefortress.core.interfaces.resources.IClientResourceManager;
import net.remmintan.mods.minefortress.core.interfaces.resources.IItemInfo;
import net.remmintan.mods.minefortress.networking.c2s.ServerboundEditBlueprintPacket;
import net.remmintan.mods.minefortress.networking.helpers.FortressClientNetworkHelper;
import org.minefortress.interfaces.IFortressMinecraftClient;
import org.minefortress.renderer.gui.blueprints.handler.BlueprintSlot;

public final class BlueprintScreenHandler {
    private final IClientManagersProvider managersProvider;
    private BlueprintGroup selectedGroup = BlueprintGroup.LIVING_HOUSES;
    private List<BlueprintSlot> currentSlots;
    private boolean needScrollbar = false;
    private int totalSize = 0;
    private BlueprintSlot focusedSlot;

    public BlueprintScreenHandler(class_310 client) {
        if (!(client instanceof IFortressMinecraftClient)) {
            throw new IllegalArgumentException("Client must be an instance of FortressMinecraftClient");
        }
        this.managersProvider = (IClientManagersProvider)client;
        this.scroll(0.0f);
    }

    public BlueprintSlot getFocusedSlot() {
        return this.focusedSlot;
    }

    public void selectGroup(BlueprintGroup group) {
        if (group == null) {
            throw new IllegalArgumentException("Group cannot be null");
        }
        this.selectedGroup = group;
        this.scroll(0.0f);
    }

    public BlueprintGroup getSelectedGroup() {
        return this.selectedGroup;
    }

    public void scroll(float scrollPosition) {
        IClientBlueprintManager blueprintManager = this.managersProvider.get_BlueprintManager();
        IClientFortressManager fortressClientManager = this.managersProvider.get_ClientFortressManager();
        IClientResourceManager resourceManager = fortressClientManager.getResourceManager();
        List<IBlueprintMetadata> allBlueprint = blueprintManager.getAllBlueprints(this.selectedGroup);
        this.totalSize = allBlueprint.size();
        this.currentSlots = new ArrayList<BlueprintSlot>();
        int totalRows = (this.totalSize + 9 - 1) / 9 - 5;
        int skippedRows = (int)((double)(scrollPosition * (float)totalRows) + 0.5);
        if (skippedRows < 0) {
            skippedRows = 0;
        }
        for (int row = 0; row < 5; ++row) {
            for (int column = 0; column < 9; ++column) {
                int m = column + (row + skippedRows) * 9;
                if (m < 0 || m >= this.totalSize) continue;
                IBlueprintMetadata blueprintMetadata = allBlueprint.get(m);
                IStructureBlockData blockData = blueprintManager.getBlockDataProvider().getBlockData(blueprintMetadata.getId(), class_2470.field_11467);
                if (fortressClientManager.isSurvival()) {
                    List<IItemInfo> stacks = blockData.getStacks();
                    boolean hasEnoughItems = resourceManager.hasItems(stacks);
                    this.currentSlots.add(new BlueprintSlot(blueprintMetadata, hasEnoughItems, blockData));
                    continue;
                }
                this.currentSlots.add(new BlueprintSlot(blueprintMetadata, true, blockData));
            }
        }
        this.needScrollbar = this.totalSize > 45;
    }

    public void sendRemovePacket() {
        ServerboundEditBlueprintPacket packet = ServerboundEditBlueprintPacket.remove(this.getFocusedSlot().getMetadata().getId());
        FortressClientNetworkHelper.send("fortress_edit_blueprint", packet);
    }

    public void sendEditPacket() {
        IBlueprintMetadata metadata = this.focusedSlot.getMetadata();
        String file = metadata.getId();
        int floorLevel = metadata.getFloorLevel();
        ServerboundEditBlueprintPacket packet = ServerboundEditBlueprintPacket.edit(file, floorLevel, this.selectedGroup);
        FortressClientNetworkHelper.send("fortress_edit_blueprint", packet);
    }

    public void focusOnSlot(BlueprintSlot slot) {
        this.focusedSlot = slot;
    }

    public boolean hasFocusedSlot() {
        return this.focusedSlot != null;
    }

    public List<BlueprintSlot> getCurrentSlots() {
        return this.currentSlots;
    }

    public boolean isNeedScrollbar() {
        return this.needScrollbar;
    }

    public void clickOnFocusedSlot() {
        if (this.focusedSlot == null) {
            return;
        }
        if (!this.focusedSlot.isEnoughResources()) {
            class_746 player = class_310.method_1551().field_1724;
            if (player != null) {
                player.method_7353(class_2561.method_30163((String)"\u00a7cYou don't have enough resources to build this blueprint"), true);
            }
            return;
        }
        this.managersProvider.get_BlueprintManager().select(this.focusedSlot.getMetadata());
    }

    public int getSelectedGroupSize() {
        return this.totalSize;
    }

    public class_2561 getFocusedSlotName() {
        return this.focusedSlot.getTooltipText();
    }
}

