/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.renderer.gui.blueprints;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.remmintan.mods.minefortress.networking.c2s.ServerboundBlueprintsImportExportPacket;
import net.remmintan.mods.minefortress.networking.helpers.FortressClientNetworkHelper;
import org.minefortress.renderer.gui.blueprints.BlueprintsScreen;
import org.minefortress.renderer.gui.blueprints.list.BlueprintListEntry;
import org.minefortress.renderer.gui.blueprints.list.BlueprintsListWidget;
import org.minefortress.utils.ModUtils;

public class ImportExportBlueprintsScreen
extends class_437 {
    private static final class_2561 DEFAULT_LABEL = class_2561.method_43470((String)"Import/Export Blueprints");
    private static final class_2561 IMPORT_LABEL = class_2561.method_43470((String)"Importing...");
    private static final class_2561 IMPORT_PROMPT_LABEL = class_2561.method_43470((String)"Select blueprints to import");
    private static final class_2561 EXPORT_LABEL = class_2561.method_43470((String)"Exporting...");
    private static final class_2561 EXPORT_PROMPT_LABEL = class_2561.method_43470((String)"Enter file name:");
    private static final class_2561 IMPORT_SUCCESS = class_2561.method_43470((String)"Imported successfully!");
    private static final class_2561 EXPORT_SUCCESS = class_2561.method_43470((String)"Exported successfully!");
    private static final class_2561 IMPORT_FAILURE = class_2561.method_43470((String)"Import failed!");
    private static final class_2561 EXPORT_FAILURE = class_2561.method_43470((String)"Export failed!");
    private ScreenState state = ScreenState.DEFAULT;
    private class_4185 backButton;
    private class_4185 importButton;
    private class_4185 exportButton;
    private class_342 exportName;
    private class_4185 exportConfirm;
    private class_4185 exportCancel;
    private BlueprintsListWidget importsList;
    private class_4185 importConfirm;
    private class_4185 importOpenFolder;
    private class_4185 importRefresh;
    private class_4185 importCancel;
    private class_2561 label = DEFAULT_LABEL;

    public ImportExportBlueprintsScreen() {
        super((class_2561)class_2561.method_43470((String)"Import/Export Blueprints"));
    }

    protected void method_25426() {
        if (!ModUtils.isClientInFortressGamemode()) {
            this.closeMenu();
            return;
        }
        int x = this.field_22789 / 2 - 102;
        int y = this.field_22790 / 4 + 8;
        int width = 204;
        int height = 20;
        int step = 24;
        this.initDefaultButtons(x, y, 204, 20, 24);
        this.initExportPrompt(x, y, 204, 20, 24);
        this.initImportPrompt(x, y, 204, 20, 24);
    }

    private void initImportPrompt(int x, int y, int width, int height, int step) {
        int listHeight = 100;
        int listInternalPadding = 5;
        this.importsList = new BlueprintsListWidget(this.field_22787, width, this.field_22790, y - 10 - 5, y + 100 - 5, height);
        this.importsList.method_25333(-1000);
        this.importConfirm = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Import"), button -> {
            this.setState(ScreenState.IMPORTING);
            BlueprintListEntry selected = (BlueprintListEntry)this.importsList.method_25334();
            if (selected != null) {
                try {
                    Path file = ModUtils.getBlueprintsFolder().resolve(selected.getValue());
                    byte[] bytes = Files.readAllBytes(file);
                    ServerboundBlueprintsImportExportPacket packet = new ServerboundBlueprintsImportExportPacket(bytes);
                    FortressClientNetworkHelper.send("fortress_blueprints_import_export", packet);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.setState(ScreenState.IMPORT_FAILURE);
                }
            }
        }).method_46434(x, y + 100, width, height).method_46431();
        this.importConfirm.field_22764 = false;
        this.importOpenFolder = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Open Folder"), button -> this.openBlueprintsFolder()).method_46434(x, y + 100 + step, width / 2 - 1, height).method_46431();
        this.importOpenFolder.field_22764 = false;
        this.importRefresh = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Refresh list"), button -> this.refreshImportsList()).method_46434(x + width / 2 + 2, y + 100 + step, width / 2 - 1, height).method_46431();
        this.importRefresh.field_22764 = false;
        this.importCancel = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Cancel"), button -> this.setState(ScreenState.DEFAULT)).method_46434(x, y + 100 + step * 2, width, height).method_46431();
        this.importCancel.field_22764 = false;
        this.method_37063((class_364)this.importsList);
        this.method_37063((class_364)this.importConfirm);
        this.method_37063((class_364)this.importOpenFolder);
        this.method_37063((class_364)this.importRefresh);
        this.method_37063((class_364)this.importCancel);
    }

    private void openBlueprintsFolder() {
        try {
            File blueprintsFolder = ModUtils.getBlueprintsFolder().toFile();
            if (!blueprintsFolder.exists()) {
                blueprintsFolder.mkdirs();
            }
            class_156.method_668().method_672(blueprintsFolder);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setState(ScreenState.IMPORT_FAILURE);
        }
    }

    private void initExportPrompt(int x, int y, int width, int height, int step) {
        this.exportName = new class_342(this.field_22793, x, y, width, height, (class_2561)class_2561.method_43470((String)""));
        this.exportName.field_22764 = false;
        this.exportConfirm = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Export"), button -> {
            this.setState(ScreenState.EXPORTING);
            String text = this.exportName.method_1882();
            Object fileName = text.endsWith(".blueprints") ? text : text + ".blueprints";
            ServerboundBlueprintsImportExportPacket packet = new ServerboundBlueprintsImportExportPacket((String)fileName);
            FortressClientNetworkHelper.send("fortress_blueprints_import_export", packet);
        }).method_46434(x, y + step, width, height).method_46431();
        this.exportConfirm.field_22764 = false;
        this.exportCancel = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Cancel"), button -> this.setState(ScreenState.DEFAULT)).method_46434(x, y + step * 2, width, height).method_46431();
        this.exportCancel.field_22764 = false;
        this.method_37063((class_364)this.exportName);
        this.method_37063((class_364)this.exportConfirm);
        this.method_37063((class_364)this.exportCancel);
    }

    private void initDefaultButtons(int x, int y, int width, int height, int step) {
        this.backButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Back"), button -> class_310.method_1551().method_1507((class_437)new BlueprintsScreen())).method_46434(x, y, width, height).method_46431();
        this.exportButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Export blueprints"), button -> this.setState(ScreenState.EXPORT_PROMPT)).method_46434(x, y + step, width, height).method_46431();
        this.importButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Import blueprints"), button -> {
            this.setState(ScreenState.IMPORT_PROMPT);
            this.refreshImportsList();
        }).method_46434(x, y + step * 2, width, height).method_46431();
        this.method_37063((class_364)this.backButton);
        this.method_37063((class_364)this.exportButton);
        this.method_37063((class_364)this.importButton);
    }

    public void method_25393() {
        switch (this.state) {
            case DEFAULT: {
                this.setDefaultState();
                break;
            }
            case IMPORTING: {
                this.setImportingState();
                break;
            }
            case IMPORT_PROMPT: {
                this.setImportPromptState();
                break;
            }
            case EXPORTING: {
                this.setExportingState();
                break;
            }
            case EXPORT_PROMPT: {
                this.setExportPromptState();
                break;
            }
            case IMPORT_SUCCESS: {
                this.setImportSuccessState();
                break;
            }
            case EXPORT_SUCCESS: {
                this.setExportSuccessState();
                break;
            }
            case IMPORT_FAILURE: {
                this.setImportFailureState();
                break;
            }
            case EXPORT_FAILURE: {
                this.setExportFailureState();
            }
        }
    }

    public void method_25394(class_332 drawContext, int mouseX, int mouseY, float delta) {
        super.method_25420(drawContext);
        super.method_25394(drawContext, mouseX, mouseY, delta);
        drawContext.method_27534(this.field_22793, this.label, this.field_22789 / 2, 40, 0xFFFFFF);
    }

    public void method_25419() {
        if (this.state == ScreenState.IMPORTING || this.state == ScreenState.EXPORTING) {
            return;
        }
        class_310.method_1551().method_1507((class_437)new BlueprintsScreen());
    }

    public void fail() {
        switch (this.state) {
            case IMPORTING: 
            case IMPORT_PROMPT: {
                this.setState(ScreenState.IMPORT_FAILURE);
                break;
            }
            case EXPORTING: 
            case EXPORT_PROMPT: {
                this.setState(ScreenState.EXPORT_FAILURE);
                break;
            }
            default: {
                this.setState(ScreenState.DEFAULT);
            }
        }
    }

    public void success() {
        switch (this.state) {
            case IMPORTING: 
            case IMPORT_PROMPT: {
                this.setState(ScreenState.IMPORT_SUCCESS);
                break;
            }
            case EXPORTING: 
            case EXPORT_PROMPT: {
                this.openBlueprintsFolder();
                this.setState(ScreenState.EXPORT_SUCCESS);
                break;
            }
            default: {
                this.setState(ScreenState.DEFAULT);
            }
        }
    }

    private void closeMenu() {
        class_310.method_1551().method_1507((class_437)new BlueprintsScreen());
    }

    private void setDefaultState() {
        this.backButton.field_22764 = true;
        this.exportButton.field_22764 = true;
        this.importButton.field_22764 = true;
        this.exportName.method_1852("");
        this.exportName.field_22764 = false;
        this.exportConfirm.field_22764 = false;
        this.exportCancel.field_22764 = false;
        this.importsList.method_25333(-1000);
        this.importConfirm.field_22764 = false;
        this.importOpenFolder.field_22764 = false;
        this.importRefresh.field_22764 = false;
        this.importCancel.field_22764 = false;
        this.label = DEFAULT_LABEL;
    }

    private void setExportPromptState() {
        this.backButton.field_22764 = false;
        this.exportButton.field_22764 = false;
        this.importButton.field_22764 = false;
        this.exportName.field_22764 = true;
        this.exportConfirm.field_22764 = true;
        this.exportCancel.field_22764 = true;
        this.importsList.method_25333(-1000);
        this.importConfirm.field_22764 = false;
        this.importOpenFolder.field_22764 = false;
        this.importRefresh.field_22764 = false;
        this.importCancel.field_22764 = false;
        this.label = EXPORT_PROMPT_LABEL;
    }

    private void setExportingState() {
        this.backButton.field_22764 = false;
        this.exportButton.field_22764 = false;
        this.importButton.field_22764 = false;
        this.exportName.method_1852("");
        this.exportName.field_22764 = false;
        this.exportConfirm.field_22764 = false;
        this.exportCancel.field_22764 = false;
        this.importsList.method_25333(-1000);
        this.importConfirm.field_22764 = false;
        this.importOpenFolder.field_22764 = false;
        this.importRefresh.field_22764 = false;
        this.importCancel.field_22764 = false;
        this.label = EXPORT_LABEL;
    }

    private void setImportPromptState() {
        this.backButton.field_22764 = false;
        this.exportButton.field_22764 = false;
        this.importButton.field_22764 = false;
        this.exportName.method_1852("");
        this.exportName.field_22764 = false;
        this.exportConfirm.field_22764 = false;
        this.exportCancel.field_22764 = false;
        this.importsList.method_25333(this.field_22789 / 2 - 102);
        this.importConfirm.field_22764 = true;
        this.importOpenFolder.field_22764 = true;
        this.importRefresh.field_22764 = true;
        this.importCancel.field_22764 = true;
        this.label = IMPORT_PROMPT_LABEL;
        this.importConfirm.field_22763 = this.importsList.method_25334() != null;
    }

    private void setImportingState() {
        this.backButton.field_22764 = false;
        this.exportButton.field_22764 = false;
        this.importButton.field_22764 = false;
        this.exportName.method_1852("");
        this.exportName.field_22764 = false;
        this.exportConfirm.field_22764 = false;
        this.exportCancel.field_22764 = false;
        this.importsList.method_25333(-1000);
        this.importConfirm.field_22764 = false;
        this.importOpenFolder.field_22764 = false;
        this.importRefresh.field_22764 = false;
        this.importCancel.field_22764 = false;
        this.label = IMPORT_LABEL;
    }

    private void setImportSuccessState() {
        this.backButton.field_22764 = true;
        this.exportButton.field_22764 = false;
        this.importButton.field_22764 = false;
        this.exportName.method_1852("");
        this.exportName.field_22764 = false;
        this.exportConfirm.field_22764 = false;
        this.exportCancel.field_22764 = false;
        this.importsList.method_25333(-1000);
        this.importConfirm.field_22764 = false;
        this.importOpenFolder.field_22764 = false;
        this.importRefresh.field_22764 = false;
        this.importCancel.field_22764 = false;
        this.label = IMPORT_SUCCESS;
    }

    public boolean method_25421() {
        return false;
    }

    private void setExportSuccessState() {
        this.backButton.field_22764 = true;
        this.exportButton.field_22764 = false;
        this.importButton.field_22764 = false;
        this.exportName.method_1852("");
        this.exportName.field_22764 = false;
        this.exportConfirm.field_22764 = false;
        this.exportCancel.field_22764 = false;
        this.importsList.method_25333(-1000);
        this.importConfirm.field_22764 = false;
        this.importOpenFolder.field_22764 = false;
        this.importRefresh.field_22764 = false;
        this.importCancel.field_22764 = false;
        this.label = EXPORT_SUCCESS;
    }

    private void setImportFailureState() {
        this.backButton.field_22764 = true;
        this.exportButton.field_22764 = false;
        this.importButton.field_22764 = false;
        this.exportName.method_1852("");
        this.exportName.field_22764 = false;
        this.exportConfirm.field_22764 = false;
        this.exportCancel.field_22764 = false;
        this.importsList.method_25333(-1000);
        this.importConfirm.field_22764 = false;
        this.importOpenFolder.field_22764 = false;
        this.importRefresh.field_22764 = false;
        this.importCancel.field_22764 = false;
        this.label = IMPORT_FAILURE;
    }

    private void setExportFailureState() {
        this.backButton.field_22764 = true;
        this.exportButton.field_22764 = false;
        this.importButton.field_22764 = false;
        this.exportName.method_1852("");
        this.exportName.field_22764 = false;
        this.exportConfirm.field_22764 = false;
        this.exportCancel.field_22764 = false;
        this.importsList.method_25333(-1000);
        this.importConfirm.field_22764 = false;
        this.importOpenFolder.field_22764 = false;
        this.importRefresh.field_22764 = false;
        this.importCancel.field_22764 = false;
        this.label = EXPORT_FAILURE;
    }

    private void setState(ScreenState state) {
        this.state = state;
    }

    private void refreshImportsList() {
        try {
            Path blueprintsFolder = ModUtils.getBlueprintsFolder();
            if (Files.notExists(blueprintsFolder, new LinkOption[0])) {
                Files.createDirectories(blueprintsFolder, new FileAttribute[0]);
            }
            List<BlueprintListEntry> fileNamesList = Files.list(blueprintsFolder).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toString().endsWith(".blueprints")).map(Path::getFileName).map(Path::toString).map(it -> new BlueprintListEntry((String)it, this.field_22793, this.importsList)).toList();
            this.importsList.method_25396().clear();
            this.importsList.method_25396().addAll(fileNamesList);
            if (!this.importsList.method_25396().isEmpty()) {
                this.importsList.method_25313((class_350.class_351)((BlueprintListEntry)((Object)this.importsList.method_25396().get(0))));
            } else {
                this.importsList.method_25313(null);
            }
        }
        catch (Exception e) {
            this.fail();
        }
    }

    private static enum ScreenState {
        DEFAULT,
        EXPORT_PROMPT,
        EXPORTING,
        IMPORT_PROMPT,
        IMPORTING,
        EXPORT_SUCCESS,
        EXPORT_FAILURE,
        IMPORT_SUCCESS,
        IMPORT_FAILURE;

    }
}

