/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.renderer.gui.blueprints;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_757;
import net.remmintan.mods.minefortress.core.interfaces.blueprints.BlueprintGroup;
import net.remmintan.mods.minefortress.core.interfaces.blueprints.IBlueprintMetadata;
import net.remmintan.mods.minefortress.core.interfaces.client.IClientFortressManager;
import net.remmintan.mods.minefortress.core.interfaces.resources.IClientResourceManager;
import net.remmintan.mods.minefortress.core.interfaces.resources.IItemInfo;
import net.remmintan.panama.renderer.BlueprintRenderer;
import org.minefortress.renderer.gui.blueprints.AddBlueprintScreen;
import org.minefortress.renderer.gui.blueprints.ImportExportBlueprintsScreen;
import org.minefortress.renderer.gui.blueprints.handler.BlueprintScreenHandler;
import org.minefortress.renderer.gui.blueprints.handler.BlueprintSlot;
import org.minefortress.utils.ModUtils;

public final class BlueprintsScreen
extends class_437 {
    private static final class_2960 INVENTORY_TABS_TEXTURE = new class_2960("textures/gui/container/creative_inventory/tabs.png");
    private static final String BACKGROUND_TEXTURE = "textures/gui/container/creative_inventory/tab_items.png";
    private static final class_2960 BLUEPRINT_PREVIEW_BACKGROUND_TEXTURE = new class_2960("textures/gui/recipe_book.png");
    private static final class_2561 EDIT_BLUEPRINT_TEXT = class_2561.method_43470((String)"right click to edit");
    private static final class_2561 ADD_BLUEPRINT_TEXT = class_2561.method_43470((String)"click to add blueprint");
    private static final class_2561 DELETE_BLUEPRINT_TEXT = class_2561.method_43470((String)"right click to delete");
    private final int backgroundWidth = 195;
    private final int backgroundHeight = 136;
    private final int previewWidth = 120;
    private final int previewOffset = 4;
    private boolean sneakButtonDown = false;
    private BlueprintRenderer blueprintRenderer;
    private int x;
    private int y;
    private boolean isScrolling = false;
    private float scrollPosition = 0.0f;
    private BlueprintScreenHandler handler;

    public BlueprintsScreen() {
        super((class_2561)class_2561.method_43470((String)"Blueprints"));
    }

    protected void method_25426() {
        if (this.field_22787 != null) {
            if (ModUtils.isClientInFortressGamemode()) {
                super.method_25426();
                this.x = (this.field_22789 - 195 - 120 - 4) / 2;
                this.y = (this.field_22790 - 136) / 2;
                this.handler = new BlueprintScreenHandler(this.field_22787);
                this.blueprintRenderer = ModUtils.getFortressClient().get_BlueprintRenderer();
                boolean connectedToTheServer = ModUtils.getFortressClientManager().isConnectedToTheServer();
                if (!connectedToTheServer) {
                    class_4185 impExpBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Import / Export"), btn -> this.field_22787.method_1507((class_437)new ImportExportBlueprintsScreen())).method_46434(this.x + 195 + 4, this.y - 22, 120, 20).method_46431();
                    this.method_37063((class_364)impExpBtn);
                }
            } else {
                this.field_22787.method_1507(null);
            }
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0) {
            for (BlueprintGroup group : BlueprintGroup.values()) {
                if (!this.isClickInTab(group, mouseX, mouseY)) continue;
                return true;
            }
            if (this.isClickInScrollbar(mouseX, mouseY)) {
                this.isScrolling = this.handler.isNeedScrollbar();
                return true;
            }
        }
        if (super.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if ((button == 0 || button == 1) && this.handler.hasFocusedSlot()) {
            if (this.handler.getFocusedSlot() == BlueprintSlot.EMPTY) {
                if (this.field_22787 != null) {
                    this.field_22787.method_1507((class_437)new AddBlueprintScreen(this.handler.getSelectedGroup()));
                }
                return true;
            }
            if (button == 1) {
                return true;
            }
            if (this.field_22787 != null) {
                this.field_22787.method_1507(null);
            }
            this.handler.clickOnFocusedSlot();
        }
        return false;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.isScrolling) {
            int minScroll = this.y + 18;
            int maxScroll = minScroll + 112;
            this.scrollPosition = ((float)mouseY - (float)minScroll - 7.5f) / ((float)(maxScroll - minScroll) - 15.0f);
            this.scrollPosition = class_3532.method_15363((float)this.scrollPosition, (float)0.0f, (float)1.0f);
            this.handler.scroll(this.scrollPosition);
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.isScrolling = false;
            for (BlueprintGroup blueprintGroup : BlueprintGroup.values()) {
                if (!this.isClickInTab(blueprintGroup, mouseX, mouseY)) continue;
                this.handler.selectGroup(blueprintGroup);
                this.scrollPosition = 0.0f;
                return true;
            }
        }
        if (button == 1 && this.handler.hasFocusedSlot()) {
            if (this.sneakButtonDown) {
                this.handler.sendRemovePacket();
            } else {
                this.handler.sendEditPacket();
                if (this.field_22787 != null) {
                    this.field_22787.method_1507(null);
                }
            }
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        if (!this.handler.isNeedScrollbar()) {
            return false;
        }
        int i = (this.handler.getSelectedGroupSize() + 9 - 1) / 9 - 5;
        this.scrollPosition = (float)((double)this.scrollPosition - amount / (double)i);
        this.scrollPosition = class_3532.method_15363((float)this.scrollPosition, (float)0.0f, (float)1.0f);
        this.handler.scroll(this.scrollPosition);
        return true;
    }

    public void updateSlots() {
        this.handler.scroll(this.scrollPosition);
    }

    public void method_25394(class_332 drawContext, int mouseX, int mouseY, float delta) {
        this.method_25420(drawContext);
        this.drawBackground(drawContext, mouseX, mouseY);
        RenderSystem.disableDepthTest();
        super.method_25394(drawContext, mouseX, mouseY, delta);
        int screenX = this.x;
        int screenY = this.y;
        class_4587 matrixStack = RenderSystem.getModelViewStack();
        matrixStack.method_22903();
        matrixStack.method_22904((double)screenX, (double)screenY, 0.0);
        RenderSystem.applyModelViewMatrix();
        this.handler.focusOnSlot(null);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShader(class_757::method_34542);
        List<BlueprintSlot> currentSlots = this.handler.getCurrentSlots();
        int currentSlotsSize = currentSlots.size();
        for (int i = 0; i < 45; ++i) {
            int slotColumn = i % 9;
            int slotRow = i / 9;
            int slotX = slotColumn * 18 + 9;
            int slotY = slotRow * 18 + 18;
            BlueprintSlot blueprintSlot = i < currentSlotsSize ? currentSlots.get(i) : BlueprintSlot.EMPTY;
            this.drawSlot(drawContext, blueprintSlot, slotColumn, slotRow);
            if (!this.isPointOverSlot(slotX, slotY, mouseX, mouseY)) continue;
            IClientFortressManager fortressClientManager = ModUtils.getFortressClientManager();
            IClientResourceManager resourceManager = fortressClientManager.getResourceManager();
            this.handler.focusOnSlot(blueprintSlot);
            class_465.method_33285((class_332)drawContext, (int)slotX, (int)slotY, (int)10);
            int x = this.x - this.backgroundWidth / 2;
            if (blueprintSlot == BlueprintSlot.EMPTY) continue;
            if (fortressClientManager.isSurvival()) {
                List<IItemInfo> stacks = blueprintSlot.getBlockData().getStacks();
                for (int i1 = 0; i1 < stacks.size(); ++i1) {
                    IItemInfo stack = stacks.get(i1);
                    boolean hasItem = resourceManager.hasItem(stack, stacks);
                    int itemX = x + 25 + i1 % 10 * 30;
                    int itemY = i1 / 10 * 20 + this.backgroundHeight;
                    class_1792 convertedItem = BlueprintsScreen.convertItemIconInTheGUI(stack);
                    drawContext.method_51427(new class_1799((class_1935)convertedItem), itemX, itemY);
                    drawContext.method_51433(this.field_22793, String.valueOf(stack.amount()), itemX + 17, itemY + 7, hasItem ? 0xFFFFFF : 0xFF0000, false);
                }
            }
            this.blueprintRenderer.renderBlueprintPreview(drawContext.method_51448(), blueprintSlot.getMetadata().getId(), class_2470.field_11467);
        }
        this.drawForeground(drawContext);
        if (this.handler.hasFocusedSlot()) {
            if (this.sneakButtonDown && this.handler.getFocusedSlot() != BlueprintSlot.EMPTY) {
                Objects.requireNonNull(this.field_22793);
                drawContext.method_51439(this.field_22793, DELETE_BLUEPRINT_TEXT, this.backgroundWidth + this.previewOffset + 3, this.backgroundHeight - 9 - 3, 0xFF0000, false);
            } else {
                class_2561 editText = this.handler.getFocusedSlot() != BlueprintSlot.EMPTY ? EDIT_BLUEPRINT_TEXT : ADD_BLUEPRINT_TEXT;
                Objects.requireNonNull(this.field_22793);
                drawContext.method_51439(this.field_22793, editText, this.backgroundWidth + this.previewOffset + 3, this.backgroundHeight - 9 - 3, 0xFFFFFF, false);
            }
        }
        matrixStack.method_22909();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawMouseoverTooltip(drawContext, mouseX, mouseY);
    }

    public static class_1792 convertItemIconInTheGUI(IItemInfo stack) {
        class_1792 originalItem = stack.item();
        if (class_1802.field_8365.equals(originalItem)) {
            return class_1802.field_8831;
        }
        return originalItem;
    }

    public boolean method_25421() {
        return false;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.isSneak(keyCode, scanCode)) {
            this.sneakButtonDown = true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        if (this.isSneak(keyCode, scanCode)) {
            this.sneakButtonDown = false;
        }
        return super.method_16803(keyCode, scanCode, modifiers);
    }

    private boolean isSneak(int keyCode, int scanCode) {
        return class_310.method_1551().field_1690.field_1832.method_1417(keyCode, scanCode);
    }

    private boolean isClickInTab(BlueprintGroup group, double mouseX, double mouseY) {
        mouseX -= (double)this.x;
        mouseY -= (double)this.y;
        int columnNumber = group.ordinal();
        int x = 28 * columnNumber;
        int y = 0;
        if (columnNumber > 0) {
            x += columnNumber;
        }
        y = group.isTopRow() ? (y -= 32) : (y += this.backgroundHeight);
        return mouseX >= (double)x && mouseX <= (double)(x + 28) && mouseY >= (double)y && mouseY <= (double)(y + 32);
    }

    private boolean isClickInScrollbar(double mouseX, double mouseY) {
        int i = this.x;
        int j = this.y;
        int k = i + 175;
        int l = j + 18;
        int m = k + 14;
        int n = l + 112;
        return mouseX >= (double)k && mouseY >= (double)l && mouseX < (double)m && mouseY < (double)n;
    }

    private boolean isPointOverSlot(int slotX, int slotY, int mouseX, int mouseY) {
        int screenX = this.x;
        int screenY = this.y;
        return mouseX >= screenX + slotX && mouseX < screenX + slotX + 18 && mouseY >= screenY + slotY && mouseY < screenY + slotY + 18;
    }

    private void drawForeground(class_332 drawContext) {
        BlueprintGroup selectedGroup = this.handler.getSelectedGroup();
        if (selectedGroup != null) {
            RenderSystem.disableBlend();
            drawContext.method_51439(this.field_22793, selectedGroup.getNameText(), 8, 6, 0x404040, false);
        }
    }

    private void drawSlot(class_332 drawContext, BlueprintSlot slot, int slotColumn, int slotRow) {
        RenderSystem.enableDepthTest();
        int slotX = slotColumn * 18 + 9 + 5;
        int slotY = slotRow * 18 + 18 + 5;
        if (slot == BlueprintSlot.EMPTY) {
            float scaleFactor = 0.5f;
            class_4587 matrices = drawContext.method_51448();
            matrices.method_22903();
            matrices.method_22905(0.5f, 0.5f, 0.5f);
            drawContext.method_51427(new class_1799((class_1935)class_1802.field_8621), (int)((float)slotX / 0.5f), (int)((float)slotY / 0.5f));
            matrices.method_22909();
        } else {
            boolean enoughResources;
            IBlueprintMetadata metadata = slot.getMetadata();
            boolean bl = enoughResources = !ModUtils.getFortressClientManager().isSurvival() || slot.isEnoughResources();
            if (this.field_22787 != null) {
                this.blueprintRenderer.renderBlueprintInGui(drawContext.method_51448(), metadata.getId(), class_2470.field_11467, slotColumn, slotRow, enoughResources);
            }
        }
    }

    private void drawBackground(class_332 drawContext, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        BlueprintGroup selectedGroup = this.handler.getSelectedGroup();
        for (BlueprintGroup bg : BlueprintGroup.values()) {
            if (selectedGroup == bg) continue;
            this.renderTabIcon(drawContext, bg);
            this.renderTabTooltipIfHovered(drawContext, bg, mouseX, mouseY);
        }
        drawContext.method_25302(new class_2960(BACKGROUND_TEXTURE), this.x, this.y, 0, 0, this.backgroundWidth, this.backgroundHeight);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int i = this.x + 175;
        int j = this.y + 18;
        int k = j + 112;
        drawContext.method_25302(INVENTORY_TABS_TEXTURE, i, j + (int)((float)(k - j - 17) * this.scrollPosition), 232 + (this.handler.isNeedScrollbar() ? 0 : 12), 0, 12, 15);
        if (selectedGroup != null) {
            this.renderTabIcon(drawContext, selectedGroup);
        }
        drawContext.method_25290(BLUEPRINT_PREVIEW_BACKGROUND_TEXTURE, this.x + this.backgroundWidth + this.previewOffset, this.y, 250.0f, 230.0f, this.previewWidth, this.backgroundHeight, 1000, 1000);
    }

    private void renderTabIcon(class_332 drawContext, BlueprintGroup group) {
        boolean topRow;
        boolean isSelectedGroup = group == this.handler.getSelectedGroup();
        int columnNumber = group.ordinal() % 7;
        int buttonWidth = 26;
        int texX = columnNumber * buttonWidth;
        int texY = 0;
        int x = this.x + buttonWidth * columnNumber;
        int y = this.y;
        if (columnNumber > 0) {
            x += columnNumber;
        }
        if (topRow = group.isTopRow()) {
            y -= 28;
        } else {
            texY += 64;
            y += this.backgroundHeight - 4;
        }
        if (isSelectedGroup) {
            texY += 32;
        }
        drawContext.method_25302(INVENTORY_TABS_TEXTURE, x, y, texX, texY, buttonWidth, 32);
        int yIconDelta = topRow ? 1 : -1;
        class_1799 icon = group.getIcon();
        drawContext.method_51427(icon, x + 5, y + 8 + yIconDelta);
    }

    private void renderTabTooltipIfHovered(class_332 drawContext, BlueprintGroup group, int mouseX, int mouseY) {
        int columnNumber = group.ordinal();
        int x = 26 * columnNumber + this.x;
        int y = this.y;
        if (columnNumber > 0) {
            x += columnNumber;
        }
        y = group.isTopRow() ? (y -= 32) : (y += this.backgroundHeight);
        if (this.isPointWithinBounds(x + 3, y + 3, mouseX, mouseY)) {
            drawContext.method_51438(this.field_22793, group.getNameText(), mouseX, mouseY);
        }
    }

    private boolean isPointWithinBounds(int x, int y, int mouseX, int mouseY) {
        return mouseX >= x && mouseY >= y && mouseX < x + 23 && mouseY < y + 27;
    }

    private void drawMouseoverTooltip(class_332 drawContext, int x, int y) {
        if (this.handler.hasFocusedSlot() && this.handler.getFocusedSlot() != BlueprintSlot.EMPTY) {
            drawContext.method_51438(this.field_22793, this.handler.getFocusedSlotName(), x, y);
        }
    }
}

