/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.renderer;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.remmintan.mods.minefortress.core.dtos.buildings.BuildingHealthRenderInfo;
import net.remmintan.mods.minefortress.core.interfaces.selections.ISelectionManager;
import org.apache.commons.lang3.StringUtils;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public class MineFortressLabelsRenderer {
    public static final int GREEN = -16743344;
    public static final int YELLOW = -1067264;
    public static final int RED = -4711149;
    public static final int BLACK = -16777216;
    private final class_327 font;
    private final Supplier<ISelectionManager> selectionManagerSupplier;
    private final Supplier<List<BuildingHealthRenderInfo>> buildingsHealthSupplier;
    private class_4184 camera;
    private Quaternionf cameraOrientation;

    public MineFortressLabelsRenderer(class_327 font, Supplier<ISelectionManager> selectionManagerSupplier, Supplier<List<BuildingHealthRenderInfo>> buildingsHealthSupplier) {
        this.font = font;
        this.selectionManagerSupplier = selectionManagerSupplier;
        this.buildingsHealthSupplier = buildingsHealthSupplier;
    }

    public void prepare(class_4184 camera) {
        this.camera = camera;
        this.cameraOrientation = camera.method_23767();
    }

    public void render(double x, double y, double z, class_4587 matrixStack, class_4597 source, int packLightCoords) {
        this.renderSelectionLabels(x, y, z, matrixStack, source, packLightCoords);
        this.renderBuildingHealth(x, y, z, matrixStack, source, packLightCoords);
    }

    private void renderBuildingHealth(double x, double y, double z, class_4587 matrixStack, class_4597 source, int packLightCoords) {
        int totalHealthLength = 30;
        String healthbarBackground = StringUtils.repeat((String)"|", (int)30);
        int healthbarWidth = this.font.method_1727(healthbarBackground);
        float healthbarVerticalOffset = -4.0f;
        for (BuildingHealthRenderInfo renderInfo : this.buildingsHealthSupplier.get()) {
            class_243 pos = renderInfo.pos();
            Integer health = renderInfo.health();
            int healthLength = (int)((float)health.intValue() / 100.0f * 30.0f);
            String healthbar = StringUtils.repeat((String)"|", (int)healthLength);
            int color = health > 66 ? -16743344 : (health > 33 ? -1067264 : -4711149);
            Consumer<Matrix4f> renderAction = matrix -> {
                this.font.method_27521(healthbarBackground, (float)(-healthbarWidth) / 2.0f, -4.0f, -16777216, false, matrix, source, class_327.class_6415.field_33993, -16777216, packLightCoords);
                matrixStack.method_22903();
                matrixStack.method_46416(0.0f, 0.0f, -0.05f);
                Matrix4f newMatrix = matrixStack.method_23760().method_23761();
                this.font.method_27521(healthbar, (float)(-healthbarWidth) / 2.0f, -4.0f, color, false, newMatrix, source, class_327.class_6415.field_33993, color, packLightCoords);
                matrixStack.method_22909();
            };
            this.renderTranslated(x, y, z, matrixStack, pos, renderAction, 0.5f);
        }
    }

    private void renderSelectionLabels(double x, double y, double z, class_4587 matrixStack, class_4597 source, int packLightCoords) {
        for (Pair<class_243, String> pair : this.getSelectionManager().getLabels()) {
            class_243 pos = (class_243)pair.getFirst();
            String stringToDisplay = (String)pair.getSecond();
            int backgroundAlpha = MineFortressLabelsRenderer.getBackgroundAlpha();
            Consumer<Matrix4f> renderAction = matrix -> this.font.method_27521(stringToDisplay, 0.0f, 0.0f, -1, false, matrix, source, class_327.class_6415.field_33993, backgroundAlpha, packLightCoords);
            this.renderTranslated(x, y, z, matrixStack, pos, renderAction, 1.0f);
        }
    }

    private static int getBackgroundAlpha() {
        float backgroundOpacity = class_310.method_1551().field_1690.method_19343(0.25f);
        return (int)(backgroundOpacity * 255.0f) << 24;
    }

    private void renderTranslated(double x, double y, double z, class_4587 matrixStack, class_243 pos, Consumer<Matrix4f> renderAction, float size) {
        matrixStack.method_22903();
        matrixStack.method_22904(pos.field_1352 - x, pos.field_1351 + 2.0 - y, pos.field_1350 - z);
        matrixStack.method_22907(this.cameraOrientation);
        double a = this.camera.method_19326().method_1022(pos);
        float verticalDistanceMultiplier = (float)a / 10.0f;
        matrixStack.method_22905(-0.075f * verticalDistanceMultiplier * size, -0.075f * verticalDistanceMultiplier * size, 0.075f * verticalDistanceMultiplier * size);
        Matrix4f matrix = matrixStack.method_23760().method_23761();
        renderAction.accept(matrix);
        matrixStack.method_22909();
    }

    public ISelectionManager getSelectionManager() {
        return this.selectionManagerSupplier.get();
    }
}

