/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_746;
import net.minecraft.class_757;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.lwjgl.system.MemoryUtil;
import org.minefortress.interfaces.FortressGameRenderer;
import org.minefortress.renderer.GLU;

public class CameraTools {
    private static class_243 mouseBasedViewVector;
    private static double oldMouseX;
    private static double oldMouseY;
    private static float oldPlayerXRot;
    private static float oldPlayerYRot;

    public static class_243 getMouseBasedViewVector(class_310 minecraft, float xRot, float yRot) {
        double xpos = minecraft.field_1729.method_1603();
        double ypos = minecraft.field_1729.method_1604();
        if (Math.abs(xpos - oldMouseX) + Math.abs(ypos - oldMouseY) > 0.01 || xRot != oldPlayerXRot || yRot != oldPlayerYRot) {
            mouseBasedViewVector = CameraTools.getMouseBasedViewVector(minecraft, xpos, ypos);
            oldMouseX = xpos;
            oldMouseY = ypos;
            oldPlayerXRot = xRot;
            oldPlayerYRot = yRot;
        }
        return mouseBasedViewVector;
    }

    public static class_243 getMouseBasedViewVector(class_310 minecraft, double xpos, double ypos) {
        int winWidth = minecraft.method_22683().method_4480();
        int winHeight = minecraft.method_22683().method_4507();
        FloatBuffer resultingViewBuffer = MemoryUtil.memAllocFloat((int)3);
        resultingViewBuffer.position(0);
        FloatBuffer modelViewBuffer = CameraTools.getModelViewMatrix(minecraft);
        FloatBuffer projectionBuffer = CameraTools.getProjectionMatrix(minecraft);
        IntBuffer viewport = CameraTools.getViewport(winWidth, winHeight);
        GLU.gluUnProject((float)xpos, (float)((double)winHeight - ypos), 1.0f, modelViewBuffer, projectionBuffer, viewport, resultingViewBuffer);
        return CameraTools.calculateResultingVector(resultingViewBuffer);
    }

    private static IntBuffer getViewport(int winWidth, int winHeight) {
        IntBuffer viewport = MemoryUtil.memAllocInt((int)4);
        viewport.position(0);
        viewport.put(0);
        viewport.put(0);
        viewport.put(winWidth);
        viewport.put(winHeight);
        viewport.rewind();
        return viewport;
    }

    private static class_243 calculateResultingVector(FloatBuffer resultingViewBuffer) {
        Vector3f resultingViewVector = new Vector3f(resultingViewBuffer.get(0), resultingViewBuffer.get(1), resultingViewBuffer.get(2));
        resultingViewVector.normalize();
        return new class_243(resultingViewVector);
    }

    private static FloatBuffer getModelViewMatrix(class_310 minecraft) {
        Matrix4f modelViewMatrix = new Matrix4f((Matrix4fc)RenderSystem.getModelViewMatrix());
        class_746 player = minecraft.field_1724;
        if (player != null) {
            float xRads = (float)Math.toRadians(player.method_5802().field_1343);
            modelViewMatrix.rotate(xRads, (Vector3fc)new Vector3f(1.0f, 0.0f, 0.0f));
            float yRads = (float)Math.toRadians(player.method_5802().field_1342 + 180.0f);
            modelViewMatrix.rotate(yRads, (Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f));
        }
        FloatBuffer modelViewBuffer = MemoryUtil.memAllocFloat((int)16);
        modelViewBuffer.position(0);
        modelViewMatrix.get(modelViewBuffer);
        modelViewBuffer.rewind();
        return modelViewBuffer;
    }

    private static FloatBuffer getProjectionMatrix(class_310 minecraft) {
        Matrix4f projectionMatrix = CameraTools.getProjectionMatrix4f(minecraft);
        FloatBuffer projectionBuffer = MemoryUtil.memAllocFloat((int)16);
        projectionBuffer.position(0);
        projectionMatrix.get(projectionBuffer);
        projectionBuffer.rewind();
        return projectionBuffer;
    }

    @NotNull
    public static Matrix4f getProjectionMatrix4f(class_310 minecraft) {
        class_757 gameRenderer = minecraft.field_1773;
        double fov = ((FortressGameRenderer)gameRenderer).get_Fov(1.0f, true);
        return CameraTools.getProjectionMatrix4f(minecraft, fov);
    }

    @NotNull
    private static Matrix4f getProjectionMatrix4f(class_310 minecraft, double fov) {
        class_757 gameRenderer = minecraft.field_1773;
        return new Matrix4f((Matrix4fc)gameRenderer.method_22973(fov));
    }
}

