/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.registries;

import net.fabricmc.fabric.api.entity.event.v1.EntitySleepEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1269;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.minecraft.class_5219;
import net.remmintan.mods.minefortress.core.interfaces.entities.player.FortressServerPlayerEntity;
import net.remmintan.mods.minefortress.core.interfaces.professions.IServerProfessionsManager;
import net.remmintan.mods.minefortress.core.interfaces.server.IFortressModServerManager;
import net.remmintan.mods.minefortress.core.interfaces.server.IFortressServer;
import net.remmintan.mods.minefortress.core.interfaces.server.IServerFortressManager;
import net.remmintan.mods.minefortress.core.interfaces.server.IServerManagersProvider;
import net.remmintan.mods.minefortress.networking.helpers.FortressServerNetworkHelper;
import net.remmintan.mods.minefortress.networking.s2c.ClientboundFollowColonistPacket;
import org.minefortress.blueprints.world.BlueprintsWorld;
import org.minefortress.entity.BasePawnEntity;
import org.minefortress.interfaces.FortressWorldCreator;
import org.minefortress.utils.ModUtils;

public class FortressServerEvents {
    public static void register() {
        EntitySleepEvents.ALLOW_BED.register((entity, sleepingPos, state, vanillaResult) -> {
            if (ModUtils.isFortressGamemode(entity)) {
                return class_1269.field_5812;
            }
            return class_1269.field_5811;
        });
        EntitySleepEvents.MODIFY_SLEEPING_DIRECTION.register((entity, pos, dir) -> {
            if (ModUtils.isFortressGamemode(entity)) {
                class_243 rotationVector = entity.method_5720();
                return class_2350.method_10142((double)rotationVector.field_1352, (double)rotationVector.field_1351, (double)rotationVector.field_1350);
            }
            return dir;
        });
        EntitySleepEvents.ALLOW_NEARBY_MONSTERS.register((player, pos, vanilla) -> {
            if (ModUtils.isFortressGamemode(player)) {
                return class_1269.field_5812;
            }
            return class_1269.field_5811;
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            FortressServerPlayerEntity fortressPlayer;
            IFortressServer fortressServer = (IFortressServer)server;
            class_3222 player = handler.field_14140;
            IFortressModServerManager fortressModServerManager = fortressServer.get_FortressModServerManager();
            IServerFortressManager manager = fortressModServerManager.getFortressManager(player);
            IServerManagersProvider provider = fortressModServerManager.getManagersProvider(player);
            manager.syncOnJoin(fortressModServerManager.isCampfireEnabled(), fortressModServerManager.isBorderEnabled());
            IServerProfessionsManager serverProfessionManager = provider.getProfessionsManager();
            serverProfessionManager.sendProfessions(player);
            serverProfessionManager.scheduleSync();
            if (player instanceof FortressServerPlayerEntity && (fortressPlayer = (FortressServerPlayerEntity)player).was_InBlueprintWorldWhenLoggedOut() && fortressPlayer.get_PersistedPos() != null) {
                class_243 pos = fortressPlayer.get_PersistedPos();
                player.method_20620(pos.field_1352, pos.field_1351, pos.field_1350);
            }
        });
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> {
            boolean inBlueprintWorldOnDisconnect = handler.field_14140.method_37908().method_27983() == BlueprintsWorld.BLUEPRINTS_WORLD_REGISTRY_KEY;
            class_3222 patt3551$temp = handler.field_14140;
            if (patt3551$temp instanceof FortressServerPlayerEntity) {
                FortressServerPlayerEntity fortressPlayer = (FortressServerPlayerEntity)patt3551$temp;
                fortressPlayer.set_WasInBlueprintWorldWhenLoggedOut(inBlueprintWorldOnDisconnect);
            }
        });
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            if (server instanceof IFortressServer) {
                IFortressServer IFortressServer2 = (IFortressServer)server;
                class_5219 saveProps = server.method_27728();
                if (saveProps instanceof FortressWorldCreator) {
                    FortressWorldCreator wcProps = (FortressWorldCreator)saveProps;
                    IFortressServer2.get_FortressModServerManager().load(wcProps.is_ShowCampfire(), wcProps.is_BorderEnabled());
                } else {
                    IFortressServer2.get_FortressModServerManager().load();
                }
            }
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> {
            if (server instanceof IFortressServer) {
                IFortressServer aserver = (IFortressServer)server;
                aserver.get_FortressModServerManager().save();
                aserver.get_BlueprintsWorld().closeSession();
            }
        });
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            if (server instanceof IFortressServer) {
                IFortressServer IFortressServer2 = (IFortressServer)server;
                IFortressServer2.get_FortressModServerManager().tick(server.method_3760());
            }
        });
        AttackEntityCallback.EVENT.register((player, world, hand, entity, hitResult) -> {
            if (ModUtils.isFortressGamemode(player)) {
                if (player instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)player;
                    if (entity instanceof BasePawnEntity) {
                        BasePawnEntity pawn = (BasePawnEntity)entity;
                        int id = pawn.method_5628();
                        ClientboundFollowColonistPacket packet = new ClientboundFollowColonistPacket(id);
                        FortressServerNetworkHelper.send(serverPlayer, "fortress_select_colonist", packet);
                    }
                }
                return class_1269.field_5812;
            }
            return class_1269.field_5811;
        });
    }
}

