/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.professions.hire;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.stream.Collectors;
import net.remmintan.mods.minefortress.core.interfaces.professions.CountProfessionals;
import net.remmintan.mods.minefortress.core.interfaces.professions.IHireCost;
import net.remmintan.mods.minefortress.core.interfaces.professions.IHireInfo;
import net.remmintan.mods.minefortress.core.interfaces.professions.IProfession;
import net.remmintan.mods.minefortress.core.interfaces.professions.ProfessionResearchState;
import org.jetbrains.annotations.NotNull;
import org.minefortress.professions.ServerProfessionManager;
import org.minefortress.professions.hire.HireCost;
import org.minefortress.professions.hire.HireInfo;

public class ServerHireHandler {
    private final List<String> professions;
    private final ServerProfessionManager professionManager;
    private final Map<String, Queue<HireRequest>> hireRequests = new HashMap<String, Queue<HireRequest>>();

    public ServerHireHandler(List<String> professions, ServerProfessionManager professionManager) {
        this.professions = Collections.unmodifiableList(professions);
        this.professionManager = professionManager;
    }

    public Map<String, IHireInfo> getProfessions() {
        return this.getUnlockedProfessions().stream().map(it -> {
            Queue<HireRequest> hireRequestsQueue = this.getHireRequestsQueue((String)it);
            return new HireInfo((String)it, Optional.ofNullable(hireRequestsQueue.peek()).map(HireRequest::getProgress).orElse(0), hireRequestsQueue.size(), this.getCost((String)it));
        }).collect(Collectors.toMap(IHireInfo::professionId, it -> it));
    }

    public void hire(String professionId) {
        HireRequest hireRequest = new HireRequest(professionId);
        this.getHireRequestsQueue(professionId).add(hireRequest);
    }

    @NotNull
    private Queue<HireRequest> getHireRequestsQueue(String professionId) {
        return this.hireRequests.computeIfAbsent(professionId, k -> new ArrayDeque());
    }

    private List<IHireCost> getCost(String it) {
        return this.professionManager.getProfession(it).getItemsRequirement().stream().map(HireCost::fromItemInfo).toList();
    }

    public void tick() {
        this.hireRequests.entrySet().stream().filter(it -> this.professionUnlocked((String)it.getKey())).map(it -> (HireRequest)((Queue)it.getValue()).peek()).filter(Objects::nonNull).forEach(HireRequest::tick);
        for (Map.Entry<String, Queue<HireRequest>> entry : this.hireRequests.entrySet()) {
            entry.getValue().removeIf(it -> {
                if (it.isDone()) {
                    this.professionManager.increaseAmount(it.getProfessionId(), true);
                    return true;
                }
                return false;
            });
        }
    }

    private List<String> getUnlockedProfessions() {
        return this.professions.stream().filter(this::professionUnlocked).toList();
    }

    private boolean professionUnlocked(String it) {
        IProfession profession = this.professionManager.getProfession(it);
        return this.professionManager.isRequirementsFulfilled(profession, CountProfessionals.DONT_COUNT, false) == ProfessionResearchState.UNLOCKED;
    }

    private static class HireRequest {
        private final String professionId;
        private int progress;

        public HireRequest(String professionId) {
            this.professionId = professionId;
        }

        String getProfessionId() {
            return this.professionId;
        }

        void tick() {
            ++this.progress;
        }

        boolean isDone() {
            return this.progress >= 100;
        }

        int getProgress() {
            return this.progress;
        }
    }
}

