/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.professions.hire;

import java.util.List;
import java.util.Map;
import java.util.Set;
import net.remmintan.mods.minefortress.core.interfaces.professions.IHireCost;
import net.remmintan.mods.minefortress.core.interfaces.professions.IHireInfo;
import net.remmintan.mods.minefortress.core.interfaces.professions.IProfession;
import net.remmintan.mods.minefortress.core.interfaces.resources.IItemInfo;
import net.remmintan.mods.minefortress.networking.c2s.C2SHirePawnWithScreenPacket;
import net.remmintan.mods.minefortress.networking.helpers.FortressClientNetworkHelper;
import org.minefortress.professions.hire.IHireScreenHandler;
import org.minefortress.utils.ModUtils;

public final class ClientHireHandler
implements IHireScreenHandler {
    private final String screenName;
    private Map<String, IHireInfo> professions;

    public ClientHireHandler(String screenName, Map<String, IHireInfo> professions) {
        this.screenName = screenName;
        this.professions = professions;
    }

    @Override
    public String getScreenName() {
        return this.screenName;
    }

    @Override
    public Set<String> getProfessions() {
        return this.professions.keySet();
    }

    @Override
    public int getHireProgress(String professionId) {
        return this.professions.get(professionId).hireProgress();
    }

    @Override
    public int getHireQueue(String professionId) {
        return this.professions.get(professionId).hireQueue();
    }

    @Override
    public List<IItemInfo> getCost(String professionId) {
        return this.professions.get(professionId).cost().stream().map(IHireCost::toItemInfo).toList();
    }

    @Override
    public int getCurrentCount(String professionId) {
        return ModUtils.getFortressClientManager().getProfessionManager().getProfession(professionId).getAmount();
    }

    @Override
    public int getMaxCount(String professionId) {
        IProfession profession = ModUtils.getFortressClientManager().getProfessionManager().getProfession(professionId);
        String buildingRequirement = profession.getBuildingRequirement();
        return ModUtils.getFortressClientManager().countBuildings(buildingRequirement) * 10;
    }

    @Override
    public void increaseAmount(String professionId) {
        C2SHirePawnWithScreenPacket packet = new C2SHirePawnWithScreenPacket(professionId);
        FortressClientNetworkHelper.send("hire_pawn_with_screen", packet);
    }

    @Override
    public void sync(Map<String, IHireInfo> professions) {
        if (professions == null) {
            throw new IllegalArgumentException("Professions cannot be null");
        }
        this.professions = professions;
    }
}

