/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.professions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import net.minecraft.class_6328;
import net.minecraft.server.MinecraftServer;
import net.remmintan.mods.minefortress.core.dtos.professions.IProfessionEssentialInfo;
import net.remmintan.mods.minefortress.core.dtos.professions.ProfessionFullInfo;
import net.remmintan.mods.minefortress.core.interfaces.IFortressManager;
import net.remmintan.mods.minefortress.core.interfaces.entities.pawns.IProfessional;
import net.remmintan.mods.minefortress.core.interfaces.professions.CountProfessionals;
import net.remmintan.mods.minefortress.core.interfaces.professions.IHireInfo;
import net.remmintan.mods.minefortress.core.interfaces.professions.IProfession;
import net.remmintan.mods.minefortress.core.interfaces.professions.IServerProfessionsManager;
import net.remmintan.mods.minefortress.core.interfaces.professions.ProfessionResearchState;
import net.remmintan.mods.minefortress.core.interfaces.professions.ProfessionsHireTypes;
import net.remmintan.mods.minefortress.core.interfaces.resources.IServerResourceManager;
import net.remmintan.mods.minefortress.core.interfaces.server.IServerFortressManager;
import net.remmintan.mods.minefortress.networking.helpers.FortressServerNetworkHelper;
import net.remmintan.mods.minefortress.networking.s2c.ClientboundProfessionSyncPacket;
import net.remmintan.mods.minefortress.networking.s2c.ClientboundProfessionsInitPacket;
import net.remmintan.mods.minefortress.networking.s2c.S2COpenHireMenuPacket;
import net.remmintan.mods.minefortress.networking.s2c.SyncHireProgress;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.minefortress.entity.Colonist;
import org.minefortress.fortress.ServerFortressManager;
import org.minefortress.professions.Profession;
import org.minefortress.professions.ProfessionEntityTypesMapper;
import org.minefortress.professions.ProfessionEssentialInfo;
import org.minefortress.professions.ProfessionManager;
import org.minefortress.professions.ProfessionsReader;
import org.minefortress.professions.hire.ServerHireHandler;
import org.slf4j.LoggerFactory;

@class_6328
public final class ServerProfessionManager
extends ProfessionManager
implements IServerProfessionsManager {
    public static final String PROFESSION_NBT_TAG = "professionId";
    private final ProfessionEntityTypesMapper profToEntityMapper = new ProfessionEntityTypesMapper();
    private final MinecraftServer server;
    private List<ProfessionFullInfo> professionsInfos;
    private String professionsTree;
    private boolean needsUpdate = false;
    private final Map<ProfessionsHireTypes, ServerHireHandler> hireHandlers = new HashMap<ProfessionsHireTypes, ServerHireHandler>();
    private ServerHireHandler currentHireHandler;

    public ServerProfessionManager(Supplier<IFortressManager> fortressManagerSupplier, MinecraftServer server) {
        super(fortressManagerSupplier);
        this.server = server;
    }

    @Override
    public void openHireMenu(ProfessionsHireTypes hireType, class_3222 player) {
        this.currentHireHandler = this.hireHandlers.computeIfAbsent(hireType, k -> new ServerHireHandler(k.getIds(), this));
        Map<String, IHireInfo> professions = this.currentHireHandler.getProfessions();
        String screenName = hireType.getScreenName();
        S2COpenHireMenuPacket packet = new S2COpenHireMenuPacket(screenName, professions);
        FortressServerNetworkHelper.send(player, "open_hire_menu", packet);
    }

    @Override
    public void closeHireMenu() {
        this.currentHireHandler = null;
    }

    @Override
    public void sendHireRequestToCurrentHandler(String professionId) {
        if (this.currentHireHandler != null) {
            IProfession profession = this.getProfession(professionId);
            if (!profession.isHireMenu()) {
                throw new IllegalArgumentException("Profession " + professionId + " is not a hire menu profession");
            }
            ProfessionResearchState canHire = this.isRequirementsFulfilled(profession, CountProfessionals.INCREASE, true);
            IServerFortressManager abstractFortressManager = (IServerFortressManager)this.fortressManagerSupplier.get();
            if (canHire == ProfessionResearchState.UNLOCKED && this.getFreeColonists() > 0 && abstractFortressManager instanceof ServerFortressManager) {
                ServerFortressManager fsm = (ServerFortressManager)abstractFortressManager;
                IServerResourceManager resourceManager = abstractFortressManager.getResourceManager();
                resourceManager.removeItems(profession.getItemsRequirement());
                fsm.getPawnWithoutAProfession().ifPresent(Colonist::reserveColonist);
                fsm.scheduleSync();
                this.currentHireHandler.hire(professionId);
            }
        } else {
            throw new IllegalStateException("No current hire handler");
        }
    }

    @Override
    public void increaseAmount(String professionId, boolean itemsAlreadyCharged) {
        IProfession profession = super.getProfession(professionId);
        if (profession == null) {
            return;
        }
        if (profession.isHireMenu()) {
            ServerFortressManager fsm;
            Object t = this.fortressManagerSupplier.get();
            if (t instanceof ServerFortressManager && (fsm = (ServerFortressManager)t).getReservedPawnsCount() <= 0) {
                LoggerFactory.getLogger(ServerProfessionManager.class).error("No reserved pawns but trying to hire a profession");
                return;
            }
        } else if (super.getFreeColonists() <= 0) {
            return;
        }
        if (super.isRequirementsFulfilled(profession, CountProfessionals.INCREASE, !itemsAlreadyCharged) != ProfessionResearchState.UNLOCKED) {
            return;
        }
        if (!itemsAlreadyCharged) {
            IServerResourceManager resourceManager = ((IServerFortressManager)this.fortressManagerSupplier.get()).getResourceManager();
            resourceManager.removeItems(profession.getItemsRequirement());
        }
        profession.setAmount(profession.getAmount() + 1);
        this.scheduleSync();
    }

    @Override
    public void decreaseAmount(String professionId) {
        this.decreaseAmount(professionId, false);
    }

    @Override
    public void decreaseAmount(String professionId, boolean force) {
        IProfession profession = super.getProfession(professionId);
        if (profession == null) {
            return;
        }
        if (profession.getAmount() <= 0) {
            return;
        }
        if (profession.isHireMenu() && !force) {
            return;
        }
        profession.setAmount(profession.getAmount() - 1);
        this.scheduleSync();
    }

    @Override
    public void tick(@Nullable class_3222 player) {
        if (player == null) {
            return;
        }
        this.hireHandlers.forEach((k, v) -> v.tick());
        if (this.currentHireHandler != null) {
            SyncHireProgress packet = new SyncHireProgress(this.currentHireHandler.getProfessions());
            FortressServerNetworkHelper.send(player, "sync_hire_progress", packet);
        }
        this.tickRemoveFromProfession();
        if (this.needsUpdate) {
            ArrayList<IProfessionEssentialInfo> essentialInfos = new ArrayList<IProfessionEssentialInfo>();
            for (Map.Entry<String, IProfession> entry : this.getProfessions().entrySet()) {
                ProfessionEssentialInfo professionEssentialInfo = new ProfessionEssentialInfo(entry.getKey(), entry.getValue().getAmount());
                essentialInfos.add(professionEssentialInfo);
            }
            ClientboundProfessionSyncPacket packet = new ClientboundProfessionSyncPacket(essentialInfos);
            FortressServerNetworkHelper.send(player, "fortress_profession_sync", packet);
            this.needsUpdate = false;
        }
    }

    @Override
    public void sendProfessions(@NotNull class_3222 player) {
        this.initProfessionsIfNeeded();
        ClientboundProfessionsInitPacket packet = new ClientboundProfessionsInitPacket(this.professionsInfos, this.professionsTree);
        FortressServerNetworkHelper.send(player, "fortress_profession_init", packet);
    }

    private void initProfessionsIfNeeded() {
        if (this.getProfessions().isEmpty()) {
            ProfessionsReader professionsReader = new ProfessionsReader(this.server);
            this.professionsInfos = professionsReader.readProfessions();
            this.professionsTree = professionsReader.readTreeJson();
            Map<String, IProfession> professionsMap = this.professionsInfos.stream().collect(Collectors.toMap(ProfessionFullInfo::key, it -> new Profession((ProfessionFullInfo)it)));
            this.setProfessions(professionsMap);
            this.profToEntityMapper.read(this.server);
        }
    }

    @Override
    public class_1299<? extends class_1309> getEntityTypeForProfession(String professionId) {
        return this.profToEntityMapper.getEntityTypeForProfession(professionId);
    }

    private void tickRemoveFromProfession() {
        for (Map.Entry<String, IProfession> entry : this.getProfessions().entrySet()) {
            String professionId = entry.getKey();
            IProfession profession = entry.getValue();
            List<IProfessional> pawnsWithProf = this.getPawnsWithProfession(professionId);
            int redundantProfCount = pawnsWithProf.size() - profession.getAmount();
            if (redundantProfCount <= 0) continue;
            pawnsWithProf.stream().limit(redundantProfCount).forEach(IProfessional::resetProfession);
        }
    }

    @Override
    public void scheduleSync() {
        this.needsUpdate = true;
    }

    @Override
    public void writeToNbt(class_2487 tag) {
        this.getProfessions().forEach((key, value) -> tag.method_10566(key, (class_2520)value.toNbt()));
    }

    @Override
    public void readFromNbt(class_2487 tag) {
        this.initProfessionsIfNeeded();
        for (String key : tag.method_10541()) {
            IProfession profession = super.getProfession(key);
            if (profession == null) continue;
            profession.readNbt(tag.method_10562(key));
            this.scheduleSync();
        }
    }

    @Override
    public Optional<String> getProfessionsWithAvailablePlaces(boolean professionRequiresReservation) {
        for (Map.Entry<String, IProfession> entry : this.getProfessions().entrySet()) {
            long colonistsWithProfession;
            String professionId = entry.getKey();
            IProfession profession = entry.getValue();
            if (professionRequiresReservation && !profession.isHireMenu() || !professionRequiresReservation && profession.isHireMenu() || profession.getAmount() <= 0 || (colonistsWithProfession = this.countPawnsWithProfession(professionId)) >= (long)profession.getAmount()) continue;
            return Optional.of(professionId);
        }
        return Optional.empty();
    }

    private long countPawnsWithProfession(String professionId) {
        ServerFortressManager fortressServerManager = (ServerFortressManager)this.fortressManagerSupplier.get();
        return fortressServerManager.getProfessionals().stream().filter(colonist -> colonist.getProfessionId().equals(professionId)).count();
    }

    private List<IProfessional> getPawnsWithProfession(String professionId) {
        ServerFortressManager serverFortressManager = (ServerFortressManager)this.fortressManagerSupplier.get();
        return serverFortressManager.getProfessionals().stream().filter(colonist -> colonist.getProfessionId().equals(professionId)).collect(Collectors.toList());
    }
}

