/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.professions;

import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import net.remmintan.mods.minefortress.core.dtos.professions.ProfessionFullInfo;

public final class ProfessionsReader {
    private final class_2960 professionsResourceId = new class_2960("minefortress", "professions/list.json");
    private final class_2960 professionTreeId = new class_2960("minefortress", "professions/tree.json");
    private final MinecraftServer server;

    ProfessionsReader(MinecraftServer server) {
        this.server = server;
    }

    List<ProfessionFullInfo> readProfessions() {
        class_3300 resourceManager = this.server.method_34864();
        ArrayList<ProfessionFullInfo> professions = new ArrayList<ProfessionFullInfo>();
        class_3298 resource = (class_3298)resourceManager.method_14486(this.professionsResourceId).orElseThrow();
        try (InputStream is = resource.method_14482();
             InputStreamReader isr = new InputStreamReader(is);
             JsonReader jsonReader = new JsonReader((Reader)isr);){
            jsonReader.beginArray();
            while (jsonReader.hasNext()) {
                ProfessionFullInfo profession = this.readProfession(jsonReader);
                professions.add(profession);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read professions", e);
        }
        return professions;
    }

    /*
     * Exception decompiling
     */
    String readTreeJson() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ProfessionFullInfo readProfession(JsonReader jsonReader) throws IOException {
        jsonReader.beginObject();
        String key = null;
        String title = null;
        class_1792 icon = null;
        String description = null;
        String unlockMessage = null;
        String unlockMoreMessage = null;
        boolean cantRemove = false;
        ProfessionFullInfo.Requirements requirements = null;
        while (jsonReader.hasNext()) {
            String propertyName;
            switch (propertyName = jsonReader.nextName()) {
                case "key": {
                    key = jsonReader.nextString();
                    break;
                }
                case "title": {
                    title = jsonReader.nextString();
                    break;
                }
                case "icon": {
                    icon = this.decodeIcon(jsonReader);
                    break;
                }
                case "description": {
                    description = jsonReader.nextString();
                    break;
                }
                case "unlockMessage": {
                    unlockMessage = jsonReader.nextString();
                    break;
                }
                case "unlockMoreMessage": {
                    unlockMoreMessage = jsonReader.nextString();
                    break;
                }
                case "hireMenu": {
                    cantRemove = jsonReader.nextBoolean();
                    break;
                }
                case "requirements": {
                    requirements = this.readRequirements(jsonReader);
                }
            }
        }
        jsonReader.endObject();
        return new ProfessionFullInfo(key, title, icon, description, unlockMessage, unlockMoreMessage, cantRemove, requirements);
    }

    private class_1792 decodeIcon(JsonReader reader) throws IOException {
        String iconName = reader.nextString();
        return (class_1792)class_7923.field_41178.method_10223(new class_2960(iconName));
    }

    private ProfessionFullInfo.Requirements readRequirements(JsonReader reader) throws IOException {
        String buildingRequirement = null;
        ProfessionFullInfo.BlockRequirement blockRequirement = null;
        List<ProfessionFullInfo.ItemRequirement> items = null;
        reader.beginObject();
        while (reader.hasNext()) {
            String propertyName;
            switch (propertyName = reader.nextName()) {
                case "building": {
                    buildingRequirement = reader.nextString();
                    break;
                }
                case "block": {
                    blockRequirement = this.readBlockRequirement(reader);
                    break;
                }
                case "items": {
                    items = this.readItemRequirements(reader);
                }
            }
        }
        reader.endObject();
        return new ProfessionFullInfo.Requirements(buildingRequirement, blockRequirement, items);
    }

    private ProfessionFullInfo.BlockRequirement readBlockRequirement(JsonReader reader) throws IOException {
        String blockName = null;
        boolean inBlueprint = false;
        reader.beginObject();
        while (reader.hasNext()) {
            String propertyName;
            switch (propertyName = reader.nextName()) {
                case "id": {
                    blockName = reader.nextString();
                    break;
                }
                case "inBlueprint": {
                    inBlueprint = reader.nextBoolean();
                }
            }
        }
        reader.endObject();
        if (blockName == null) {
            throw new IllegalStateException("Block requirement must have a block");
        }
        return new ProfessionFullInfo.BlockRequirement((class_2248)class_7923.field_41175.method_10223(new class_2960(blockName)), inBlueprint);
    }

    private List<ProfessionFullInfo.ItemRequirement> readItemRequirements(JsonReader reader) throws IOException {
        ArrayList<ProfessionFullInfo.ItemRequirement> itemRequirements = new ArrayList<ProfessionFullInfo.ItemRequirement>();
        reader.beginArray();
        while (reader.hasNext()) {
            itemRequirements.add(this.readItemRequirement(reader));
        }
        reader.endArray();
        return Collections.unmodifiableList(itemRequirements);
    }

    private ProfessionFullInfo.ItemRequirement readItemRequirement(JsonReader reader) throws IOException {
        String itemName = null;
        int count = 1;
        reader.beginObject();
        while (reader.hasNext()) {
            String propertyName;
            switch (propertyName = reader.nextName()) {
                case "id": {
                    itemName = reader.nextString();
                    break;
                }
                case "count": {
                    count = reader.nextInt();
                }
            }
        }
        reader.endObject();
        if (itemName == null) {
            throw new IllegalStateException("Item requirement must have an item");
        }
        return new ProfessionFullInfo.ItemRequirement((class_1792)class_7923.field_41178.method_10223(new class_2960(itemName)), count);
    }

    private static /* synthetic */ String lambda$readTreeJson$0(String a, String b) {
        return a + b;
    }
}

