/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.professions;

import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.remmintan.mods.minefortress.core.interfaces.IFortressManager;
import net.remmintan.mods.minefortress.core.interfaces.professions.CountProfessionals;
import net.remmintan.mods.minefortress.core.interfaces.professions.IBlockRequirement;
import net.remmintan.mods.minefortress.core.interfaces.professions.IProfession;
import net.remmintan.mods.minefortress.core.interfaces.professions.IProfessionsManager;
import net.remmintan.mods.minefortress.core.interfaces.professions.ProfessionResearchState;
import net.remmintan.mods.minefortress.core.interfaces.resources.IItemInfo;
import net.remmintan.mods.minefortress.core.interfaces.server.IServerFortressManager;
import org.apache.logging.log4j.util.Strings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public abstract class ProfessionManager
implements IProfessionsManager {
    public static final List<class_1792> FORESTER_ITEMS = Arrays.asList(class_1802.field_8309, class_1802.field_8179, class_1802.field_8567, class_1802.field_8317, class_1802.field_8706, class_1802.field_8188, class_1802.field_8279);
    public static final List<class_1792> FISHERMAN_ITEMS = Arrays.asList(class_1802.field_8429, class_1802.field_8209, class_1802.field_8846, class_1802.field_8323, class_1802.field_8794, class_1802.field_28410);
    private IProfession root;
    private Map<String, IProfession> professions = Collections.emptyMap();
    protected final Supplier<IFortressManager> fortressManagerSupplier;

    public ProfessionManager(Supplier<IFortressManager> fortressManagerSupplier) {
        this.fortressManagerSupplier = fortressManagerSupplier;
    }

    @Override
    public IProfession getRootProfession() {
        return this.root;
    }

    @Override
    public final ProfessionResearchState isRequirementsFulfilled(IProfession profession, CountProfessionals countProfessionals, boolean countItems) {
        boolean disabled;
        ProfessionResearchState parentState;
        String buildingRequirement = profession.getBuildingRequirement();
        if (Objects.isNull(buildingRequirement) || Strings.isBlank((String)buildingRequirement)) {
            return ProfessionResearchState.UNLOCKED;
        }
        IProfession parent = profession.getParent();
        if (Objects.nonNull(parent) && (parentState = this.isRequirementsFulfilled(parent, CountProfessionals.DONT_COUNT, false)) != ProfessionResearchState.UNLOCKED) {
            return ProfessionResearchState.LOCKED_PARENT;
        }
        boolean bl = disabled = "_".equals(buildingRequirement) && Optional.ofNullable(profession.getBlockRequirement()).map(it -> it.block() == null).orElse(true) != false;
        if (this.fortressManagerSupplier.get().isCreative() && !disabled) {
            return ProfessionResearchState.UNLOCKED;
        }
        IFortressManager fortressManager = this.fortressManagerSupplier.get();
        int minRequirementCount = 0;
        if (countProfessionals == CountProfessionals.INCREASE) {
            minRequirementCount = profession.getAmount();
        }
        boolean satisfied = fortressManager.hasRequiredBuilding(buildingRequirement, minRequirementCount);
        IBlockRequirement blockRequirement = profession.getBlockRequirement();
        if (Objects.nonNull(blockRequirement)) {
            boolean bl2 = satisfied = satisfied || fortressManager.hasRequiredBlock(blockRequirement.block(), blockRequirement.blueprint(), minRequirementCount);
        }
        if (countItems) {
            List<IItemInfo> itemsRequirement = profession.getItemsRequirement();
            if (countProfessionals != CountProfessionals.DONT_COUNT && Objects.nonNull(itemsRequirement) && !itemsRequirement.isEmpty()) {
                IServerFortressManager sfm;
                boolean hasItems = fortressManager instanceof IServerFortressManager && (sfm = (IServerFortressManager)((Object)fortressManager)).getResourceManager().hasItems(itemsRequirement);
                satisfied = satisfied && hasItems;
            }
        }
        return satisfied ? ProfessionResearchState.UNLOCKED : ProfessionResearchState.LOCKED_SELF;
    }

    @Override
    public IProfession getProfession(String id) {
        return this.getProfessions().get(id);
    }

    @Override
    public Optional<IProfession> getByBuildingRequirement(String requirement) {
        return this.getProfessions().values().stream().filter(profession -> Optional.ofNullable(profession.getBuildingRequirement()).orElse("!!!!some-invalid-requirement!!!!").equals(requirement)).findFirst();
    }

    protected @Unmodifiable @NotNull Map<String, IProfession> getProfessions() {
        return this.professions;
    }

    protected void setProfessions(Map<String, IProfession> professions) {
        this.professions = Collections.unmodifiableMap(professions);
    }

    @Override
    public boolean hasProfession(String name) {
        return this.getProfessions().containsKey(name) && this.getProfessions().get(name).getAmount() > 0;
    }

    protected void createProfessionTree(String treeJson) {
        try (StringReader sr = new StringReader(treeJson);
             JsonReader jsonReader = new JsonReader((Reader)sr);){
            jsonReader.beginObject();
            String rootProfessionName = jsonReader.nextName();
            this.root = this.getProfession(rootProfessionName);
            this.readChildren(jsonReader, this.root);
            if (jsonReader.hasNext()) {
                throw new IllegalStateException("Expected end of object, but found more.");
            }
            jsonReader.endObject();
        }
        catch (IOException exception) {
            throw new RuntimeException("cannot create profession tree", exception);
        }
    }

    private void readChildren(JsonReader reader, IProfession parent) throws IOException {
        ArrayList<IProfession> childrenProfession = new ArrayList<IProfession>();
        reader.beginObject();
        while (reader.hasNext()) {
            String childName = reader.nextName();
            IProfession childProfession = this.getProfession(childName);
            this.readChildren(reader, childProfession);
            childrenProfession.add(childProfession);
        }
        reader.endObject();
        if (!childrenProfession.isEmpty()) {
            this.addChildren(parent, childrenProfession);
        }
    }

    private void addChildren(IProfession parent, List<IProfession> children) {
        for (IProfession child : children) {
            parent.addChild(child);
            child.setParent(parent);
        }
    }

    @Override
    public int getFreeColonists() {
        IFortressManager abstractFortressManager = this.fortressManagerSupplier.get();
        int totalColonists = abstractFortressManager.getTotalColonistsCount();
        int reservedColonists = abstractFortressManager.getReservedPawnsCount();
        int totalWorkers = this.getProfessions().values().stream().mapToInt(IProfession::getAmount).sum();
        return totalColonists - totalWorkers - reservedColonists;
    }

    @Override
    public Optional<String> findIdFromProfession(IProfession profession) {
        return this.getProfessions().entrySet().stream().filter(entry -> entry.getValue() == profession).map(Map.Entry::getKey).findFirst();
    }
}

