/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.professions;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1299;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_6328;
import net.minecraft.server.MinecraftServer;
import org.minefortress.entity.BasePawnEntity;
import org.minefortress.registries.FortressEntities;

@class_6328
final class ProfessionEntityTypesMapper {
    private static final Type ENTITY_TYPES_MAP_TYPE = TypeToken.getParameterized(Map.class, (Type[])new Type[]{String.class, TypeToken.getParameterized(List.class, (Type[])new Type[]{String.class}).getType()}).getType();
    private static final class_2960 RESOURCE_ID = new class_2960("minefortress", "professions/entitytypemap.json");
    private final Gson gson = new Gson();
    private final Map<String, class_1299<? extends BasePawnEntity>> entityTypeMap = new HashMap<String, class_1299<? extends BasePawnEntity>>();

    ProfessionEntityTypesMapper() {
    }

    void read(MinecraftServer server) {
        Map entityTypeNamesMap;
        class_3300 resourceManager = server.method_34864();
        class_3298 resource = (class_3298)resourceManager.method_14486(RESOURCE_ID).orElseThrow();
        try (InputStream is = resource.method_14482();
             InputStreamReader isr = new InputStreamReader(is);){
            entityTypeNamesMap = (Map)this.gson.fromJson((Reader)isr, ENTITY_TYPES_MAP_TYPE);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read professions", e);
        }
        this.entityTypeMap.clear();
        for (Map.Entry entry : entityTypeNamesMap.entrySet()) {
            String typeLabel = (String)entry.getKey();
            class_1299<? extends BasePawnEntity> type = this.convert(typeLabel);
            for (String professionLabel : (List)entry.getValue()) {
                this.entityTypeMap.put(professionLabel, type);
            }
        }
    }

    class_1299<? extends BasePawnEntity> getEntityTypeForProfession(String profession) {
        return this.entityTypeMap.getOrDefault(profession, FortressEntities.COLONIST_ENTITY_TYPE);
    }

    private class_1299<? extends BasePawnEntity> convert(String entityType) {
        return switch (entityType) {
            case "warrior" -> FortressEntities.WARRIOR_PAWN_ENTITY_TYPE;
            case "archer" -> FortressEntities.ARCHER_PAWN_ENTITY_TYPE;
            default -> FortressEntities.COLONIST_ENTITY_TYPE;
        };
    }
}

