/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.professions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1799;
import net.minecraft.class_189;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.remmintan.mods.minefortress.core.dtos.professions.ProfessionFullInfo;
import net.remmintan.mods.minefortress.core.interfaces.professions.IBlockRequirement;
import net.remmintan.mods.minefortress.core.interfaces.professions.IProfession;
import net.remmintan.mods.minefortress.core.interfaces.resources.IItemInfo;
import org.jetbrains.annotations.Nullable;
import org.minefortress.fortress.resources.ItemInfo;
import org.minefortress.utils.GuiUtils;

public class Profession
implements IProfession {
    private final String id;
    private final String title;
    private final class_1799 icon;
    private int amount = 0;
    private final class_189 type = class_189.field_1254;
    private final List<class_2561> description;
    private final List<class_2561> unlockMoreMessage;
    private final List<class_2561> unlockMessage;
    private final String buildingRequirement;
    private final class_2248 blockRequirement;
    private final List<IItemInfo> itemsRequirement;
    private final boolean hireMenu;
    private final boolean blueprint;
    private IProfession parent;
    private final List<IProfession> children = new ArrayList<IProfession>();

    public Profession(ProfessionFullInfo fullInfo) {
        this.id = fullInfo.key();
        this.title = fullInfo.title();
        this.icon = new class_1799((class_1935)fullInfo.icon());
        this.hireMenu = fullInfo.hireMenu();
        ProfessionFullInfo.Requirements requirements = fullInfo.requirements();
        if (requirements != null) {
            this.buildingRequirement = requirements.building();
            ProfessionFullInfo.BlockRequirement blockRequirement = requirements.block();
            if (blockRequirement != null && !class_2246.field_10124.equals(blockRequirement.block())) {
                this.blockRequirement = blockRequirement.block();
                this.blueprint = blockRequirement.inBlueprint();
            } else {
                this.blockRequirement = null;
                this.blueprint = false;
            }
            this.itemsRequirement = requirements.items().stream().map(it -> new ItemInfo(it.item(), it.count())).toList();
        } else {
            this.buildingRequirement = "";
            this.blockRequirement = null;
            this.blueprint = false;
            this.itemsRequirement = Collections.emptyList();
        }
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            this.description = GuiUtils.splitTextInWordsForLength(fullInfo.description());
            this.unlockMessage = GuiUtils.splitTextInWordsForLength(fullInfo.unlockMessage());
            this.unlockMoreMessage = GuiUtils.splitTextInWordsForLength(fullInfo.unlockMoreMessage());
        } else {
            this.description = null;
            this.unlockMessage = null;
            this.unlockMoreMessage = null;
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public boolean isHireMenu() {
        return this.hireMenu;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public class_1799 getIcon() {
        return this.icon;
    }

    @Override
    public int getAmount() {
        return this.amount;
    }

    @Override
    public void setAmount(int amount) {
        this.amount = amount;
    }

    @Override
    public class_189 getType() {
        return this.type;
    }

    @Override
    public void setParent(IProfession profession) {
        if (this.parent != null) {
            throw new IllegalStateException("Profession already has a parent");
        }
        this.parent = profession;
    }

    @Override
    public void addChild(IProfession profession) {
        this.children.add(profession);
    }

    @Override
    public List<IProfession> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    @Override
    public List<class_2561> getDescription() {
        return this.description;
    }

    @Override
    public List<class_2561> getUnlockMessage() {
        return this.unlockMessage;
    }

    @Override
    public List<class_2561> getUnlockMoreMessage() {
        return this.unlockMoreMessage;
    }

    @Override
    public IProfession getParent() {
        return this.parent;
    }

    @Override
    public List<IItemInfo> getItemsRequirement() {
        return this.itemsRequirement;
    }

    @Override
    @Nullable
    public String getBuildingRequirement() {
        return this.buildingRequirement;
    }

    @Override
    @Nullable
    public IBlockRequirement getBlockRequirement() {
        return new BlockRequirement(this.blockRequirement, this.blueprint);
    }

    @Override
    public class_2487 toNbt() {
        class_2487 nbtCompound = new class_2487();
        nbtCompound.method_10569("amount", this.amount);
        return nbtCompound;
    }

    @Override
    public void readNbt(class_2487 nbtCompound) {
        this.amount = nbtCompound.method_10545("amount") ? nbtCompound.method_10550("amount") : 0;
    }

    public record BlockRequirement(class_2248 block, boolean blueprint) implements IBlockRequirement
    {
    }
}

