/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.professions;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.remmintan.mods.minefortress.core.dtos.professions.IProfessionEssentialInfo;
import net.remmintan.mods.minefortress.core.dtos.professions.ProfessionFullInfo;
import net.remmintan.mods.minefortress.core.interfaces.IFortressManager;
import net.remmintan.mods.minefortress.core.interfaces.professions.CountProfessionals;
import net.remmintan.mods.minefortress.core.interfaces.professions.IClientProfessionManager;
import net.remmintan.mods.minefortress.core.interfaces.professions.IHireInfo;
import net.remmintan.mods.minefortress.core.interfaces.professions.IProfession;
import net.remmintan.mods.minefortress.core.interfaces.professions.ProfessionResearchState;
import net.remmintan.mods.minefortress.networking.c2s.ServerboundChangeProfessionStatePacket;
import net.remmintan.mods.minefortress.networking.helpers.FortressClientNetworkHelper;
import org.minefortress.professions.Profession;
import org.minefortress.professions.ProfessionManager;
import org.minefortress.professions.hire.IHireScreenHandler;
import org.minefortress.renderer.gui.hire.HirePawnScreen;

public final class ClientProfessionManager
extends ProfessionManager
implements IClientProfessionManager {
    public ClientProfessionManager(Supplier<IFortressManager> fortressManagerSupplier) {
        super(fortressManagerSupplier);
    }

    @Override
    public void initProfessions(List<ProfessionFullInfo> fullInfos, String treeJson) {
        Map<String, IProfession> professionsMap = fullInfos.stream().collect(Collectors.toMap(ProfessionFullInfo::key, it -> new Profession((ProfessionFullInfo)it)));
        super.setProfessions(professionsMap);
        super.createProfessionTree(treeJson);
    }

    @Override
    public void increaseAmount(String professionId, boolean alreadyCharged) {
        if ("colonist".equals(professionId)) {
            return;
        }
        IProfession profession = this.getProfession(professionId);
        ProfessionResearchState unlockedForNormalIncrease = super.isRequirementsFulfilled(profession, CountProfessionals.INCREASE, true);
        ProfessionResearchState unlockedForHireMenu = super.isRequirementsFulfilled(profession, CountProfessionals.DONT_COUNT, false);
        if (unlockedForNormalIncrease == ProfessionResearchState.UNLOCKED || profession.isHireMenu() && unlockedForHireMenu == ProfessionResearchState.UNLOCKED) {
            ServerboundChangeProfessionStatePacket.AmountChange change = ServerboundChangeProfessionStatePacket.AmountChange.ADD;
            ServerboundChangeProfessionStatePacket packet = new ServerboundChangeProfessionStatePacket(professionId, change);
            FortressClientNetworkHelper.send("fortress_profession_state_change", packet);
        } else if (profession.isHireMenu() && unlockedForHireMenu == ProfessionResearchState.LOCKED_PARENT) {
            IProfession parent = profession.getParent();
            class_5250 message = class_2561.method_43470((String)("\u00a7cCan't hire " + profession.getTitle() + "\u00a7c. You need to unlock the " + parent.getTitle() + "\u00a7c profession first."));
            class_310.method_1551().method_1507(null);
            Optional.ofNullable(class_310.method_1551().field_1724).ifPresent(it -> it.method_7353((class_2561)message, false));
        }
    }

    @Override
    public void decreaseAmount(String professionId) {
        if ("colonist".equals(professionId)) {
            return;
        }
        IProfession profession = this.getProfession(professionId);
        boolean cantRemove = profession.isHireMenu();
        if (cantRemove) {
            class_5250 message = class_2561.method_43470((String)("\u00a7cCan't remove pawn from profession: " + profession.getTitle()));
            class_310.method_1551().method_1507(null);
            Optional.ofNullable(class_310.method_1551().field_1724).ifPresent(it -> it.method_7353((class_2561)message, true));
            return;
        }
        ServerboundChangeProfessionStatePacket.AmountChange change = ServerboundChangeProfessionStatePacket.AmountChange.REMOVE;
        ServerboundChangeProfessionStatePacket packet = new ServerboundChangeProfessionStatePacket(professionId, change);
        FortressClientNetworkHelper.send("fortress_profession_state_change", packet);
    }

    @Override
    public void updateProfessions(List<IProfessionEssentialInfo> info) {
        for (IProfessionEssentialInfo professionEssentialInfo : info) {
            IProfession profession = this.getProfession(professionEssentialInfo.id());
            if (profession == null) continue;
            profession.setAmount(professionEssentialInfo.amount());
        }
    }

    @Override
    public void syncCurrentScreenHandler(Map<String, IHireInfo> hireInfos) {
        HirePawnScreen screen;
        IHireScreenHandler handler;
        class_437 currentScreen = class_310.method_1551().field_1755;
        if (currentScreen instanceof HirePawnScreen && (handler = (screen = (HirePawnScreen)currentScreen).getHandler()) != null) {
            handler.sync(hireInfos);
        }
    }
}

