/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.mixins.renderer.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.minecraft.class_1124;
import net.minecraft.class_1129;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_481;
import net.minecraft.class_485;
import net.minecraft.class_490;
import net.minecraft.class_636;
import net.minecraft.class_6862;
import net.minecraft.class_746;
import net.minecraft.class_757;
import net.minecraft.class_7699;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import net.remmintan.mods.minefortress.core.interfaces.resources.IClientResourceManager;
import org.jetbrains.annotations.Nullable;
import org.minefortress.renderer.gui.resources.FortressSurvivalInventoryScreenHandler;
import org.minefortress.utils.ModUtils;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_481.class})
public abstract class FortressCreativeInventoryScreenMixin
extends class_485<class_481.class_483> {
    @Shadow
    @Final
    private static class_2960 field_2893;
    @Shadow
    @Final
    private static String field_32335;
    @Shadow
    private static class_1761 field_2896;
    @Shadow
    private class_342 field_2894;
    @Shadow
    private float field_2890;
    @Shadow
    @Nullable
    private class_1735 field_2889;
    @Shadow
    @Final
    private static class_2561 field_26563;
    @Shadow
    private boolean field_2892;
    @Shadow
    @Final
    private Set<class_6862<class_1792>> field_16201;
    @Shadow
    @Final
    static class_1277 field_2895;

    @Shadow
    protected abstract boolean method_2465();

    @Shadow
    protected abstract void method_15871(String var1);

    @Shadow
    protected abstract boolean method_2463(class_1761 var1, double var2, double var4);

    @Shadow
    protected abstract void method_2466(class_1761 var1);

    @Shadow
    public abstract boolean method_47424();

    @Shadow
    protected abstract void method_2468(class_332 var1, class_1761 var2);

    @Shadow
    protected abstract boolean method_2471(class_332 var1, class_1761 var2, int var3, int var4);

    public FortressCreativeInventoryScreenMixin(class_481.class_483 screenHandler, class_1661 playerInventory, class_2561 text) {
        super((class_1703)screenHandler, playerInventory, text);
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    void init(class_1657 player, class_7699 enabledFeatures, boolean operatorTabEnabled, CallbackInfo ci) {
        if (FortressCreativeInventoryScreenMixin.isFortressSurvival()) {
            player.field_7512 = this.field_2797 = new FortressSurvivalInventoryScreenHandler(player, (class_1263)field_2895);
        }
    }

    @Redirect(method={"onMouseClick"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/network/ClientPlayerEntity;dropItem(Lnet/minecraft/item/ItemStack;Z)Lnet/minecraft/entity/ItemEntity;"))
    class_1542 dropItem(class_746 instance, class_1799 itemStack, boolean b) {
        if (ModUtils.isClientInFortressGamemode()) {
            return null;
        }
        return instance.method_7328(itemStack, b);
    }

    @Inject(method={"onMouseClick"}, at={@At(value="HEAD")}, cancellable=true)
    void onCLickHead(class_1735 slot, int slotId, int button, class_1713 actionType, CallbackInfo ci) {
        if (ModUtils.isFortressGamemode((class_1657)this.getClient().field_1724) && actionType == class_1713.field_7791) {
            ci.cancel();
        }
    }

    @Redirect(method={"onMouseClick"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/network/ClientPlayerInteractionManager;dropCreativeStack(Lnet/minecraft/item/ItemStack;)V"))
    void dropCreativeStack(class_636 instance, class_1799 stack) {
        if (!ModUtils.isClientInFortressGamemode()) {
            instance.method_2915(stack);
        }
    }

    @Inject(method={"mouseReleased"}, at={@At(value="HEAD")}, cancellable=true)
    public void mouseReleased(double mouseX, double mouseY, int button, CallbackInfoReturnable<Boolean> cir) {
        if (FortressCreativeInventoryScreenMixin.isFortressSurvival()) {
            if (button == 0) {
                double d = mouseX - (double)this.field_2776;
                double e = mouseY - (double)this.field_2800;
                this.field_2892 = false;
                for (class_1761 itemGroup : FortressCreativeInventoryScreenMixin.getResourceManager().getGroups()) {
                    if (!this.method_2463(itemGroup, d, e)) continue;
                    this.method_2466(itemGroup);
                    cir.setReturnValue((Object)true);
                }
            }
            cir.setReturnValue((Object)super.method_25406(mouseX, mouseY, button));
        }
    }

    @Inject(method={"render"}, at={@At(value="HEAD")}, cancellable=true)
    public void render(class_332 context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        if (FortressCreativeInventoryScreenMixin.isFortressSurvival()) {
            this.method_25420(context);
            super.method_25394(context, mouseX, mouseY, delta);
            for (class_1761 itemGroup : FortressCreativeInventoryScreenMixin.getResourceManager().getGroups()) {
                if (this.method_2471(context, itemGroup, mouseX, mouseY)) break;
            }
            if (this.field_2889 != null && field_2896.method_47312() == class_1761.class_7916.field_41053 && this.method_2378(this.field_2889.field_7873, this.field_2889.field_7872, 16, 16, mouseX, mouseY)) {
                context.method_51438(this.field_22793, field_26563, mouseX, mouseY);
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.method_2380(context, mouseX, mouseY);
            ci.cancel();
        }
    }

    @Inject(method={"drawBackground"}, at={@At(value="HEAD")}, cancellable=true)
    public void drawBackground(class_332 context, float delta, int mouseX, int mouseY, CallbackInfo ci) {
        if (FortressCreativeInventoryScreenMixin.isFortressSurvival()) {
            class_1761 itemGroup = field_2896;
            for (class_1761 itemGroup2 : FortressCreativeInventoryScreenMixin.getResourceManager().getGroups()) {
                RenderSystem.setShader(class_757::method_34542);
                RenderSystem.setShaderTexture((int)0, (class_2960)field_2893);
                if (itemGroup2 == field_2896) continue;
                this.method_2468(context, itemGroup2);
            }
            class_2960 texture = new class_2960(field_32335 + itemGroup.method_7742());
            context.method_25302(texture, this.field_2776, this.field_2800, 0, 0, this.field_2792, this.field_2779);
            this.field_2894.method_25394(context, mouseX, mouseY, delta);
            int i = this.field_2776 + 175;
            int j = this.field_2800 + 18;
            int k = j + 112;
            if (itemGroup.method_7756()) {
                context.method_25302(field_2893, i, j + (int)((float)(k - j - 17) * this.field_2890), 232 + (this.method_2465() ? 0 : 12), 0, 12, 15);
            }
            this.method_2468(context, itemGroup);
            if (itemGroup == class_7923.field_44687.method_29107(class_7706.field_40206)) {
                class_490.method_2486((class_332)context, (int)(this.field_2776 + 88), (int)(this.field_2800 + 45), (int)20, (float)(this.field_2776 + 88 - mouseX), (float)(this.field_2800 + 45 - 30 - mouseY), (class_1309)ModUtils.getClientPlayer());
            }
            ci.cancel();
        }
    }

    @Inject(method={"handledScreenTick"}, at={@At(value="HEAD")}, cancellable=true)
    public void tick(CallbackInfo ci) {
        if (ModUtils.isClientInFortressGamemode() && ModUtils.getFortressClientManager().isSurvival()) {
            if (this.method_47424()) {
                this.method_2466((class_1761)class_7923.field_44687.method_29107(class_7706.field_40195));
            }
            ci.cancel();
        }
    }

    @Inject(method={"setSelectedTab"}, at={@At(value="HEAD")}, cancellable=true)
    public void setSelectedTabInj(class_1761 group, CallbackInfo ci) {
        if (FortressCreativeInventoryScreenMixin.isFortressSurvival()) {
            field_2896 = group;
            this.field_2793.clear();
            ((class_481.class_483)this.field_2797).field_2897.clear();
            List<class_1799> stacks = FortressCreativeInventoryScreenMixin.getResourceManager().getStacks(group);
            ((class_481.class_483)this.field_2797).field_2897.addAll(stacks);
            this.field_2890 = 0.0f;
            ((class_481.class_483)this.field_2797).method_2473(0.0f);
            ci.cancel();
        }
    }

    @Inject(method={"search"}, at={@At(value="HEAD")}, cancellable=true)
    public void search(CallbackInfo ci) {
        if (FortressCreativeInventoryScreenMixin.isFortressSurvival()) {
            this.field_16201.clear();
            String string = this.field_2894.method_1882();
            if (string.isEmpty()) {
                for (class_1792 item : class_7923.field_41178) {
                    ((class_481.class_483)this.field_2797).field_2897.addAll(field_2896.method_47313());
                }
            } else {
                class_1129 searchProvider;
                if (string.startsWith("#")) {
                    string = string.substring(1);
                    searchProvider = this.field_22787.method_1484(class_1124.field_5494);
                    this.method_15871(string);
                } else {
                    searchProvider = this.getClient().method_1484(class_1124.field_5495);
                }
                ((class_481.class_483)this.field_2797).field_2897.addAll((Collection)searchProvider.method_4810(string.toLowerCase(Locale.ROOT)));
            }
            this.field_2890 = 0.0f;
            ((class_481.class_483)this.field_2797).method_2473(0.0f);
            ci.cancel();
        }
    }

    @Unique
    private class_310 getClient() {
        return class_310.method_1551();
    }

    @Unique
    private static boolean isFortressSurvival() {
        return ModUtils.isClientInFortressGamemode() && !ModUtils.getFortressClientManager().isCreative();
    }

    @Unique
    private static IClientResourceManager getResourceManager() {
        return ModUtils.getFortressClientManager().getResourceManager();
    }

    static {
        field_2896 = class_7706.method_47328();
    }
}

