/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.mixins.renderer;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2784;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4599;
import net.minecraft.class_4604;
import net.minecraft.class_638;
import net.minecraft.class_757;
import net.minecraft.class_761;
import net.minecraft.class_765;
import net.minecraft.class_824;
import net.minecraft.class_898;
import net.remmintan.mods.minefortress.core.FortressState;
import net.remmintan.mods.minefortress.core.interfaces.client.IClientFortressManager;
import net.remmintan.mods.minefortress.core.interfaces.client.IClientManagersProvider;
import net.remmintan.mods.minefortress.core.interfaces.infuence.IClientInfluenceManager;
import net.remmintan.mods.minefortress.core.interfaces.selections.ISelectionManager;
import net.remmintan.mods.minefortress.core.utils.CoreModUtils;
import org.joml.Matrix4f;
import org.joml.Vector4f;
import org.minefortress.fortress.FortressBorder;
import org.minefortress.interfaces.IFortressMinecraftClient;
import org.minefortress.renderer.MineFortressLabelsRenderer;
import org.minefortress.utils.ModUtils;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_761.class})
public abstract class FortressWorldRendererMixin {
    private static final class_2960 FORCEFIELD = new class_2960("textures/misc/forcefield.png");
    @Shadow
    @Final
    private class_310 field_4088;
    @Shadow
    private class_638 field_4085;
    @Shadow
    @Final
    private class_4599 field_20951;
    private MineFortressLabelsRenderer entityRenderer;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    public void init(class_310 client, class_898 entityRenderDispatcher, class_824 blockEntityRenderDispatcher, class_4599 bufferBuilders, CallbackInfo ci) {
        IClientManagersProvider fortressClient = (IClientManagersProvider)client;
        this.entityRenderer = new MineFortressLabelsRenderer(client.field_1772, fortressClient::get_SelectionManager, () -> fortressClient.get_ClientFortressManager().getBuildingHealths());
    }

    @Inject(method={"setupTerrain"}, at={@At(value="TAIL")})
    public void setupTerrain(class_4184 camera, class_4604 frustum, boolean hasForcedFrustum, boolean spectator, CallbackInfo ci) {
        IFortressMinecraftClient fortressClient = (IFortressMinecraftClient)this.field_4088;
        fortressClient.get_BlueprintRenderer().prepareForRender();
        fortressClient.get_CampfireRenderer().prepareForRender();
        fortressClient.get_SelectionRenderer().prepareForRender();
        fortressClient.get_TasksRenderer().prepareForRender();
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", ordinal=2, target="Lnet/minecraft/client/render/WorldRenderer;renderLayer(Lnet/minecraft/client/render/RenderLayer;Lnet/minecraft/client/util/math/MatrixStack;DDDLorg/joml/Matrix4f;)V", shift=At.Shift.AFTER)})
    public void renderObjectsOnTerrain(class_4587 matrices, float tickDelta, long limitTime, boolean renderBlockOutline, class_4184 camera, class_757 gameRenderer, class_765 lightmapTextureManager, Matrix4f projectionMatrix, CallbackInfo ci) {
        class_3965 bhr;
        class_2338 pos;
        class_239 crosshairTarget;
        class_243 cameraPos = camera.method_19326();
        IFortressMinecraftClient fortressClient = (IFortressMinecraftClient)this.field_4088;
        fortressClient.get_BlueprintRenderer().render(matrices, cameraPos.field_1352, cameraPos.field_1351, cameraPos.field_1350, projectionMatrix);
        fortressClient.get_CampfireRenderer().render(matrices, cameraPos.field_1352, cameraPos.field_1351, cameraPos.field_1350, projectionMatrix);
        fortressClient.get_SelectionRenderer().render(matrices, cameraPos.field_1352, cameraPos.field_1351, cameraPos.field_1350, projectionMatrix);
        fortressClient.get_TasksRenderer().render(matrices, cameraPos.field_1352, cameraPos.field_1351, cameraPos.field_1350, projectionMatrix);
        IClientManagersProvider provider = CoreModUtils.getMineFortressManagersProvider();
        ISelectionManager selectionManager = provider.get_SelectionManager();
        class_4597.class_4598 immediate = this.field_20951.method_23000();
        class_4588 vertexConsumer = immediate.getBuffer(class_1921.method_23594());
        IClientFortressManager fcm = provider.get_ClientFortressManager();
        if (!selectionManager.isSelecting() && fcm.getState() == FortressState.BUILD && ModUtils.isClientInFortressGamemode() && (crosshairTarget = this.field_4088.field_1765) instanceof class_3965 && (pos = (bhr = (class_3965)crosshairTarget).method_17777()) != null && !this.field_4085.method_8320(pos).method_26215()) {
            List<class_2338> buildingSelection = fcm.getBuildingSelection(pos);
            for (class_2338 sel : buildingSelection) {
                class_2680 blockState;
                if (!this.field_4085.method_8621().method_11952(sel) || (blockState = this.field_4085.method_8320(sel)).method_26215()) continue;
                this.drawBlockOutline(matrices, vertexConsumer, camera.method_19331(), cameraPos.field_1352, cameraPos.field_1351, cameraPos.field_1350, sel, blockState);
            }
        }
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", ordinal=11, target="Lnet/minecraft/util/profiler/Profiler;swap(Ljava/lang/String;)V", shift=At.Shift.AFTER)})
    public void renderSelectionLabels(class_4587 matrices, float tickDelta, long limitTime, boolean renderBlockOutline, class_4184 camera, class_757 gameRenderer, class_765 lightmapTextureManager, Matrix4f projectionMatrix, CallbackInfo ci) {
        if (!this.field_4088.field_1690.field_1842) {
            this.entityRenderer.prepare(camera);
            class_243 cameraPos = camera.method_19326();
            class_4597.class_4598 immediate = this.field_20951.method_23000();
            this.entityRenderer.render(cameraPos.field_1352, cameraPos.field_1351, cameraPos.field_1350, matrices, (class_4597)immediate, class_765.method_23687((int)15, (int)15));
        }
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", ordinal=14, target="Lnet/minecraft/util/profiler/Profiler;swap(Ljava/lang/String;)V", shift=At.Shift.AFTER)})
    public void renderTranslucent(class_4587 matrices, float tickDelta, long limitTime, boolean renderBlockOutline, class_4184 camera, class_757 gameRenderer, class_765 lightmapTextureManager, Matrix4f matrix4f, CallbackInfo ci) {
        this.renderTranslucent(matrices, camera, matrix4f);
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", ordinal=18, target="Lnet/minecraft/util/profiler/Profiler;swap(Ljava/lang/String;)V", shift=At.Shift.BY, by=-3)})
    public void renderTranslucentBuffer(class_4587 matrices, float tickDelta, long limitTime, boolean renderBlockOutline, class_4184 camera, class_757 gameRenderer, class_765 lightmapTextureManager, Matrix4f matrix4f, CallbackInfo ci) {
        this.renderTranslucent(matrices, camera, matrix4f);
    }

    @Unique
    private class_2784 getWorldBorder(class_638 instance) {
        block3: {
            IClientInfluenceManager influenceManager;
            block2: {
                boolean selectingBlueprint = ModUtils.getBlueprintManager().isSelecting();
                boolean selecting = ModUtils.getSelectionManager().isSelecting();
                boolean selectingArea = ModUtils.getAreasClientManager().isSelecting();
                boolean centerNotSet = ModUtils.getFortressClientManager().isCenterNotSet();
                influenceManager = ModUtils.getInfluenceManager();
                boolean isCapturingPoint = influenceManager.isSelecting();
                if (selectingBlueprint || selecting || selectingArea || centerNotSet) break block2;
                if (!isCapturingPoint) break block3;
            }
            return influenceManager.getFortressBorder().orElseGet(() -> ((class_638)instance).method_8621());
        }
        return instance.method_8621();
    }

    @Inject(method={"renderWorldBorder"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderCustomWorldBorder(class_4184 camera, CallbackInfo ci) {
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        class_2784 worldBorder = this.getWorldBorder(this.field_4085);
        double viewDistance = this.field_4088.field_1690.method_38521() * 16;
        if (!(camera.method_19326().field_1352 < worldBorder.method_11963() - viewDistance && camera.method_19326().field_1352 > worldBorder.method_11976() + viewDistance && camera.method_19326().field_1350 < worldBorder.method_11977() - viewDistance && camera.method_19326().field_1350 > worldBorder.method_11958() + viewDistance)) {
            double e = 1.0 - worldBorder.method_11961(camera.method_19326().field_1352, camera.method_19326().field_1350) / viewDistance;
            e = Math.pow(e, 4.0);
            e = class_3532.method_15350((double)e, (double)0.0, (double)1.0);
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
            RenderSystem.setShaderTexture((int)0, (class_2960)FORCEFIELD);
            RenderSystem.depthMask((boolean)class_310.method_29611());
            class_4587 matrixStack = RenderSystem.getModelViewStack();
            matrixStack.method_22903();
            RenderSystem.applyModelViewMatrix();
            int i = worldBorder.method_11968().method_11999();
            float j = (float)(i >> 16 & 0xFF) / 255.0f;
            float k = (float)(i >> 8 & 0xFF) / 255.0f;
            float l = (float)(i & 0xFF) / 255.0f;
            RenderSystem.setShaderColor((float)j, (float)k, (float)l, (float)((float)e));
            RenderSystem.setShader(class_757::method_34542);
            RenderSystem.polygonOffset((float)-3.0f, (float)-3.0f);
            RenderSystem.enablePolygonOffset();
            RenderSystem.disableCull();
            bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
            BiFunction<Double, Double, Boolean> shouldRenderBoundFunc = (x, z) -> {
                FortressBorder fb;
                return worldBorder instanceof FortressBorder && (fb = (FortressBorder)worldBorder).shouldRenderBound((Double)x, (Double)z);
            };
            this.renderParticularBorder(camera, bufferBuilder, worldBorder, viewDistance, shouldRenderBoundFunc);
            if (worldBorder instanceof FortressBorder) {
                FortressBorder fortressBorder = (FortressBorder)worldBorder;
                fortressBorder.getAdditionalBorders().forEach(border -> this.renderParticularBorder(camera, bufferBuilder, (class_2784)border, viewDistance, shouldRenderBoundFunc));
            }
            class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
            RenderSystem.enableCull();
            RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
            RenderSystem.disablePolygonOffset();
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
            matrixStack.method_22909();
            RenderSystem.applyModelViewMatrix();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.depthMask((boolean)true);
        }
        ci.cancel();
    }

    private void renderParticularBorder(class_4184 camera, class_287 bufferBuilder, class_2784 worldBorder, double viewDistance, BiFunction<Double, Double, Boolean> shouldRenderBound) {
        double boundWest;
        float v;
        double u;
        double t;
        float s;
        float m = (float)(class_156.method_658() % 3000L) / 3000.0f;
        float n = (float)(-class_3532.method_15385((double)(camera.method_19326().field_1351 * 0.5)));
        double cameraX = camera.method_19326().field_1352;
        double cameraZ = camera.method_19326().field_1350;
        double cameraDistance = this.field_4088.field_1773.method_32796();
        float o = n + (float)cameraDistance;
        double boundNorth = worldBorder.method_11958();
        double p = Math.max((double)class_3532.method_15357((double)(cameraZ - viewDistance)), boundNorth);
        double boundSouth = worldBorder.method_11977();
        double q = Math.min((double)class_3532.method_15384((double)(cameraZ + viewDistance)), boundSouth);
        float r = (float)(class_3532.method_15357((double)p) & 1) * 0.5f;
        double centerX = worldBorder.method_11964();
        double centerZ = worldBorder.method_11980();
        double boundEast = worldBorder.method_11963();
        if (cameraX > boundEast - viewDistance && shouldRenderBound.apply(boundEast, centerZ).booleanValue()) {
            s = r;
            t = p;
            while (t < q) {
                u = Math.min(1.0, q - t);
                v = (float)u * 0.5f;
                bufferBuilder.method_22912(boundEast - cameraX, -cameraDistance, t - cameraZ).method_22913(m - s, m + o).method_1344();
                bufferBuilder.method_22912(boundEast - cameraX, -cameraDistance, t + u - cameraZ).method_22913(m - (v + s), m + o).method_1344();
                bufferBuilder.method_22912(boundEast - cameraX, cameraDistance, t + u - cameraZ).method_22913(m - (v + s), m + n).method_1344();
                bufferBuilder.method_22912(boundEast - cameraX, cameraDistance, t - cameraZ).method_22913(m - s, m + n).method_1344();
                t += 1.0;
                s += 0.5f;
            }
        }
        if (cameraX < (boundWest = worldBorder.method_11976()) + viewDistance && shouldRenderBound.apply(boundWest, centerZ).booleanValue()) {
            s = r;
            t = p;
            while (t < q) {
                u = Math.min(1.0, q - t);
                v = (float)u * 0.5f;
                bufferBuilder.method_22912(boundWest - cameraX, -cameraDistance, t - cameraZ).method_22913(m + s, m + o).method_1344();
                bufferBuilder.method_22912(boundWest - cameraX, -cameraDistance, t + u - cameraZ).method_22913(m + v + s, m + o).method_1344();
                bufferBuilder.method_22912(boundWest - cameraX, cameraDistance, t + u - cameraZ).method_22913(m + v + s, m + n).method_1344();
                bufferBuilder.method_22912(boundWest - cameraX, cameraDistance, t - cameraZ).method_22913(m + s, m + n).method_1344();
                t += 1.0;
                s += 0.5f;
            }
        }
        p = Math.max((double)class_3532.method_15357((double)(cameraX - viewDistance)), boundWest);
        q = Math.min((double)class_3532.method_15384((double)(cameraX + viewDistance)), boundEast);
        r = (float)(class_3532.method_15357((double)p) & 1) * 0.5f;
        if (cameraZ > boundSouth - viewDistance && shouldRenderBound.apply(centerX, boundSouth).booleanValue()) {
            s = r;
            t = p;
            while (t < q) {
                u = Math.min(1.0, q - t);
                v = (float)u * 0.5f;
                bufferBuilder.method_22912(t - cameraX, -cameraDistance, boundSouth - cameraZ).method_22913(m + s, m + o).method_1344();
                bufferBuilder.method_22912(t + u - cameraX, -cameraDistance, boundSouth - cameraZ).method_22913(m + v + s, m + o).method_1344();
                bufferBuilder.method_22912(t + u - cameraX, cameraDistance, boundSouth - cameraZ).method_22913(m + v + s, m + n).method_1344();
                bufferBuilder.method_22912(t - cameraX, cameraDistance, boundSouth - cameraZ).method_22913(m + s, m + n).method_1344();
                t += 1.0;
                s += 0.5f;
            }
        }
        if (cameraZ < boundNorth + viewDistance && shouldRenderBound.apply(centerX, boundNorth).booleanValue()) {
            s = r;
            t = p;
            while (t < q) {
                u = Math.min(1.0, q - t);
                v = (float)u * 0.5f;
                bufferBuilder.method_22912(t - cameraX, -cameraDistance, boundNorth - cameraZ).method_22913(m - s, m + o).method_1344();
                bufferBuilder.method_22912(t + u - cameraX, -cameraDistance, boundNorth - cameraZ).method_22913(m - (v + s), m + o).method_1344();
                bufferBuilder.method_22912(t + u - cameraX, cameraDistance, boundNorth - cameraZ).method_22913(m - (v + s), m + n).method_1344();
                bufferBuilder.method_22912(t - cameraX, cameraDistance, boundNorth - cameraZ).method_22913(m - s, m + n).method_1344();
                t += 1.0;
                s += 0.5f;
            }
        }
    }

    @Unique
    private void renderTranslucent(class_4587 matrices, class_4184 camera, Matrix4f matrix4f) {
        IFortressMinecraftClient fortressClient = (IFortressMinecraftClient)this.field_4088;
        fortressClient.get_SelectionRenderer().renderTranslucent(matrices, camera.method_19326().field_1352, camera.method_19326().field_1351, camera.method_19326().field_1350, matrix4f);
        fortressClient.get_BlueprintRenderer().renderTranslucent(matrices, camera.method_19326().field_1352, camera.method_19326().field_1351, camera.method_19326().field_1350, matrix4f);
    }

    @Unique
    private void drawBlockOutline(class_4587 matrices, class_4588 vertexConsumer, class_1297 entity, double d, double e, double f, class_2338 blockPos, class_2680 blockState) {
        Vector4f clickColors = ((IClientManagersProvider)this.field_4088).get_SelectionManager().getClickColor();
        class_265 outlineShape = blockState.method_26172((class_1922)this.field_4085, blockPos, class_3726.method_16195((class_1297)entity));
        class_761.method_22983((class_4587)matrices, (class_4588)vertexConsumer, (class_265)outlineShape, (double)((double)blockPos.method_10263() - d), (double)((double)blockPos.method_10264() - e), (double)((double)blockPos.method_10260() - f), (float)clickColors.x(), (float)clickColors.y(), (float)clickColors.z(), (float)clickColors.w(), (boolean)true);
    }
}

