/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.mixins.interaction;

import net.minecraft.class_1156;
import net.minecraft.class_1157;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1934;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_312;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import net.minecraft.class_636;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.remmintan.mods.minefortress.building.BuildingHelper;
import net.remmintan.mods.minefortress.core.FortressState;
import net.remmintan.mods.minefortress.core.interfaces.blueprints.IClientBlueprintManager;
import net.remmintan.mods.minefortress.core.interfaces.buildings.IEssentialBuildingInfo;
import net.remmintan.mods.minefortress.core.interfaces.client.IClientFortressManager;
import net.remmintan.mods.minefortress.core.interfaces.client.IClientManagersProvider;
import net.remmintan.mods.minefortress.core.interfaces.combat.IClientFightManager;
import net.remmintan.mods.minefortress.core.interfaces.combat.IClientFightSelectionManager;
import net.remmintan.mods.minefortress.core.interfaces.infuence.IClientInfluenceManager;
import net.remmintan.mods.minefortress.core.interfaces.selections.ISelectionManager;
import net.remmintan.mods.minefortress.core.interfaces.tasks.IAreasClientManager;
import org.minefortress.MineFortressMod;
import org.minefortress.renderer.gui.fortress.ManageBuildingScreen;
import org.minefortress.utils.BlockUtils;
import org.minefortress.utils.ModUtils;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_636.class})
public abstract class FortressClientInteractionManagerMixin {
    @Unique
    private static final class_1934 FORTRESS = MineFortressMod.FORTRESS;
    @Shadow
    @Final
    private class_310 field_3712;

    @Shadow
    public abstract class_1934 method_2920();

    @Shadow
    private void method_2911() {
    }

    @Inject(method={"setGameModes"}, at={@At(value="RETURN")})
    public void setGameModes(class_1934 gameMode, class_1934 previousGameMode, CallbackInfo ci) {
        IClientManagersProvider fortressClient = (IClientManagersProvider)this.field_3712;
        ISelectionManager selectionManager = fortressClient.get_SelectionManager();
        if (selectionManager.isSelecting()) {
            selectionManager.resetSelection();
        }
        if (gameMode == FORTRESS) {
            this.setFortressMode();
        } else {
            this.unsetFortressMode();
        }
    }

    @Inject(method={"setGameMode"}, at={@At(value="RETURN")})
    public void setGameMode(class_1934 gameMode, CallbackInfo ci) {
        if (gameMode == FORTRESS) {
            this.setFortressMode();
        } else {
            this.unsetFortressMode();
        }
    }

    @Inject(method={"attackBlock"}, at={@At(value="HEAD")}, cancellable=true)
    public void attackBlock(class_2338 pos, class_2350 direction, CallbackInfoReturnable<Boolean> cir) {
        if (!ModUtils.isClientInFortressGamemode()) {
            return;
        }
        IClientManagersProvider fortressClient = (IClientManagersProvider)this.field_3712;
        IClientBlueprintManager clientBlueprintManager = fortressClient.get_BlueprintManager();
        IClientFortressManager manager = fortressClient.get_ClientFortressManager();
        if (manager.getState() == FortressState.COMBAT) {
            IClientInfluenceManager influenceManager = ModUtils.getInfluenceManager();
            if (influenceManager.isSelecting()) {
                influenceManager.cancelSelectingInfluencePosition();
                cir.setReturnValue((Object)false);
                return;
            }
            IClientFightSelectionManager selectionManager = manager.getFightManager().getSelectionManager();
            class_312 mouse = this.field_3712.field_1729;
            if (selectionManager.isSelecting()) {
                selectionManager.endSelection();
            } else if (selectionManager.hasSelected()) {
                selectionManager.resetSelection();
            } else {
                class_239 crosshairTarget = this.field_3712.field_1765;
                if (crosshairTarget != null) {
                    selectionManager.startSelection(mouse.method_1603(), mouse.method_1604(), crosshairTarget.method_17784());
                }
            }
            cir.setReturnValue((Object)false);
            return;
        }
        if (manager.getState() == FortressState.AREAS_SELECTION) {
            IAreasClientManager areasClientManager = ModUtils.getAreasClientManager();
            areasClientManager.select(this.field_3712.field_1765);
            cir.setReturnValue((Object)false);
            return;
        }
        if (manager.isSelectingColonist()) {
            manager.stopSelectingColonist();
            cir.setReturnValue((Object)false);
            return;
        }
        if (manager.isCenterNotSet()) {
            cir.setReturnValue((Object)false);
            return;
        }
        if (clientBlueprintManager.isSelecting()) {
            clientBlueprintManager.clearStructure();
            cir.setReturnValue((Object)false);
            return;
        }
        if (manager.isBuildingHovered()) {
            FortressClientInteractionManagerMixin.openManageBuildingMenu(manager);
            cir.setReturnValue((Object)false);
            return;
        }
        fortressClient.get_SelectionManager().selectBlock(pos);
        cir.setReturnValue((Object)false);
    }

    @Unique
    private static void openManageBuildingMenu(IClientFortressManager fortressManager) {
        fortressManager.getHoveredBuilding().ifPresent(it -> {
            ManageBuildingScreen manageBuildingScreen = new ManageBuildingScreen((IEssentialBuildingInfo)it);
            class_310.method_1551().method_1507((class_437)manageBuildingScreen);
        });
    }

    @Inject(method={"updateBlockBreakingProgress"}, at={@At(value="HEAD")}, cancellable=true)
    public void updateBlockBreakingProgress(class_2338 pos, class_2350 direction, CallbackInfoReturnable<Boolean> cir) {
        if (ModUtils.isClientInFortressGamemode()) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"interactEntity"}, at={@At(value="HEAD")}, cancellable=true)
    public void interactEntity(class_1657 player, class_1297 entity, class_1268 hand, CallbackInfoReturnable<class_1269> cir) {
        if (this.method_2920() == FORTRESS) {
            IClientManagersProvider provider = (IClientManagersProvider)this.field_3712;
            IClientFortressManager manager = provider.get_ClientFortressManager();
            if (manager.getState() == FortressState.COMBAT) {
                IClientFightManager fightManager = manager.getFightManager();
                IClientFightSelectionManager selectionManager = fightManager.getSelectionManager();
                if (selectionManager.isSelecting()) {
                    selectionManager.resetSelection();
                }
                if (selectionManager.hasSelected()) {
                    fightManager.setTarget(entity);
                }
                cir.setReturnValue((Object)class_1269.field_5814);
                return;
            }
            if (entity instanceof class_1309) {
                cir.setReturnValue((Object)class_1269.field_5814);
            }
        }
    }

    @Inject(method={"interactBlock"}, at={@At(value="HEAD")}, cancellable=true)
    public void interactBlock(class_746 player, class_1268 hand, class_3965 hitResult, CallbackInfoReturnable<class_1269> cir) {
        if (!ModUtils.isClientInFortressGamemode()) {
            return;
        }
        this.method_2911();
        class_2338 blockPos = hitResult.method_17777();
        class_638 world = this.field_3712.field_1687;
        if (world != null && !world.method_8621().method_11952(blockPos)) {
            return;
        }
        IClientManagersProvider fortressClient = (IClientManagersProvider)this.field_3712;
        IClientBlueprintManager clientBlueprintManager = fortressClient.get_BlueprintManager();
        IClientFortressManager fortressManager = fortressClient.get_ClientFortressManager();
        if (fortressManager.getState() == FortressState.COMBAT) {
            IClientInfluenceManager influenceManager = ModUtils.getInfluenceManager();
            if (influenceManager.isSelecting()) {
                influenceManager.selectInfluencePosition();
                cir.setReturnValue((Object)class_1269.field_5812);
                return;
            }
            FortressClientInteractionManagerMixin.updateFightSelection(hitResult, fortressManager);
            cir.setReturnValue((Object)class_1269.field_5812);
            return;
        }
        if (fortressManager.getState() == FortressState.AREAS_SELECTION) {
            IAreasClientManager areasClientManager = ModUtils.getAreasClientManager();
            if (areasClientManager.isSelecting()) {
                areasClientManager.resetSelection();
            } else {
                areasClientManager.removeHovered();
            }
            cir.setReturnValue((Object)class_1269.field_5812);
            return;
        }
        if (fortressManager.isCenterNotSet()) {
            fortressManager.setupFortressCenter();
            cir.setReturnValue((Object)class_1269.field_5812);
            return;
        }
        if (clientBlueprintManager.isSelecting()) {
            clientBlueprintManager.buildCurrentStructure();
            cir.setReturnValue((Object)class_1269.field_5812);
            return;
        }
        if (fortressManager.isBuildingHovered()) {
            FortressClientInteractionManagerMixin.openManageBuildingMenu(fortressManager);
            cir.setReturnValue((Object)class_1269.field_5812);
            return;
        }
        class_1799 stackInHand = player.method_5998(hand);
        class_1792 item = stackInHand.method_7909();
        class_1838 useoncontext = new class_1838((class_1657)player, hand, hitResult);
        class_2680 blockStateFromItem = BlockUtils.getBlockStateFromItem(item);
        if (blockStateFromItem != null) {
            this.clickBuild(useoncontext, blockStateFromItem);
            cir.setReturnValue((Object)class_1269.field_5812);
            return;
        }
        ISelectionManager selectionManager = fortressClient.get_SelectionManager();
        if (selectionManager.isSelecting()) {
            selectionManager.selectBlock(blockPos, null);
            cir.setReturnValue((Object)class_1269.field_5812);
        }
        if (stackInHand.method_7960()) {
            cir.setReturnValue((Object)class_1269.field_5811);
        }
    }

    @Unique
    private static void updateFightSelection(class_3965 hitResult, IClientFortressManager fortressManager) {
        IClientFightManager fightManager = fortressManager.getFightManager();
        IClientFightSelectionManager selectionManager = fightManager.getSelectionManager();
        if (selectionManager.isSelecting()) {
            selectionManager.resetSelection();
        }
        if (selectionManager.hasSelected()) {
            fightManager.setTarget((class_239)hitResult);
        }
    }

    @Inject(method={"getReachDistance"}, at={@At(value="HEAD")}, cancellable=true)
    public void getReachDistance(CallbackInfoReturnable<Float> cir) {
        if (this.method_2920() == FORTRESS) {
            cir.setReturnValue((Object)Float.valueOf(120.0f));
        }
    }

    @Inject(method={"hasExtendedReach"}, at={@At(value="HEAD")}, cancellable=true)
    public void hasExtendedReach(CallbackInfoReturnable<Boolean> cir) {
        if (this.method_2920() == FORTRESS) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"isFlyingLocked"}, at={@At(value="HEAD")}, cancellable=true)
    public void isFlyingLocked(CallbackInfoReturnable<Boolean> cir) {
        if (this.method_2920() == FORTRESS) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"hasCreativeInventory"}, at={@At(value="HEAD")}, cancellable=true)
    public void hasCreativeInventory(CallbackInfoReturnable<Boolean> cir) {
        if (this.method_2920() == FORTRESS) {
            cir.setReturnValue((Object)true);
        }
    }

    @Unique
    private void clickBuild(class_1838 useOnContext, class_2680 blockState) {
        class_2338 blockPos = useOnContext.method_8037();
        if (!BuildingHelper.canPlaceBlock(useOnContext.method_8045(), blockPos)) {
            blockPos = blockPos.method_10093(useOnContext.method_8038());
        }
        ((IClientManagersProvider)this.field_3712).get_SelectionManager().selectBlock(blockPos, blockState);
    }

    @Unique
    private void setFortressMode() {
        this.field_3712.field_1729.method_1610();
        this.field_3712.field_1773.method_35768(false);
        class_1156 tutorialManager = this.field_3712.method_1577();
        tutorialManager.method_4910(class_1157.field_5653);
    }

    @Unique
    private void unsetFortressMode() {
        this.field_3712.field_1729.method_1612();
        this.field_3712.field_1773.method_35768(true);
    }
}

