/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.mixins.entity.player;

import com.mojang.authlib.GameProfile;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_5454;
import net.minecraft.server.MinecraftServer;
import net.remmintan.mods.minefortress.core.interfaces.blueprints.IServerBlueprintManager;
import net.remmintan.mods.minefortress.core.interfaces.entities.player.FortressServerPlayerEntity;
import org.jetbrains.annotations.Nullable;
import org.minefortress.MineFortressMod;
import org.minefortress.blueprints.manager.ServerBlueprintManager;
import org.minefortress.blueprints.world.BlueprintsWorld;
import org.minefortress.utils.FortressSpawnLocating;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3222.class})
public abstract class FortressServerPlayerEntityMixin
extends class_1657
implements FortressServerPlayerEntity {
    @Shadow
    @Final
    public MinecraftServer field_13995;
    @Shadow
    public class_3244 field_13987;
    private class_243 persistedPos;
    private class_243 persistedVelocity;
    private float persistedYaw;
    private float persistedPitch;
    private IServerBlueprintManager serverBlueprintManager;
    private boolean wasInBlueprintWorldWhenLoggedOut = false;

    public FortressServerPlayerEntityMixin(class_1937 world, class_2338 pos, float yaw, GameProfile profile) {
        super(world, pos, yaw, profile);
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    public void init(MinecraftServer server, class_3218 world, GameProfile profile, CallbackInfo ci) {
        this.serverBlueprintManager = new ServerBlueprintManager(server, () -> ((FortressServerPlayerEntityMixin)this).method_5667());
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void tick(CallbackInfo ci) {
        this.serverBlueprintManager.tick((class_3222)this);
    }

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="TAIL")})
    public void writeCustomDataToNbt(class_2487 nbt, CallbackInfo ci) {
        this.serverBlueprintManager.write();
        class_2487 playerState = new class_2487();
        playerState.method_10556("wasInBlueprintWorldWhenLoggedOut", this.wasInBlueprintWorldWhenLoggedOut);
        if (this.persistedPos != null) {
            playerState.method_10549("persistedPosX", this.persistedPos.field_1352);
            playerState.method_10549("persistedPosY", this.persistedPos.field_1351);
            playerState.method_10549("persistedPosZ", this.persistedPos.field_1350);
        }
        nbt.method_10566("playerState", (class_2520)playerState);
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="TAIL")})
    public void readCustomDataFromNbt(class_2487 nbt, CallbackInfo ci) {
        this.serverBlueprintManager.read(nbt);
        if (nbt.method_10545("playerState")) {
            class_2487 playerState = nbt.method_10562("playerState");
            this.wasInBlueprintWorldWhenLoggedOut = playerState.method_10577("wasInBlueprintWorldWhenLoggedOut");
            if (playerState.method_10545("persistedPosX")) {
                this.persistedPos = new class_243(playerState.method_10574("persistedPosX"), playerState.method_10574("persistedPosY"), playerState.method_10574("persistedPosZ"));
            }
        }
    }

    @Override
    public IServerBlueprintManager get_ServerBlueprintManager() {
        return this.serverBlueprintManager;
    }

    @Inject(method={"copyFrom"}, at={@At(value="TAIL")})
    public void copyFrom(class_3222 oldPlayer, boolean alive, CallbackInfo ci) {
        if (oldPlayer instanceof FortressServerPlayerEntity) {
            FortressServerPlayerEntity fortressServerPlayer = (FortressServerPlayerEntity)oldPlayer;
            this.serverBlueprintManager = fortressServerPlayer.get_ServerBlueprintManager();
        }
    }

    @Inject(method={"getTeleportTarget"}, at={@At(value="HEAD")}, cancellable=true)
    public void getTeleportTarget(class_3218 destination, CallbackInfoReturnable<class_5454> cir) {
        class_5454 teleportTarget;
        class_243 velocity;
        class_243 position;
        if (destination.method_27983() == BlueprintsWorld.BLUEPRINTS_WORLD_REGISTRY_KEY) {
            this.persistedPos = this.method_19538();
            this.persistedVelocity = this.method_18798();
            this.persistedPitch = this.method_36455();
            this.persistedYaw = this.method_36454();
            position = new class_243(-1.0, 17.0, -1.0);
            velocity = new class_243(0.0, 0.0, 0.0);
            teleportTarget = new class_5454(position, velocity, -45.0f, 0.0f);
            cir.setReturnValue((Object)teleportTarget);
        }
        if (this.method_37908().method_27983() == BlueprintsWorld.BLUEPRINTS_WORLD_REGISTRY_KEY && destination.method_27983() == class_1937.field_25179) {
            position = this.persistedPos;
            velocity = this.persistedVelocity;
            teleportTarget = new class_5454(position, velocity, this.persistedYaw, this.persistedPitch);
            cir.setReturnValue((Object)teleportTarget);
        }
    }

    @Redirect(method={"moveToSpawn"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/network/SpawnLocating;findOverworldSpawn(Lnet/minecraft/server/world/ServerWorld;II)Lnet/minecraft/util/math/BlockPos;"))
    public class_2338 moveToSpawnFindOverworldSpawn(class_3218 world, int x, int z) {
        class_2338 actualSpawn = FortressSpawnLocating.findOverworldSpawn(world, x, z);
        if (actualSpawn != null && this.field_13995.method_3790() == MineFortressMod.FORTRESS) {
            return actualSpawn.method_10086(20);
        }
        return actualSpawn;
    }

    @Inject(method={"moveToSpawn"}, at={@At(value="RETURN")})
    public void moveToSpawnAfter(class_3218 world, CallbackInfo ci) {
        this.method_36456(45.0f);
        this.method_36457(60.0f);
        class_2338 blockPos = this.method_24515();
        if (this.field_13987 != null) {
            this.method_20620(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260());
        }
    }

    @Override
    public boolean was_InBlueprintWorldWhenLoggedOut() {
        return this.wasInBlueprintWorldWhenLoggedOut;
    }

    @Override
    public void set_WasInBlueprintWorldWhenLoggedOut(boolean wasInBlueprintWorldWhenLoggedOut) {
        this.wasInBlueprintWorldWhenLoggedOut = wasInBlueprintWorldWhenLoggedOut;
    }

    @Override
    @Nullable
    public class_243 get_PersistedPos() {
        return this.persistedPos;
    }
}

