/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.mixins;

import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_1132;
import net.minecraft.class_1144;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_287;
import net.minecraft.class_310;
import net.minecraft.class_312;
import net.minecraft.class_315;
import net.minecraft.class_3965;
import net.minecraft.class_4093;
import net.minecraft.class_437;
import net.minecraft.class_490;
import net.minecraft.class_542;
import net.minecraft.class_636;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_750;
import net.remmintan.gobi.SelectionManager;
import net.remmintan.mods.minefortress.core.FortressState;
import net.remmintan.mods.minefortress.core.interfaces.blueprints.IBlockDataProvider;
import net.remmintan.mods.minefortress.core.interfaces.client.IClientFortressManager;
import net.remmintan.mods.minefortress.core.interfaces.client.IClientManagersProvider;
import net.remmintan.mods.minefortress.core.interfaces.selections.ISelectionInfoProvider;
import net.remmintan.mods.minefortress.core.interfaces.selections.ISelectionManager;
import net.remmintan.mods.minefortress.core.interfaces.selections.ISelectionModelBuilderInfoProvider;
import net.remmintan.mods.minefortress.core.interfaces.tasks.ITasksInformationHolder;
import net.remmintan.mods.minefortress.core.interfaces.tasks.ITasksModelBuilderInfoProvider;
import net.remmintan.mods.minefortress.core.interfaces.tasks.ITasksRenderInfoProvider;
import net.remmintan.mods.minefortress.core.utils.CoreModUtils;
import net.remmintan.panama.renderer.BlueprintRenderer;
import net.remmintan.panama.renderer.CampfireRenderer;
import net.remmintan.panama.renderer.FortressRenderLayer;
import net.remmintan.panama.renderer.SelectionRenderer;
import net.remmintan.panama.renderer.TasksRenderer;
import org.jetbrains.annotations.Nullable;
import org.minefortress.MineFortressMod;
import org.minefortress.blueprints.manager.ClientBlueprintManager;
import org.minefortress.blueprints.world.BlueprintsWorld;
import org.minefortress.fight.influence.ClientInfluenceManager;
import org.minefortress.fortress.ClientFortressManager;
import org.minefortress.fortress.automation.areas.AreasClientManager;
import org.minefortress.interfaces.IFortressMinecraftClient;
import org.minefortress.renderer.gui.blueprints.BlueprintsPauseScreen;
import org.minefortress.renderer.gui.hud.FortressHud;
import org.minefortress.utils.ModUtils;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_310.class})
public abstract class FortressMinecraftClientMixin
extends class_4093<Runnable>
implements IFortressMinecraftClient,
IClientManagersProvider {
    @Unique
    private ISelectionManager selectionManager;
    @Unique
    private FortressHud fortressHud;
    @Unique
    private ClientFortressManager clientFortressManager;
    @Unique
    private final class_750 blockBufferBuilderStorage = new class_750();
    @Unique
    private ClientBlueprintManager clientBlueprintManager;
    @Unique
    private ClientInfluenceManager influenceManager;
    @Unique
    private BlueprintRenderer blueprintRenderer;
    @Unique
    private CampfireRenderer campfireRenderer;
    @Unique
    private SelectionRenderer selectionRenderer;
    @Unique
    private TasksRenderer tasksRenderer;
    @Unique
    private AreasClientManager areasClientManager;
    @Shadow
    @Final
    public class_315 field_1690;
    @Shadow
    public class_636 field_1761;
    @Shadow
    @Final
    public class_312 field_1729;
    @Shadow
    @Nullable
    public class_746 field_1724;
    @Shadow
    @Nullable
    public class_638 field_1687;
    @Shadow
    @Nullable
    public class_239 field_1765;
    @Shadow
    @Nullable
    private class_1132 field_1766;
    @Shadow
    @Final
    private class_1144 field_1727;

    @Shadow
    @Nullable
    public abstract class_1132 method_1576();

    @Shadow
    public abstract boolean method_1496();

    @Shadow
    public abstract void method_1507(@Nullable class_437 var1);

    public FortressMinecraftClientMixin(String string) {
        super(string);
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    public void constructor(class_542 args, CallbackInfo ci) {
        class_310 client = (class_310)this;
        this.selectionManager = new SelectionManager(client);
        this.fortressHud = new FortressHud(client);
        this.clientFortressManager = new ClientFortressManager();
        this.areasClientManager = new AreasClientManager();
        this.clientBlueprintManager = new ClientBlueprintManager(client);
        this.influenceManager = new ClientInfluenceManager(client);
        this.blueprintRenderer = new BlueprintRenderer(this::getProperBlockDataProviderBasedOnState, client, this.blockBufferBuilderStorage);
        this.campfireRenderer = new CampfireRenderer(client, this.blockBufferBuilderStorage);
        Map<class_1921, class_287> selectionBufferBuilderStorage = Map.ofEntries(Map.entry(class_1921.method_23594(), new class_287(256)), Map.entry(FortressRenderLayer.getLinesNoDepth(), new class_287(256)));
        IClientManagersProvider provider = CoreModUtils.getMineFortressManagersProvider();
        IClientFortressManager manager = provider.get_ClientFortressManager();
        Supplier<ISelectionInfoProvider> selectInfProvSup = () -> manager.getState() == FortressState.BUILD ? ModUtils.getSelectionManager() : ModUtils.getAreasClientManager();
        Supplier<ISelectionModelBuilderInfoProvider> selModBuildInfProv = () -> manager.getState() == FortressState.BUILD ? ModUtils.getSelectionManager() : ModUtils.getAreasClientManager();
        this.selectionRenderer = new SelectionRenderer(client, selectionBufferBuilderStorage, this.blockBufferBuilderStorage, selectInfProvSup, selModBuildInfProv);
        Supplier<ITasksRenderInfoProvider> clientTasksHolderSupplier = () -> {
            if (this.clientFortressManager.getState() == FortressState.AREAS_SELECTION) {
                return this.areasClientManager.getSavedAreasHolder();
            }
            ITasksInformationHolder fortressWorld = (ITasksInformationHolder)this.field_1687;
            if (fortressWorld == null) {
                return null;
            }
            return fortressWorld.get_ClientTasksHolder();
        };
        Supplier<ITasksModelBuilderInfoProvider> clientBlueprintManagerSupplier = () -> {
            if (this.clientFortressManager.getState() == FortressState.AREAS_SELECTION) {
                return this.areasClientManager.getSavedAreasHolder();
            }
            ITasksInformationHolder fortressWorld = (ITasksInformationHolder)this.field_1687;
            if (fortressWorld == null) {
                return null;
            }
            return fortressWorld.get_ClientTasksHolder();
        };
        this.tasksRenderer = new TasksRenderer(client, selectionBufferBuilderStorage.get(class_1921.method_23594()), clientTasksHolderSupplier, clientBlueprintManagerSupplier);
    }

    @Override
    public ISelectionManager get_SelectionManager() {
        return this.selectionManager;
    }

    @Override
    public boolean is_FortressGamemode() {
        return this.field_1761 != null && this.field_1761.method_2920() == MineFortressMod.FORTRESS;
    }

    @Inject(method={"handleInputEvents"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/tutorial/TutorialManager;onInventoryOpened()V", shift=At.Shift.BEFORE)})
    private void handleInputEvents(CallbackInfo ci) {
        if (this.field_1761 != null && this.field_1761.method_2920() == MineFortressMod.FORTRESS && this.field_1690.field_1867.method_1434()) {
            if (this.get_BlueprintManager().isSelecting()) {
                this.get_BlueprintManager().rotateSelectedStructureClockwise();
            } else {
                this.get_SelectionManager().moveSelectionUp();
            }
        }
    }

    @Inject(method={"setScreen"}, at={@At(value="HEAD")}, cancellable=true)
    public void setScreenMix(class_437 screen, CallbackInfo ci) {
        if (this.is_FortressGamemode() && this.field_1690.field_1867.method_1434() && screen instanceof class_490) {
            ci.cancel();
        }
    }

    @Inject(method={"doItemPick"}, at={@At(value="HEAD")}, cancellable=true)
    public void doItemPick(CallbackInfo ci) {
        if (this.is_FortressGamemode()) {
            ci.cancel();
        }
    }

    @Override
    public FortressHud get_FortressHud() {
        return this.fortressHud;
    }

    @Override
    public ClientFortressManager get_ClientFortressManager() {
        return this.clientFortressManager;
    }

    @Override
    public class_2338 get_HoveredBlockPos() {
        class_239 hitResult = this.field_1765;
        if (hitResult instanceof class_3965) {
            return ((class_3965)hitResult).method_17777();
        }
        return null;
    }

    @Inject(method={"openPauseMenu"}, at={@At(value="HEAD")}, cancellable=true)
    public void openPauseMenu(boolean pause, CallbackInfo ci) {
        if (this.field_1687 != null && this.field_1687.method_27983() == BlueprintsWorld.BLUEPRINTS_WORLD_REGISTRY_KEY) {
            boolean localServer;
            boolean bl = localServer = this.method_1496() && (this.field_1766 == null || !this.field_1766.method_3860());
            if (localServer) {
                this.method_1507(new BlueprintsPauseScreen(!pause));
                this.field_1727.method_4879();
            } else {
                this.method_1507(new BlueprintsPauseScreen(true));
            }
            ci.cancel();
        }
    }

    @Override
    public BlueprintRenderer get_BlueprintRenderer() {
        return this.blueprintRenderer;
    }

    @Override
    public CampfireRenderer get_CampfireRenderer() {
        return this.campfireRenderer;
    }

    @Override
    public SelectionRenderer get_SelectionRenderer() {
        return this.selectionRenderer;
    }

    @Override
    public TasksRenderer get_TasksRenderer() {
        return this.tasksRenderer;
    }

    @Override
    public ClientBlueprintManager get_BlueprintManager() {
        return this.clientBlueprintManager;
    }

    @Override
    public AreasClientManager get_AreasClientManager() {
        return this.areasClientManager;
    }

    @Override
    public ClientInfluenceManager get_InfluenceManager() {
        return this.influenceManager;
    }

    @Inject(method={"close"}, at={@At(value="HEAD")})
    public void close(CallbackInfo ci) {
        this.blueprintRenderer.close();
        this.campfireRenderer.close();
        this.selectionRenderer.close();
    }

    @Unique
    private IBlockDataProvider getProperBlockDataProviderBasedOnState() {
        if (this.clientFortressManager.getState() == FortressState.COMBAT) {
            return this.get_InfluenceManager().getBlockDataProvider();
        }
        return this.get_BlueprintManager().getBlockDataProvider();
    }
}

