/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.fortress.server;

import com.mojang.authlib.GameProfile;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_4844;
import net.minecraft.server.MinecraftServer;
import net.remmintan.mods.minefortress.core.interfaces.server.IFortressModServerManager;
import net.remmintan.mods.minefortress.core.interfaces.server.IServerFortressManager;
import net.remmintan.mods.minefortress.core.interfaces.server.IServerManagersProvider;
import net.remmintan.mods.minefortress.core.utils.ModPathUtils;
import org.minefortress.fortress.ServerFortressManager;

public class FortressModServerManager
implements IFortressModServerManager {
    private static final String MANAGERS_FILE_NAME = "server-managers.nbt";
    private final MinecraftServer server;
    private final Map<UUID, ServerFortressManager> serverManagers = new HashMap<UUID, ServerFortressManager>();
    private boolean campfireEnabled;
    private boolean borderEnabled;

    public FortressModServerManager(MinecraftServer server) {
        this.server = server;
    }

    @Override
    public IServerManagersProvider getManagersProvider(class_3222 player) {
        return this.getByPlayer(player);
    }

    private ServerFortressManager getByPlayer(class_3222 player) {
        UUID playerId = class_4844.method_43343((GameProfile)player.method_7334());
        return this.serverManagers.computeIfAbsent(playerId, it -> new ServerFortressManager(this.server));
    }

    @Override
    public IServerManagersProvider getManagersProvider(UUID uuid) {
        return this.getByPlayer(uuid);
    }

    @Override
    public IServerFortressManager getFortressManager(class_3222 player) {
        return this.getByPlayer(player);
    }

    @Override
    public IServerFortressManager getFortressManager(UUID id) {
        return this.getByPlayer(id);
    }

    private ServerFortressManager getByPlayer(UUID uuid) {
        if (this.serverManagers.containsKey(uuid)) {
            return this.serverManagers.get(uuid);
        }
        throw new IllegalArgumentException("No server manager found for player with id " + uuid);
    }

    @Override
    public void tick(class_3324 playerManager) {
        for (Map.Entry<UUID, ServerFortressManager> entry : this.serverManagers.entrySet()) {
            UUID playerId = entry.getKey();
            ServerFortressManager manager = entry.getValue();
            class_3222 player = playerManager.method_14602(playerId);
            manager.tick(player);
        }
    }

    @Override
    public void save() {
        class_2487 nbt = new class_2487();
        for (Map.Entry<UUID, ServerFortressManager> entry : this.serverManagers.entrySet()) {
            class_2487 fortressNbt = new class_2487();
            UUID id = entry.getKey();
            ServerFortressManager manager = entry.getValue();
            manager.writeToNbt(fortressNbt);
            nbt.method_10566(id.toString(), (class_2520)fortressNbt);
        }
        nbt.method_10556("campfireEnabled", this.campfireEnabled);
        nbt.method_10556("borderEnabled", this.borderEnabled);
        ModPathUtils.saveNbt(nbt, MANAGERS_FILE_NAME, this.server.field_23784);
    }

    @Override
    public void load() {
        this.load(true, true);
    }

    @Override
    public void load(boolean campfireEnabled, boolean borderEnabled) {
        class_2487 nbtCompound = ModPathUtils.readNbt(MANAGERS_FILE_NAME, this.server.field_23784);
        boolean campfireEnabledSet = false;
        boolean borderEnabledSet = false;
        for (String key : nbtCompound.method_10541()) {
            if (key.equals("campfireEnabled")) {
                this.campfireEnabled = nbtCompound.method_10577(key);
                campfireEnabledSet = true;
                continue;
            }
            if (key.equals("borderEnabled")) {
                this.borderEnabled = nbtCompound.method_10577(key);
                borderEnabledSet = true;
                continue;
            }
            class_2487 managerNbt = nbtCompound.method_10562(key);
            UUID masterPlayerId = UUID.fromString(key);
            ServerFortressManager manager = new ServerFortressManager(this.server);
            manager.readFromNbt(managerNbt);
            this.serverManagers.put(masterPlayerId, manager);
        }
        if (!campfireEnabledSet) {
            this.campfireEnabled = campfireEnabled;
        }
        if (!borderEnabledSet) {
            this.borderEnabled = borderEnabled;
        }
    }

    @Override
    public Optional<IServerManagersProvider> findReachableFortress(class_2338 pos, double reachRange) {
        for (ServerFortressManager manager : this.serverManagers.values()) {
            double villageRadius;
            class_2338 fortressCenter = manager.getFortressCenter();
            if (fortressCenter == null || !fortressCenter.method_19771((class_2382)pos, (villageRadius = manager.getVillageRadius()) + reachRange)) continue;
            return Optional.of(manager);
        }
        return Optional.empty();
    }

    @Override
    public boolean isCampfireEnabled() {
        return this.campfireEnabled;
    }

    @Override
    public boolean isBorderEnabled() {
        return this.borderEnabled;
    }
}

