/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.fortress.resources.server;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import net.remmintan.mods.minefortress.core.interfaces.resources.IItemInfo;
import net.remmintan.mods.minefortress.core.interfaces.resources.IServerResourceManager;
import net.remmintan.mods.minefortress.networking.helpers.FortressServerNetworkHelper;
import net.remmintan.mods.minefortress.networking.s2c.ClientboundSyncItemsPacket;
import org.apache.logging.log4j.LogManager;
import org.minefortress.fortress.resources.ItemInfo;
import org.minefortress.fortress.resources.SimilarItemsHelper;
import org.minefortress.fortress.resources.client.FortressItemStack;
import org.minefortress.fortress.resources.server.EasyItemStack;
import org.minefortress.fortress.resources.server.ItemStacksManager;
import org.minefortress.fortress.resources.server.ServerStartingInventoryReader;

public class ServerResourceManager
implements IServerResourceManager {
    private final Synchronizer synchronizer = new Synchronizer();
    private final ItemStacksManager resources = new ItemStacksManager();
    private final Map<UUID, ItemStacksManager> reservedResources = new HashMap<UUID, ItemStacksManager>();

    public ServerResourceManager(MinecraftServer server) {
        ServerStartingInventoryReader reader = new ServerStartingInventoryReader(server);
        List<ServerStartingInventoryReader.InventorySlotInfo> inventoryStartingSlots = reader.readStartingSlots();
        for (ServerStartingInventoryReader.InventorySlotInfo slot : inventoryStartingSlots) {
            this.resources.getStack(slot.item()).increaseBy(slot.amount());
        }
    }

    @Override
    public IItemInfo createItemInfo(class_1792 item, int amount) {
        return new ItemInfo(item, amount);
    }

    @Override
    public void setItemAmount(class_1792 item, int amount) {
        EasyItemStack stack = this.resources.getStack(item);
        stack.setAmount(amount);
        this.synchronizer.syncItem(item, stack.getAmount());
    }

    @Override
    public void increaseItemAmount(class_1792 item, int amount) {
        EasyItemStack stack = this.resources.getStack(item);
        stack.increaseBy(amount);
        this.synchronizer.syncItem(item, stack.getAmount());
    }

    @Override
    public void reserveItems(UUID taskId, List<IItemInfo> infos) {
        if (!this.hasItems(infos)) {
            throw new IllegalStateException("Not enough resources");
        }
        ItemStacksManager reservedItemsManager = this.getManagerFromTaskId(taskId);
        ArrayList<ItemInfo> infosToSync = new ArrayList<ItemInfo>();
        block0: for (IItemInfo info : infos) {
            class_1792 item = info.item();
            int requiredAmount = info.amount();
            EasyItemStack stack = this.resources.getStack(item);
            EasyItemStack reservedStack = reservedItemsManager.getStack(item);
            int yetToFulfill = requiredAmount - stack.getAmount();
            if (yetToFulfill > 0) {
                int existingAmount = stack.getAmount();
                stack.decreaseBy(existingAmount);
                reservedStack.increaseBy(existingAmount);
            } else {
                stack.decreaseBy(requiredAmount);
                reservedStack.increaseBy(requiredAmount);
            }
            infosToSync.add(new ItemInfo(item, stack.getAmount()));
            if (yetToFulfill <= 0) continue;
            List<EasyItemStack> similarItems = this.resources.getNonEmptySimilarStacks(item);
            for (EasyItemStack similarStack : similarItems) {
                EasyItemStack newReservedStack = reservedItemsManager.getStack(similarStack.getItem());
                int similarStackAmount = similarStack.getAmount();
                if (similarStackAmount >= yetToFulfill) {
                    similarStack.decreaseBy(yetToFulfill);
                    newReservedStack.increaseBy(yetToFulfill);
                    yetToFulfill = 0;
                } else {
                    yetToFulfill -= similarStackAmount;
                    similarStack.decreaseBy(similarStackAmount);
                    newReservedStack.increaseBy(similarStackAmount);
                }
                infosToSync.add(new ItemInfo(similarStack.getItem(), similarStack.getAmount()));
                if (yetToFulfill != 0) continue;
                continue block0;
            }
        }
        this.synchronizer.syncAll(infosToSync);
    }

    @Override
    public void removeReservedItem(UUID taskId, class_1792 item) {
        boolean ignoreWhenNotEnough = false;
        this.removeReservedItem(taskId, item, ignoreWhenNotEnough);
    }

    private void removeReservedItem(UUID taskId, class_1792 item, boolean ignoreWhenNotEnough) {
        if (!(item instanceof class_1747)) {
            return;
        }
        ItemStacksManager reservedItemsManager = this.getManagerFromTaskId(taskId);
        EasyItemStack reservedStack = reservedItemsManager.getStack(item);
        if (reservedStack.getAmount() >= 1) {
            reservedStack.decrease();
        } else {
            List<EasyItemStack> nonEmptySimilarStacks = reservedItemsManager.getNonEmptySimilarStacks(item);
            if (!nonEmptySimilarStacks.isEmpty()) {
                EasyItemStack similarStack = nonEmptySimilarStacks.get(0);
                similarStack.decrease();
            } else if (!ignoreWhenNotEnough) {
                LogManager.getLogger().warn("Tried to remove reserved item, but not enough items: " + item.method_7848().method_10851());
            }
        }
    }

    @Override
    public void removeItemIfExists(UUID taskId, class_1792 item) {
        this.removeReservedItem(taskId, item, true);
    }

    @Override
    public void removeItems(List<IItemInfo> items) {
        for (IItemInfo itemInfo : items) {
            EasyItemStack stack = this.resources.getStack(itemInfo.item());
            if (stack.getAmount() <= 0) {
                return;
            }
            stack.decreaseBy(itemInfo.amount());
            this.synchronizer.syncItem(itemInfo.item(), stack.getAmount());
        }
    }

    @Override
    public void returnReservedItems(UUID taskId) {
        if (!this.reservedResources.containsKey(taskId)) {
            return;
        }
        ItemStacksManager manager = this.getManagerFromTaskId(taskId);
        ArrayList<ItemInfo> infosToSync = new ArrayList<ItemInfo>();
        for (ItemInfo info : manager.getAll()) {
            class_1792 item = info.item();
            EasyItemStack stack = this.resources.getStack(item);
            int amount = info.amount();
            stack.increaseBy(amount);
            ItemInfo infoToSync = new ItemInfo(item, stack.getAmount());
            infosToSync.add(infoToSync);
        }
        this.synchronizer.syncAll(infosToSync);
        this.reservedResources.remove(taskId);
    }

    @Override
    public void write(class_2487 tag) {
        class_2499 stacks = new class_2499();
        for (ItemInfo info : this.resources.getAll()) {
            class_1792 item = info.item();
            int amount = info.amount();
            class_2487 stack = new class_2487();
            int rawId = class_1792.method_7880((class_1792)item);
            stack.method_10569("id", rawId);
            stack.method_10569("amount", amount);
            stacks.add((Object)stack);
        }
        tag.method_10566("resources", (class_2520)stacks);
    }

    @Override
    public void read(class_2487 tag) {
        if (tag.method_10545("resources")) {
            this.resources.clear();
            class_2499 resourcesTags = tag.method_10554("resources", 10);
            int size = resourcesTags.size();
            for (int i = 0; i < size; ++i) {
                class_2487 resourceTag = resourcesTags.method_10602(i);
                int id = resourceTag.method_10550("id");
                int amount = resourceTag.method_10550("amount");
                class_1792 item = class_1792.method_7875((int)id);
                this.resources.getStack(item).increaseBy(amount);
            }
        }
    }

    @Override
    public void tick(class_3222 player) {
        this.synchronizer.sync(player);
    }

    @Override
    public List<class_1799> getAllItems() {
        return this.resources.getAll().stream().filter(info -> info.amount() > 0).map(it -> new FortressItemStack((class_1935)it.item(), it.amount())).toList();
    }

    @Override
    public boolean hasItems(List<IItemInfo> infos) {
        for (IItemInfo info : infos) {
            class_1792 item = info.item();
            if (item == class_1802.field_8884 || item == class_1802.field_8705 || item == class_1802.field_8187) continue;
            int amount = info.amount();
            EasyItemStack stack = this.resources.getStack(item);
            if (stack.hasEnough(amount)) continue;
            Integer sumAmountOfSimilarItems = this.resources.getNonEmptySimilarStacks(item).stream().map(EasyItemStack::getAmount).reduce(0, Integer::sum);
            HashSet<class_1792> similarItemsSet = new HashSet<class_1792>(SimilarItemsHelper.getSimilarItems(item));
            int requiredSimilarItems = infos.stream().filter(it -> similarItemsSet.contains(it.item())).mapToInt(IItemInfo::amount).sum();
            if (sumAmountOfSimilarItems - requiredSimilarItems + stack.getAmount() >= amount) continue;
            return false;
        }
        return true;
    }

    private ItemStacksManager getManagerFromTaskId(UUID taskId) {
        return this.reservedResources.computeIfAbsent(taskId, k -> new ItemStacksManager());
    }

    @Override
    public void syncAll() {
        this.synchronizer.reset();
        this.synchronizer.syncAll(this.resources.getAll());
    }

    private static class Synchronizer {
        private final List<IItemInfo> infosToSync = new ArrayList<IItemInfo>();
        private boolean needReset = false;

        private Synchronizer() {
        }

        void reset() {
            this.infosToSync.clear();
            this.needReset = true;
        }

        void sync(class_3222 player) {
            if (player == null || this.infosToSync.isEmpty() && !this.needReset) {
                return;
            }
            ClientboundSyncItemsPacket packet = new ClientboundSyncItemsPacket(this.infosToSync, this.needReset);
            FortressServerNetworkHelper.send(player, "fortress_resources_sync", packet);
            this.infosToSync.clear();
            this.needReset = false;
        }

        void syncItem(class_1792 item, int amount) {
            this.infosToSync.add(new ItemInfo(item, amount));
        }

        void syncAll(List<ItemInfo> items) {
            this.infosToSync.addAll(items);
        }
    }
}

