/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.fortress.resources.server;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_1792;
import org.minefortress.fortress.resources.ItemInfo;
import org.minefortress.fortress.resources.SimilarItemsHelper;
import org.minefortress.fortress.resources.server.EasyItemStack;

class ItemStacksManager {
    private final Map<class_1792, EasyItemStack> stacks = new HashMap<class_1792, EasyItemStack>();

    ItemStacksManager() {
    }

    public void clear() {
        this.stacks.clear();
    }

    public EasyItemStack getStack(class_1792 item) {
        return this.stacks.computeIfAbsent(item, EasyItemStack::new);
    }

    public List<EasyItemStack> getNonEmptySimilarStacks(class_1792 item) {
        return SimilarItemsHelper.getSimilarItems(item).stream().filter(this.stacks::containsKey).map(this.stacks::get).filter(it -> it.getAmount() > 0).toList();
    }

    public List<ItemInfo> getAll() {
        return this.stacks.entrySet().stream().map(e -> new ItemInfo((class_1792)e.getKey(), ((EasyItemStack)e.getValue()).getAmount())).collect(Collectors.toList());
    }
}

