/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.fortress.resources.gui.smelt;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1661;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_3876;
import net.minecraft.class_4185;
import net.minecraft.class_507;
import net.minecraft.class_757;
import net.remmintan.mods.minefortress.core.ScreenType;
import net.remmintan.mods.minefortress.core.interfaces.client.IClientFortressManager;
import net.remmintan.mods.minefortress.core.interfaces.client.IClientManagersProvider;
import net.remmintan.mods.minefortress.networking.c2s.ServerboundOpenCraftingScreenPacket;
import net.remmintan.mods.minefortress.networking.helpers.FortressClientNetworkHelper;
import org.minefortress.fortress.resources.gui.AbstractFortressRecipeScreen;
import org.minefortress.fortress.resources.gui.smelt.FortressFurnacePropertyDelegate;
import org.minefortress.fortress.resources.gui.smelt.FortressFurnaceScreenHandler;
import org.minefortress.interfaces.IFortressMinecraftClient;

public class FortressFurnaceScreen
extends AbstractFortressRecipeScreen<FortressFurnaceScreenHandler> {
    private static final class_2960 BACKGROUND_TEXTURE = new class_2960("textures/gui/container/furnace.png");
    private final class_3876 furnaceRecipeBookScreen = new class_3876();
    private final FortressFurnaceScreenHandler furnaceScreenHandler;
    private final List<AddedFurnace> addedFurnaces = new ArrayList<AddedFurnace>();

    public FortressFurnaceScreen(FortressFurnaceScreenHandler handler, class_1661 inventory, class_2561 title) {
        super(handler, inventory, title);
        this.furnaceScreenHandler = handler;
    }

    @Override
    public void method_37432() {
        super.method_37432();
        List<FortressFurnacePropertyDelegate> furnaces = this.furnaceScreenHandler.getFurnaces();
        while (this.addedFurnaces.size() < furnaces.size()) {
            int addedFurnaces = this.addedFurnaces.size();
            FortressFurnacePropertyDelegate otherFurnace = furnaces.get(addedFurnaces);
            int width = 100;
            class_4185.class_4241 action = buttonWidget -> {
                int posX = otherFurnace.getPosX();
                int posY = otherFurnace.getPosY();
                int posZ = otherFurnace.getPosZ();
                ServerboundOpenCraftingScreenPacket packet = new ServerboundOpenCraftingScreenPacket(ScreenType.FURNACE, new class_2338(posX, posY, posZ));
                if (this.field_22787 != null) {
                    this.method_25419();
                }
                FortressClientNetworkHelper.send("fortress_open_crafting_table", packet);
            };
            class_4185 btn = class_4185.method_46430((class_2561)class_2561.method_43470((String)("Fur. " + addedFurnaces)), (class_4185.class_4241)action).method_46434(this.field_22789 - 5 - 100, 5 + addedFurnaces * 25, 100, 20).method_46431();
            this.method_37063((class_364)btn);
            this.addedFurnaces.add(new AddedFurnace(otherFurnace, btn));
        }
        for (AddedFurnace addedFurnace : this.addedFurnaces) {
            FortressFurnacePropertyDelegate furnace = addedFurnace.furnace;
            class_4185 btn = addedFurnace.button;
            String selectedLabel = furnace.isSelected() ? "*" : "";
            boolean isBurning = furnace.getBurnTime() > 0;
            String burningLabel = isBurning ? furnace.getCookProgress() + "%" : "not burning";
            btn.method_25355((class_2561)class_2561.method_43470((String)("Fur." + selectedLabel + ": " + burningLabel)));
        }
    }

    @Override
    public class_507 method_2659() {
        return this.furnaceRecipeBookScreen;
    }

    @Override
    protected boolean professionRequirementSatisfied() {
        IClientManagersProvider provider = this.getManagerProvider();
        IClientFortressManager clientManager = provider.get_ClientFortressManager();
        return this.getFortressClient().is_FortressGamemode() && clientManager.getProfessionManager().hasProfession("blacksmith");
    }

    private IClientManagersProvider getManagerProvider() {
        return (IClientManagersProvider)class_310.method_1551();
    }

    private IFortressMinecraftClient getFortressClient() {
        return (IFortressMinecraftClient)class_310.method_1551();
    }

    protected void method_2389(class_332 drawContext, float delta, int mouseX, int mouseY) {
        int k;
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)BACKGROUND_TEXTURE);
        int i = this.field_2776;
        int j = this.field_2800;
        drawContext.method_25302(BACKGROUND_TEXTURE, i, j, 0, 0, this.field_2792, this.field_2779);
        if (((FortressFurnaceScreenHandler)this.field_2797).isBurning()) {
            k = ((FortressFurnaceScreenHandler)this.field_2797).getFuelProgress();
            drawContext.method_25302(BACKGROUND_TEXTURE, i + 56, j + 36 + 12 - k, 176, 12 - k, 14, k + 1);
        }
        k = ((FortressFurnaceScreenHandler)this.field_2797).getCookProgress();
        drawContext.method_25302(BACKGROUND_TEXTURE, i + 79, j + 34, 176, 14, k + 1, 16);
    }

    private record AddedFurnace(FortressFurnacePropertyDelegate furnace, class_4185 button) {
    }
}

