/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.fortress.resources.gui;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.class_1277;
import net.minecraft.class_1662;
import net.minecraft.class_1715;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_2596;
import net.minecraft.class_2695;
import net.minecraft.class_2952;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;
import org.minefortress.fortress.resources.gui.AbstractFortressRecipeScreenHandler;
import org.minefortress.interfaces.FortressSimpleInventory;

public final class FortressInputSlotFiller
implements class_2952<Integer> {
    private final class_1662 matcher = new class_1662();
    private class_1277 inventory;
    private final AbstractFortressRecipeScreenHandler handler;

    public FortressInputSlotFiller(AbstractFortressRecipeScreenHandler handler) {
        this.handler = handler;
    }

    public void fillInputSlots(class_3222 entity, @Nullable class_1860<class_1715> recipe, boolean craftAll) {
        if (recipe == null) {
            return;
        }
        this.inventory = this.handler.getScreenInventory();
        if (!this.canReturnInputs() && !entity.method_7337()) {
            return;
        }
        this.matcher.method_7409();
        ((FortressSimpleInventory)this.handler.getScreenInventory()).populate_RecipeFinder(this.matcher);
        this.handler.method_7654(this.matcher);
        if (this.matcher.method_7402(recipe, null)) {
            this.fillInputSlots(recipe, craftAll);
        } else {
            this.returnInputs();
            entity.field_13987.method_14364((class_2596)new class_2695(entity.field_7512.field_7763, recipe));
        }
        this.handler.getScreenInventory().method_5431();
    }

    public void returnInputs() {
        if (this.inventory == null) {
            this.inventory = this.handler.getScreenInventory();
        }
        for (int i = 0; i < this.handler.method_7658(); ++i) {
            if (!this.handler.method_32339(i)) continue;
            class_1799 itemStack = this.handler.method_7611(i).method_7677().method_7972();
            this.inventory.method_5491(itemStack);
            AbstractFortressRecipeScreenHandler.VirtualInventory virtualInventory = this.handler.getVirtualInventory();
            if (!virtualInventory.hasItem(itemStack.method_7909())) {
                virtualInventory.addItem(itemStack);
            }
            this.handler.method_7611(i).method_7673(itemStack);
        }
        this.handler.method_7657();
    }

    private void fillInputSlots(class_1860<class_1715> recipe, boolean craftAll) {
        IntArrayList itemStack;
        int j;
        boolean bl = this.handler.method_7652(recipe);
        int i = this.matcher.method_7407(recipe, null);
        if (bl) {
            for (j = 0; j < this.handler.method_7656() * this.handler.method_7653() + 1; ++j) {
                if (j == this.handler.method_7655() || (itemStack = this.handler.method_7611(j).method_7677()).method_7960() || Math.min(i, ((class_1799)itemStack).method_7914()) >= ((class_1799)itemStack).method_7947() + 1) continue;
                return;
            }
        }
        if (this.matcher.method_7406(recipe, (IntList)(itemStack = new IntArrayList()), j = this.getAmountToFill(craftAll, i, bl))) {
            int k = j;
            IntListIterator intListIterator = ((IntList)itemStack).iterator();
            while (intListIterator.hasNext()) {
                int l = (Integer)intListIterator.next();
                int m = class_1662.method_7405((int)l).method_7914();
                if (m >= k) continue;
                k = m;
            }
            j = k;
            if (this.matcher.method_7406(recipe, (IntList)itemStack, j)) {
                this.returnInputs();
                this.method_12816(this.handler.method_7653(), this.handler.method_7656(), this.handler.method_7655(), recipe, (Iterator)((IntList)itemStack).iterator(), j);
            }
        }
    }

    public void method_12815(Iterator<Integer> inputs, int slot, int amount, int gridX, int gridY) {
        class_1735 slot2 = this.handler.method_7611(slot);
        class_1799 itemStack = class_1662.method_7405((int)inputs.next());
        if (!itemStack.method_7960()) {
            for (int i = 0; i < amount; ++i) {
                this.fillInputSlot(slot2, itemStack);
            }
        }
    }

    private int getAmountToFill(boolean craftAll, int limit, boolean recipeInCraftingSlots) {
        int i = 1;
        if (craftAll) {
            i = limit;
        } else if (recipeInCraftingSlots) {
            i = 64;
            for (int j = 0; j < this.handler.method_7653() * this.handler.method_7656() + 1; ++j) {
                class_1799 itemStack;
                if (j == this.handler.method_7655() || (itemStack = this.handler.method_7611(j).method_7677()).method_7960() || i <= itemStack.method_7947()) continue;
                i = itemStack.method_7947();
            }
            if (i < 64) {
                ++i;
            }
        }
        return i;
    }

    private void fillInputSlot(class_1735 slot, class_1799 stack) {
        int i = ((FortressSimpleInventory)this.inventory).index_Of(stack);
        if (i == -1) {
            return;
        }
        class_1799 itemStack = this.inventory.method_5438(i).method_7972();
        if (itemStack.method_7960()) {
            return;
        }
        if (itemStack.method_7947() > 1) {
            this.inventory.method_5434(i, 1);
        } else {
            this.inventory.method_5441(i);
            AbstractFortressRecipeScreenHandler.VirtualInventory virtualInventory = this.handler.getVirtualInventory();
            if (virtualInventory != null) {
                virtualInventory.set(i, class_1799.field_8037);
            }
        }
        itemStack.method_7939(1);
        if (slot.method_7677().method_7960()) {
            slot.method_7673(itemStack);
        } else {
            slot.method_7677().method_7933(1);
        }
    }

    private boolean canReturnInputs() {
        ArrayList list = Lists.newArrayList();
        int i = this.getFreeInventorySlots();
        for (int j = 0; j < this.handler.method_7653() * this.handler.method_7656() + 1; ++j) {
            class_1799 itemStack;
            if (j == this.handler.method_7655() || (itemStack = this.handler.method_7611(j).method_7677().method_7972()).method_7960()) continue;
            int k = ((FortressSimpleInventory)this.inventory).get_OccupiedSlotWithRoomForStack(itemStack);
            if (k == -1 && list.size() <= i) {
                for (class_1799 itemStack2 : list) {
                    if (!class_1799.method_7973((class_1799)itemStack2, (class_1799)itemStack) || itemStack2.method_7947() == itemStack2.method_7914() || itemStack2.method_7947() + itemStack.method_7947() > itemStack2.method_7914()) continue;
                    itemStack2.method_7933(itemStack.method_7947());
                    itemStack.method_7939(0);
                    break;
                }
                if (itemStack.method_7960()) continue;
                if (list.size() < i) {
                    list.add(itemStack);
                    continue;
                }
                return false;
            }
            if (k != -1) continue;
            return false;
        }
        return true;
    }

    private int getFreeInventorySlots() {
        int i = 0;
        for (class_1799 itemStack : ((FortressSimpleInventory)this.inventory).get_Stacks()) {
            if (!itemStack.method_7960()) continue;
            ++i;
        }
        return i;
    }
}

