/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.fortress.resources.gui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1729;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.server.MinecraftServer;
import net.remmintan.mods.minefortress.core.interfaces.resources.IScrollableHandler;
import net.remmintan.mods.minefortress.core.interfaces.resources.IServerResourceManager;
import net.remmintan.mods.minefortress.core.interfaces.server.IFortressServer;
import net.remmintan.mods.minefortress.core.interfaces.server.IServerManagersProvider;
import net.remmintan.mods.minefortress.networking.c2s.ServerboundScrollCurrentScreenPacket;
import net.remmintan.mods.minefortress.networking.helpers.FortressClientNetworkHelper;
import org.minefortress.fortress.resources.ItemInfo;
import org.minefortress.fortress.resources.client.FortressItemStack;
import org.minefortress.fortress.resources.gui.FortressInputSlotFiller;
import org.minefortress.interfaces.FortressSimpleInventory;

public abstract class AbstractFortressRecipeScreenHandler<T extends class_1263>
extends class_1729<T>
implements IScrollableHandler {
    private final class_1277 screenInventory = new class_1277(999);
    private final VirtualInventory virtualInventory;
    private final IServerResourceManager IServerResourceManager;
    private int clientCurrentRow = 5;
    protected final class_1657 player;
    protected final class_1937 world;

    public AbstractFortressRecipeScreenHandler(class_3917<?> screenHandlerType, int i, IServerResourceManager resourceManager, class_1657 player) {
        super(screenHandlerType, i);
        this.IServerResourceManager = resourceManager;
        this.player = player;
        this.world = player.method_37908();
        this.virtualInventory = Objects.nonNull(this.IServerResourceManager) ? new VirtualInventory(this.IServerResourceManager.getAllItems()) : null;
    }

    public int getRowsCount() {
        int rowsCount = (this.virtualInventory != null ? this.virtualInventory.size() : this.field_7761.size()) / 9;
        return rowsCount + (this.virtualInventory != null && this.virtualInventory.full() ? 1 : 0);
    }

    public void method_7619(int slot, int revision, class_1799 stack) {
        while (this.field_7761.size() <= slot) {
            for (int column = 0; column < 9; ++column) {
                this.method_7621(new FortressNotInsertableSlot((class_1263)this.screenInventory, column + this.clientCurrentRow * 9, 8 + column * 18, 80 + this.clientCurrentRow * 18));
            }
            ++this.clientCurrentRow;
        }
        super.method_7619(slot, revision, stack);
    }

    public void method_7610(int revision, List<class_1799> stacks, class_1799 cursorStack) {
        while (this.field_7761.size() < stacks.size()) {
            for (int column = 0; column < 9; ++column) {
                this.method_7621(new FortressNotInsertableSlot((class_1263)this.screenInventory, column + this.clientCurrentRow * 9, 8 + column * 18, 80 + this.clientCurrentRow * 18));
            }
            ++this.clientCurrentRow;
        }
        super.method_7610(revision, stacks, cursorStack);
    }

    public boolean method_32339(int index) {
        return index != this.method_7655();
    }

    protected void createDefaultsScrollableSlots() {
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.method_7621(new FortressNotInsertableSlot((class_1263)this.screenInventory, column + row * 9, 8 + column * 18, 84 + row * 18));
            }
        }
        for (int column = 0; column < 9; ++column) {
            this.method_7621(new FortressNotInsertableSlot((class_1263)this.screenInventory, column + 27, 8 + column * 18, 142));
        }
        if (this.IServerResourceManager != null) {
            int rowsCount = this.getRowsCount();
            if (rowsCount > 4) {
                for (int row = 0; row < rowsCount - 4; ++row) {
                    for (int column = 0; column < 9; ++column) {
                        this.method_7621(new FortressNotInsertableSlot((class_1263)this.screenInventory, column + (row + 4) * 9, 8 + column * 18, 150 + row * 18));
                    }
                }
            }
            this.scrollItems(0.0f);
        }
    }

    public boolean method_7597(class_1657 player) {
        return true;
    }

    public class_1799 method_7601(class_1657 player, int index) {
        class_1799 itemStack = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(index);
        if (slot.method_7681()) {
            class_1799 stack = slot.method_7677();
            FortressItemStack itemStack2 = new FortressItemStack((class_1935)stack.method_7909(), stack.method_7947());
            itemStack = itemStack2.method_7972();
            if (index == 0) {
                if (!this.method_7616(itemStack2, 10, this.field_7761.size(), false)) {
                    return class_1799.field_8037;
                }
                slot.method_7670((class_1799)itemStack2, itemStack);
            } else if (index >= 10 && index < 46 ? !this.method_7616(itemStack2, 1, 10, false) && (index < 37 ? !this.method_7616(itemStack2, 37, 46, false) : !this.method_7616(itemStack2, 10, 37, false)) : !this.method_7616(itemStack2, 10, 46, false)) {
                return class_1799.field_8037;
            }
            if (itemStack2.method_7960()) {
                slot.method_7673(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
            if (itemStack2.method_7947() == itemStack.method_7947()) {
                return class_1799.field_8037;
            }
            slot.method_7667(player, (class_1799)itemStack2);
            if (index == 0) {
                player.method_7328((class_1799)itemStack2, false);
            }
        }
        return itemStack;
    }

    public class_1277 getScreenInventory() {
        return this.screenInventory;
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            MinecraftServer minecraftServer = serverPlayer.field_13995;
            if (minecraftServer instanceof IFortressServer) {
                IFortressServer IFortressServer2 = (IFortressServer)minecraftServer;
                IServerManagersProvider fortressServerManager = IFortressServer2.get_FortressModServerManager().getManagersProvider(serverPlayer);
                IServerResourceManager serverResourceManager = fortressServerManager.getResourceManager();
                this.returnInputs();
                InventoryDiff diff = this.virtualInventory.getDiff();
                diff.added.forEach(stack -> serverResourceManager.increaseItemAmount(stack.item(), stack.amount()));
                diff.updated.forEach(stack -> serverResourceManager.increaseItemAmount(stack.item(), stack.amount()));
                diff.removed.forEach(stack -> serverResourceManager.increaseItemAmount(stack.item(), -stack.amount()));
            }
        }
    }

    protected void returnInputs() {
        new FortressInputSlotFiller(this).returnInputs();
    }

    public void method_17697(boolean craftAll, class_1860<?> recipe, class_3222 player) {
        new FortressInputSlotFiller(this).fillInputSlots(player, recipe, craftAll);
    }

    protected abstract T getInput();

    @Override
    public void scrollItems(float position) {
        if (this.IServerResourceManager == null) {
            ServerboundScrollCurrentScreenPacket packet = new ServerboundScrollCurrentScreenPacket(position);
            FortressClientNetworkHelper.send("scroll_current_screen", packet);
            return;
        }
        int totalRows = this.getRowsCount();
        int totalAdditionalRows = totalRows - 4;
        int rowOffset = (int)((double)(position * (float)totalAdditionalRows) + 0.5);
        if (rowOffset < 0) {
            rowOffset = 0;
        }
        for (int row = 0; row < totalRows; ++row) {
            for (int column = 0; column < 9; ++column) {
                int m;
                int currentRow = row + rowOffset;
                if (currentRow >= totalRows) {
                    currentRow -= totalRows;
                }
                if ((m = column + currentRow * 9) >= 0 && m < this.virtualInventory.size()) {
                    this.screenInventory.method_5447(column + row * 9, this.virtualInventory.get(m));
                    continue;
                }
                this.screenInventory.method_5447(column + row * 9, class_1799.field_8037);
            }
        }
        this.virtualInventory.setRowsOffset(rowOffset);
    }

    public VirtualInventory getVirtualInventory() {
        return this.virtualInventory;
    }

    public boolean method_7652(class_1860<? super T> recipe) {
        return recipe.method_8115(this.getInput(), this.world);
    }

    protected final class VirtualInventory {
        private final Map<class_1792, Integer> itemsBefore;
        private final List<class_1799> items;
        private int rowsOffset = 0;

        VirtualInventory(List<class_1799> items) {
            this.items = new ArrayList<class_1799>(items.stream().filter(it -> !it.method_7960()).toList());
            this.itemsBefore = this.items.stream().collect(Collectors.collectingAndThen(Collectors.toMap(class_1799::method_7909, class_1799::method_7947), Collections::unmodifiableMap));
        }

        boolean full() {
            return this.items.stream().noneMatch(class_1799::method_7960);
        }

        class_1799 get(int index) {
            return this.items.get(index);
        }

        boolean hasItem(class_1792 item) {
            return this.items.stream().anyMatch(it -> it.method_7909().equals(item));
        }

        void addItem(class_1799 itemStack) {
            for (int i = 0; i < this.items.size(); ++i) {
                if (!this.items.get(i).method_7960()) continue;
                this.items.set(i, itemStack);
                return;
            }
        }

        void set(int index, class_1799 stack) {
            int insertIndex;
            class_2371 slots = AbstractFortressRecipeScreenHandler.this.field_7761;
            int storageSlotsCount = slots.size() - AbstractFortressRecipeScreenHandler.this.method_7658();
            while (storageSlotsCount > this.items.size()) {
                this.items.add(class_1799.field_8037);
            }
            int realIndex = index + this.rowsOffset * 9;
            int itemsCount = this.items.size();
            int n = insertIndex = realIndex < itemsCount ? realIndex : realIndex - itemsCount;
            if (!(this.items.get(insertIndex).method_7960() || stack.method_7960() || this.items.get(insertIndex).equals(stack))) {
                throw new IllegalStateException();
            }
            this.items.set(insertIndex, stack);
        }

        void setRowsOffset(int rowsOffset) {
            this.rowsOffset = rowsOffset;
        }

        int size() {
            return this.items.size();
        }

        InventoryDiff getDiff() {
            Set itemsAfter = this.items.stream().filter(it -> !it.method_7960()).map(class_1799::method_7909).collect(Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet));
            List<ItemInfo> itemsToRemove = this.itemsBefore.entrySet().stream().filter(it -> !itemsAfter.contains(it.getKey())).map(it -> new ItemInfo((class_1792)it.getKey(), (Integer)it.getValue())).toList();
            List<ItemInfo> itemsToAdd = this.items.stream().filter(it -> !it.method_7960()).filter(it -> !this.itemsBefore.containsKey(it.method_7909())).map(it -> new ItemInfo(it.method_7909(), it.method_7947())).toList();
            List<ItemInfo> itemsToUpdate = this.items.stream().filter(it -> !it.method_7960()).filter(it -> this.itemsBefore.containsKey(it.method_7909())).map(it -> new ItemInfo(it.method_7909(), it.method_7947() - this.itemsBefore.get(it.method_7909()))).toList();
            return new InventoryDiff(itemsToAdd, itemsToUpdate, itemsToRemove);
        }
    }

    protected final class FortressNotInsertableSlot
    extends FortressSlot {
        public FortressNotInsertableSlot(class_1263 inventory, int index, int x, int y) {
            super(inventory, index, x, y);
        }

        public void method_7673(class_1799 stack) {
            AbstractFortressRecipeScreenHandler handler = AbstractFortressRecipeScreenHandler.this;
            if (handler.virtualInventory != null) {
                handler.virtualInventory.set(this.method_34266(), stack);
            }
            super.method_7673(stack);
        }

        public class_1799 method_7677() {
            return super.method_7677();
        }

        public boolean method_7680(class_1799 stack) {
            return this.method_7677().method_7960() || class_1799.method_31577((class_1799)this.method_7677(), (class_1799)stack);
        }

        public class_1799 method_32755(class_1799 stack, int count) {
            if (stack.method_7960() || !this.method_7680(stack)) {
                return stack;
            }
            class_1799 itemStack = this.method_7677();
            if (itemStack.method_7960()) {
                class_1263 class_12632 = this.field_7871;
                if (class_12632 instanceof FortressSimpleInventory) {
                    FortressSimpleInventory fortressSimpleInventory = (FortressSimpleInventory)class_12632;
                    int i = fortressSimpleInventory.index_Of(stack);
                    if (i != -1) {
                        this.field_7871.method_5438(i).method_7933(count);
                        stack.method_7934(count);
                    } else {
                        class_1799 split = stack.method_7971(count);
                        this.method_7673(split);
                    }
                }
            } else if (class_1799.method_31577((class_1799)itemStack, (class_1799)stack)) {
                itemStack.method_7933(count);
                this.method_7673(itemStack);
                stack.method_7934(count);
            }
            return stack;
        }
    }

    protected record InventoryDiff(List<ItemInfo> added, List<ItemInfo> updated, List<ItemInfo> removed) {
    }

    protected static class FortressSlot
    extends class_1735 {
        public FortressSlot(class_1263 inventory, int index, int x, int y) {
            super(inventory, index, x, y);
        }

        public int method_7676(class_1799 stack) {
            return Integer.MAX_VALUE;
        }

        public int method_7675() {
            return Integer.MAX_VALUE;
        }
    }
}

