/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.fortress.resources.client;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_634;
import net.minecraft.class_638;
import net.minecraft.class_7225;
import net.minecraft.class_7699;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import org.minefortress.fortress.resources.client.ClientItemStacksManager;
import org.minefortress.fortress.resources.client.FortressItemStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StackGroupsManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(StackGroupsManager.class);
    private final Map<class_1761, ClientItemStacksManager> groups = new HashMap<class_1761, ClientItemStacksManager>();

    StackGroupsManager() {
    }

    ClientItemStacksManager getStacksManager(class_1761 group) {
        return this.groups.computeIfAbsent(group, g -> new ClientItemStacksManager());
    }

    void clear() {
        this.groups.clear();
    }

    Set<class_1761> getGroups() {
        return this.groups.entrySet().stream().filter(e -> !((ClientItemStacksManager)e.getValue()).isEmpty()).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    List<class_1799> getStacksFromGroup(class_1761 group) {
        return this.getStacksManager(group).getStacks();
    }

    class_1761 getGroup(class_1792 item) {
        StackGroupsManager.tryInitGroups();
        for (class_1761 group : class_7706.method_47341()) {
            if (group == class_7923.field_44687.method_29107(class_7706.field_40200) || !group.method_45412(item.method_7854())) continue;
            return group;
        }
        throw new IllegalArgumentException("Item " + item + " is not in any group");
    }

    private static void tryInitGroups() {
        if (!StackGroupsManager.itemGroupsInitialized()) {
            class_310 client = class_310.method_1551();
            class_634 handler = client.method_1562();
            class_638 world = client.field_1687;
            if (handler != null && world != null) {
                class_7706.method_47330((class_7699)handler.method_45735(), (boolean)false, (class_7225.class_7874)world.method_30349());
            } else {
                LOGGER.warn("Item groups are not initialized");
            }
        }
    }

    private static boolean itemGroupsInitialized() {
        List nativeGroups = class_7706.method_47341();
        return !nativeGroups.isEmpty() && !((class_1761)nativeGroups.get(0)).method_45414().isEmpty();
    }

    List<FortressItemStack> getNonEmptySimilarStacks(class_1792 item) {
        return this.groups.values().stream().flatMap(it -> it.getNonEmptySimilarStacks(item).stream()).toList();
    }
}

