/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.fortress.resources.client;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.remmintan.mods.minefortress.core.interfaces.resources.IClientResourceManager;
import net.remmintan.mods.minefortress.core.interfaces.resources.IItemInfo;
import org.minefortress.fortress.resources.ItemInfo;
import org.minefortress.fortress.resources.SimilarItemsHelper;
import org.minefortress.fortress.resources.client.ClientItemStacksManager;
import org.minefortress.fortress.resources.client.FortressItemStack;
import org.minefortress.fortress.resources.client.StackGroupsManager;
import org.minefortress.utils.ModUtils;

public class ClientResourceManagerImpl
implements IClientResourceManager {
    private final StackGroupsManager groupManager = new StackGroupsManager();

    @Override
    public Set<class_1761> getGroups() {
        return this.groupManager.getGroups();
    }

    @Override
    public boolean hasStacks(List<class_1799> stacks) {
        List<IItemInfo> itemInfos = stacks.stream().map(it -> new ItemInfo(it.method_7909(), it.method_7947())).map(IItemInfo.class::cast).toList();
        return this.hasItems(itemInfos);
    }

    @Override
    public boolean hasItems(List<IItemInfo> stacks) {
        if (ModUtils.getFortressClientManager().isCreative()) {
            return true;
        }
        return stacks.stream().allMatch(it -> {
            class_1792 item = it.item();
            int amount = it.amount();
            return this.hasItem(item, amount, stacks);
        });
    }

    @Override
    public boolean hasItem(IItemInfo itemInfo, List<IItemInfo> items) {
        class_1792 item = itemInfo.item();
        int amount = itemInfo.amount();
        return this.hasItem(item, amount, items);
    }

    private boolean hasItem(class_1792 item, int amount, List<IItemInfo> items) {
        class_1761 group = this.groupManager.getGroup(item);
        ClientItemStacksManager manager = this.groupManager.getStacksManager(group);
        FortressItemStack stack = manager.getStack(item);
        if (stack == null) {
            return false;
        }
        int availableAmount = stack.method_7947();
        if (availableAmount >= amount) {
            return true;
        }
        Integer amountOfNonEmptySimilarElements = this.groupManager.getNonEmptySimilarStacks(item).stream().map(class_1799::method_7947).reduce(0, Integer::sum);
        HashSet<class_1792> similarItemsSet = new HashSet<class_1792>(SimilarItemsHelper.getSimilarItems(item));
        int requiredSimilarItems = items.stream().filter(it -> similarItemsSet.contains(it.item())).mapToInt(IItemInfo::amount).sum();
        return amountOfNonEmptySimilarElements - requiredSimilarItems + availableAmount >= amount;
    }

    @Override
    public List<class_1799> getStacks(class_1761 group) {
        return this.groupManager.getStacksFromGroup(group);
    }

    @Override
    public void setItemAmount(class_1792 item, int amount) {
        class_1761 group = this.groupManager.getGroup(item);
        ClientItemStacksManager manager = this.groupManager.getStacksManager(group);
        manager.getStack(item).method_7939(amount);
    }

    @Override
    public int getItemAmount(class_1792 item) {
        if (ModUtils.getFortressClientManager().isCreative()) {
            return 999;
        }
        class_1761 group = this.groupManager.getGroup(item);
        ClientItemStacksManager manager = this.groupManager.getStacksManager(group);
        return manager.getStack(item).method_7947();
    }

    @Override
    public void reset() {
        this.groupManager.clear();
    }
}

