/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.fortress.resources;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_3489;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.minefortress.blueprints.data.StructureBlockData;

public class SimilarItemsHelper {
    private static final List<class_1792> strippedLogs = Arrays.asList(class_1802.field_8072, class_1802.field_8767, class_1802.field_8808, class_1802.field_8334, class_1802.field_8415, class_1802.field_8624, class_1802.field_21984, class_1802.field_21983);
    private static final List<class_1792> strippedWood = Arrays.asList(class_1802.field_8284, class_1802.field_8472, class_1802.field_8219, class_1802.field_8785, class_1802.field_8248, class_1802.field_8362, class_1802.field_22488, class_1802.field_22487);
    private static final List<class_6862<class_1792>> tags = Arrays.asList(class_3489.field_15555, class_3489.field_15540, class_3489.field_15534, class_3489.field_15557, class_3489.field_15550, class_3489.field_15552, class_3489.field_17620, class_3489.field_15536, class_3489.field_15533, class_3489.field_16585, class_3489.field_15558, class_3489.field_20344, class_3489.field_15539, class_3489.field_15537, class_3489.field_15542, class_3489.field_15544);
    private static final List<class_1792> similarDirt = Arrays.asList(class_1802.field_8831, class_1802.field_8270, class_1802.field_8365, class_1802.field_8460, class_1802.field_8382);
    private static final List<class_1792> similarFenceGate = Arrays.asList(class_1802.field_8114, class_1802.field_8289, class_1802.field_21997, class_1802.field_8874, class_1802.field_8097, class_1802.field_8293, class_1802.field_8653, class_1802.field_21998);
    private static final List<class_1792> similarGlass = Arrays.asList(class_1802.field_8280, class_1802.field_8483, class_1802.field_8393, class_1802.field_8243, class_1802.field_8869, class_1802.field_8095, class_1802.field_8340, class_1802.field_8770, class_1802.field_8507, class_1802.field_8363, class_1802.field_8685, class_1802.field_8838, class_1802.field_8126, class_1802.field_8332, class_1802.field_8734, class_1802.field_8636, class_1802.field_8410);
    private static final List<class_1792> similarGlassPanes = Arrays.asList(class_1802.field_8141, class_1802.field_8736, class_1802.field_8761, class_1802.field_8119, class_1802.field_8196, class_1802.field_8703, class_1802.field_8581, class_1802.field_8500, class_1802.field_8871, class_1802.field_8240, class_1802.field_8085, class_1802.field_8739, class_1802.field_8747, class_1802.field_8501, class_1802.field_8656, class_1802.field_8879, class_1802.field_8157);

    public static boolean isIgnorable(class_1792 it) {
        class_1799 defaultStack = it.method_7854();
        return StructureBlockData.IGNORED_ITEMS.contains(it) || defaultStack.method_31573(class_3489.field_16444) || defaultStack.method_31573(class_3489.field_15553) || defaultStack.method_31573(class_3489.field_15556);
    }

    public static List<class_1792> getSimilarItems(class_1792 item) {
        if (strippedLogs.contains(item)) {
            return strippedLogs.stream().filter(i -> i != item).toList();
        }
        if (strippedWood.contains(item)) {
            return strippedWood.stream().filter(i -> i != item).toList();
        }
        if (similarDirt.contains(item)) {
            return similarDirt.stream().filter(i -> i != item).toList();
        }
        if (similarFenceGate.contains(item)) {
            return similarFenceGate.stream().filter(i -> i != item).toList();
        }
        if (similarGlass.contains(item)) {
            return similarGlass.stream().filter(i -> i != item).toList();
        }
        if (similarGlassPanes.contains(item)) {
            return similarGlassPanes.stream().filter(i -> i != item).toList();
        }
        return SimilarItemsHelper.getItemTag(item).map(tag -> SimilarItemsHelper.getItems((class_6862<class_1792>)tag).stream().filter(it -> it != item).filter(it -> !strippedLogs.contains(it)).filter(it -> !strippedWood.contains(it)).filter(it -> !similarDirt.contains(it)).filter(it -> !similarFenceGate.contains(it)).filter(it -> !similarGlass.contains(it)).toList()).orElse(Collections.emptyList());
    }

    private static Optional<class_6862<class_1792>> getItemTag(class_1792 item) {
        class_1799 defaultStack = item.method_7854();
        return defaultStack.method_40133().filter(tags::contains).findFirst();
    }

    public static List<class_1792> getItems(class_6862<class_1792> tag) {
        ArrayList<class_1792> items = new ArrayList<class_1792>();
        for (class_6880 it : class_7923.field_41178.method_40286(tag)) {
            items.add((class_1792)it.comp_349());
        }
        return Collections.unmodifiableList(items);
    }
}

