/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.fortress.buildings;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1588;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5819;
import net.remmintan.mods.minefortress.core.interfaces.automation.IAutomationAreaProvider;
import net.remmintan.mods.minefortress.core.interfaces.automation.area.IAutomationArea;
import net.remmintan.mods.minefortress.core.interfaces.blueprints.buildings.IServerBuildingsManager;
import net.remmintan.mods.minefortress.core.interfaces.buildings.IFortressBuilding;
import net.remmintan.mods.minefortress.networking.helpers.FortressServerNetworkHelper;
import net.remmintan.mods.minefortress.networking.s2c.ClientboundSyncBuildingsPacket;
import net.remmintan.mods.minefortress.networking.s2c.S2COpenBuildingRepairScreen;
import org.jetbrains.annotations.NotNull;
import org.minefortress.fortress.buildings.FortressBuilding;

public class FortressBuildingManager
implements IAutomationAreaProvider,
IServerBuildingsManager {
    private int buildingPointer = 0;
    private final List<IFortressBuilding> buildings = new ArrayList<IFortressBuilding>();
    private final Supplier<class_3218> overworldSupplier;
    private final Cache<class_2338, Object> bedsCache = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.SECONDS).build();
    private boolean needSync = false;

    public FortressBuildingManager(Supplier<class_3218> overworldSupplier) {
        this.overworldSupplier = overworldSupplier;
    }

    @Override
    public void addBuilding(IFortressBuilding building) {
        this.buildings.add(building);
        this.scheduleSync();
    }

    @Override
    public void destroyBuilding(UUID id) {
        this.getBuildingById(id).ifPresent(it -> {
            this.buildings.remove(it);
            class_2338.method_10097((class_2338)it.getStart(), (class_2338)it.getEnd()).forEach(pos -> this.getWorld().method_8501(pos, class_2246.field_10124.method_9564()));
            this.scheduleSync();
        });
    }

    @Override
    public Optional<class_2338> getFreeBed() {
        Optional<class_2338> freeBed = this.buildings.stream().map(it -> it.getFreeBed((class_1937)this.getWorld())).filter(Optional::isPresent).map(Optional::get).filter(it -> !this.bedsCache.asMap().containsKey(it)).findFirst();
        freeBed.ifPresent(it -> this.bedsCache.put(it, new Object()));
        return freeBed;
    }

    @Override
    public long getTotalBedsCount() {
        return this.buildings.stream().mapToLong(it -> it.getBedsCount((class_1937)this.getWorld())).reduce(0L, Long::sum);
    }

    @Override
    public void tick(class_3222 player) {
        if (player != null && this.needSync) {
            List houses = this.buildings.stream().map(it -> it.toEssentialInfo((class_1937)this.getWorld())).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
            ClientboundSyncBuildingsPacket syncBuildings = new ClientboundSyncBuildingsPacket(houses);
            FortressServerNetworkHelper.send(player, "fortress_buildings_sync", syncBuildings);
            this.needSync = false;
        }
        if (!this.buildings.isEmpty()) {
            IFortressBuilding building;
            this.buildingPointer %= this.buildings.size();
            if ((building = this.buildings.get(this.buildingPointer++)).updateTheHealthState(this.getWorld())) {
                this.scheduleSync();
            }
            if (building.getHealth() < 1) {
                this.destroyBuilding(building.getId());
            }
        }
    }

    private void scheduleSync() {
        this.needSync = true;
    }

    @Override
    public boolean hasRequiredBuilding(String requirementId, int minCount) {
        Stream<IFortressBuilding> requiredBuildings = this.buildings.stream().filter(b -> b.satisfiesRequirement(requirementId));
        if (requirementId.startsWith("miner") || requirementId.startsWith("lumberjack") || requirementId.startsWith("warrior")) {
            return requiredBuildings.mapToLong(it -> it.getBedsCount((class_1937)this.getWorld()) * 10L).sum() > (long)minCount;
        }
        long count = requiredBuildings.count();
        if (requirementId.equals("shooting_gallery")) {
            return count * 10L > (long)minCount;
        }
        if (requirementId.startsWith("farm")) {
            return count * 5L > (long)minCount;
        }
        return count > (long)minCount;
    }

    @Override
    public class_2487 toNbt() {
        int i = 0;
        class_2487 buildingsTag = new class_2487();
        for (IFortressBuilding building : this.buildings) {
            class_2487 buildingTag = new class_2487();
            building.writeToNbt(buildingTag);
            buildingsTag.method_10566("building" + i++, (class_2520)buildingTag);
        }
        buildingsTag.method_10569("buildingPointer", this.buildingPointer);
        return buildingsTag;
    }

    @Override
    public void readFromNbt(class_2487 buildingsTag) {
        int i = 0;
        while (buildingsTag.method_10545("building" + i)) {
            class_2487 buildingTag = buildingsTag.method_10562("building" + i++);
            FortressBuilding building = new FortressBuilding(buildingTag);
            this.buildings.add(building);
            this.scheduleSync();
        }
        this.buildingPointer = buildingsTag.method_10550("buildingPointer");
    }

    @Override
    public Stream<IAutomationArea> getAutomationAreasByRequirement(String requirementId) {
        return this.buildings.stream().filter(building -> building.satisfiesRequirement(requirementId)).map(IAutomationArea.class::cast);
    }

    @Override
    public boolean isPartOfAnyBuilding(class_2338 pos) {
        return this.buildings.stream().anyMatch(it -> it.isPartOfTheBuilding(pos));
    }

    @Override
    public Optional<IFortressBuilding> findNearest(class_2338 pos) {
        return this.buildings.stream().sorted(Comparator.comparing(it -> it.getCenter().method_10262((class_2382)pos))).filter(it -> it.getHealth() > 0).findFirst();
    }

    @Override
    public void doRepairConfirmation(UUID id, class_3222 player) {
        Map<class_2338, class_2680> statesThatNeedsToBeRepaired = this.getBuildingById(id).map(IFortressBuilding::getAllBlockStatesToRepairTheBuilding).orElse(Collections.emptyMap());
        S2COpenBuildingRepairScreen packet = new S2COpenBuildingRepairScreen(id, statesThatNeedsToBeRepaired);
        FortressServerNetworkHelper.send(player, "open_building_repair_screen", packet);
    }

    @Override
    @NotNull
    public Optional<IFortressBuilding> getBuildingById(UUID id) {
        return this.buildings.stream().filter(it -> it.getId().equals(id)).findFirst();
    }

    @Override
    public Optional<class_1588> getRandomBuildingAttacker() {
        List attackersList = this.buildings.stream().map(IFortressBuilding::getAttackers).flatMap(Collection::stream).toList();
        if (attackersList.isEmpty()) {
            return Optional.empty();
        }
        class_5819 random = this.getWorld().field_9229;
        return Optional.of((class_1588)attackersList.get(random.method_43048(attackersList.size())));
    }

    @Override
    public void reset() {
        this.buildings.clear();
        this.bedsCache.invalidateAll();
        this.buildingPointer = 0;
        this.scheduleSync();
    }

    private class_3218 getWorld() {
        return this.overworldSupplier.get();
    }
}

