/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.fortress.buildings;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1588;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_7871;
import net.minecraft.class_7923;
import org.apache.logging.log4j.LogManager;

class FortressBuildingBlockData {
    private static final List<class_2248> IGNORED_BLOCKS = Arrays.asList(class_2246.field_10465, class_2246.field_10369, class_2246.field_10124);
    private int blockPointer = 0;
    private final List<PositionedState> referenceState = new ArrayList<PositionedState>();
    private final Map<class_2338, BuildingBlockState> actualState = new HashMap<class_2338, BuildingBlockState>();
    private List<class_2338> preservedPositions;
    private static final List<class_6862<class_2248>> TAGS = List.of(class_3481.field_29822, class_3481.field_15466, class_3481.field_15475);

    FortressBuildingBlockData(Map<class_2338, class_2680> preservedState, int floorYLevel) {
        for (Map.Entry<class_2338, class_2680> entry : preservedState.entrySet()) {
            class_2680 state;
            class_2338 pos = entry.getKey();
            if (FortressBuildingBlockData.shouldSkipBlock(pos, state = entry.getValue(), floorYLevel) || FortressBuildingBlockData.shouldSkipState(state)) continue;
            PositionedState positionedState = new PositionedState(pos, state);
            this.referenceState.add(positionedState);
            this.actualState.put(pos, BuildingBlockState.PRESERVED);
        }
    }

    private static boolean shouldSkipState(class_2680 state) {
        for (class_2248 ignoredBlock : IGNORED_BLOCKS) {
            if (!state.method_27852(ignoredBlock)) continue;
            return true;
        }
        return false;
    }

    private static boolean shouldSkipBlock(class_2338 pos, class_2680 state, int floorYLevel) {
        if (state.method_26215() || !state.method_26227().method_15769() || state.method_26204() == class_2246.field_10369) {
            return true;
        }
        if (state.method_26204() == class_2246.field_10465) {
            return true;
        }
        if (pos.method_10264() < floorYLevel) {
            return state.method_26164(class_3481.field_29822);
        }
        return false;
    }

    private FortressBuildingBlockData(class_2487 tag) {
        class_2338 pos;
        class_2487 compound;
        int i;
        class_2499 list;
        if (tag.method_10573("pointer", 99)) {
            this.blockPointer = tag.method_10550("pointer");
        }
        ArrayList<class_2338> skippedPositions = new ArrayList<class_2338>();
        if (tag.method_10573("referenceState", 9)) {
            list = tag.method_10554("referenceState", 10);
            for (i = 0; i < list.size(); ++i) {
                class_2680 blockState;
                compound = list.method_10602(i);
                pos = class_2338.method_10092((long)compound.method_10537("pos"));
                class_2520 blockStateTag = compound.method_10580("blockState");
                if (blockStateTag == null) continue;
                if (blockStateTag.method_10711() == 3) {
                    class_2497 nbtInt = (class_2497)blockStateTag;
                    int blockId = nbtInt.method_10701();
                    class_2248 block = (class_2248)class_7923.field_41175.method_10200(blockId);
                    blockState = block.method_9564();
                } else if (blockStateTag.method_10711() == 10) {
                    class_2487 compoundTag = (class_2487)blockStateTag;
                    blockState = class_2512.method_10681((class_7871)class_7923.field_41175.method_46771(), (class_2487)compoundTag);
                } else {
                    throw new IllegalArgumentException("Invalid block state tag");
                }
                if (FortressBuildingBlockData.shouldSkipState(blockState)) {
                    skippedPositions.add(pos);
                    continue;
                }
                PositionedState positionedState = new PositionedState(pos, blockState);
                this.referenceState.add(positionedState);
            }
        }
        if (tag.method_10573("actualState", 9)) {
            list = tag.method_10554("actualState", 10);
            for (i = 0; i < list.size(); ++i) {
                compound = list.method_10602(i);
                pos = class_2338.method_10092((long)compound.method_10537("pos"));
                if (skippedPositions.contains(pos)) continue;
                String blockState = compound.method_10558("blockState");
                try {
                    BuildingBlockState block = BuildingBlockState.valueOf(blockState);
                    this.actualState.put(pos, block);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    LogManager.getLogger().error("Invalid block state: " + blockState);
                    throw e;
                }
            }
        }
        this.recalculatePreservedPositions();
    }

    boolean checkTheNextBlocksState(int blocksAmount, class_3218 world) {
        if (this.referenceState.isEmpty()) {
            return false;
        }
        if (world.method_27983() != class_1937.field_25179) {
            throw new IllegalArgumentException("The world must be the overworld");
        }
        boolean stateUpdated = false;
        for (int i = 0; i < blocksAmount; ++i) {
            this.blockPointer %= this.referenceState.size();
            PositionedState state = this.referenceState.get(this.blockPointer);
            class_2338 pos = state.pos;
            class_2680 referenceBlock = state.blockState;
            class_2680 actualBlock = world.method_8320(pos);
            BuildingBlockState previousState = this.actualState.getOrDefault(pos, BuildingBlockState.PRESERVED);
            BuildingBlockState newState = FortressBuildingBlockData.areBlocksSimilar(referenceBlock, actualBlock) ? BuildingBlockState.PRESERVED : BuildingBlockState.DESTROYED;
            this.actualState.put(pos, newState);
            ++this.blockPointer;
            stateUpdated = stateUpdated || previousState != newState;
        }
        if (stateUpdated) {
            this.recalculatePreservedPositions();
        }
        return stateUpdated;
    }

    private static boolean areBlocksSimilar(class_2680 block, class_2680 actualBlock) {
        if (Objects.equals(block.method_26204(), actualBlock.method_26204())) {
            return true;
        }
        for (class_6862<class_2248> tag : TAGS) {
            if (!FortressBuildingBlockData.blockAreInTheSameBlockTag(block, actualBlock, tag)) continue;
            return true;
        }
        return false;
    }

    private static boolean blockAreInTheSameBlockTag(class_2680 a, class_2680 b, class_6862<class_2248> blockTag) {
        return a.method_26164(blockTag) && b.method_26164(blockTag);
    }

    private void recalculatePreservedPositions() {
        this.preservedPositions = this.actualState.entrySet().stream().filter(it -> it.getValue() == BuildingBlockState.PRESERVED).map(Map.Entry::getKey).toList();
    }

    int getHealth() {
        if (this.actualState.size() == 0) {
            return 0;
        }
        long preserved = this.actualState.values().stream().filter(state -> state == BuildingBlockState.PRESERVED).count();
        float delta = (float)preserved / (float)this.actualState.size();
        return (int)class_3532.method_37958((float)delta, (float)0.5f, (float)1.0f, (float)0.0f, (float)100.0f);
    }

    class_2487 toNbt() {
        class_2487 tag = new class_2487();
        class_2499 preservedStateList = new class_2499();
        for (PositionedState positionedState : this.referenceState) {
            class_2487 compound = new class_2487();
            compound.method_10544("pos", positionedState.pos.method_10063());
            class_2680 blockState = positionedState.blockState;
            compound.method_10566("blockState", (class_2520)class_2512.method_10686((class_2680)blockState));
            preservedStateList.add((Object)compound);
        }
        tag.method_10566("referenceState", (class_2520)preservedStateList);
        class_2499 actualStateList = new class_2499();
        for (Map.Entry<class_2338, BuildingBlockState> entry : this.actualState.entrySet()) {
            class_2487 compound = new class_2487();
            compound.method_10544("pos", entry.getKey().method_10063());
            compound.method_10582("blockState", entry.getValue().name());
            actualStateList.add((Object)compound);
        }
        tag.method_10566("actualState", (class_2520)actualStateList);
        tag.method_10569("pointer", this.blockPointer);
        return tag;
    }

    boolean attack(class_1588 attacker) {
        class_1937 world = attacker.method_37908();
        class_5819 random = world.field_9229;
        for (Map.Entry<class_2338, BuildingBlockState> entries : this.actualState.entrySet()) {
            class_2338 pos = entries.getKey();
            BuildingBlockState state = entries.getValue();
            if (state == BuildingBlockState.DESTROYED) continue;
            if (!(random.method_43057() >= 0.6f)) break;
            world.method_20290(2001, pos, class_2248.method_9507((class_2680)world.method_8320(pos)));
            world.method_8501(pos, class_2246.field_10124.method_9564());
            world.method_33596((class_1297)attacker, class_5712.field_28165, pos);
            return true;
        }
        if (this.preservedPositions != null) {
            class_2338 pos = this.preservedPositions.get(random.method_43048(this.preservedPositions.size()));
            world.method_8517(attacker.method_5628(), pos, random.method_43048(10));
        }
        return false;
    }

    Map<class_2338, class_2680> getAllBlockStatesToRepairTheBuilding() {
        HashMap<class_2338, class_2680> map = new HashMap<class_2338, class_2680>();
        for (Map.Entry<class_2338, BuildingBlockState> entry : this.actualState.entrySet()) {
            class_2338 pos = entry.getKey();
            BuildingBlockState state = entry.getValue();
            if (state == BuildingBlockState.PRESERVED) continue;
            class_2680 blockState = this.referenceState.stream().filter((Predicate<PositionedState>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getAllBlockStatesToRepairTheBuilding$2(net.minecraft.class_2338 org.minefortress.fortress.buildings.FortressBuildingBlockData$PositionedState ), (Lorg/minefortress/fortress/buildings/FortressBuildingBlockData$PositionedState;)Z)((class_2338)pos)).findFirst().orElseThrow().blockState;
            map.put(pos, blockState);
        }
        return map;
    }

    static FortressBuildingBlockData fromNbt(class_2487 compound) {
        return new FortressBuildingBlockData(compound);
    }

    private static /* synthetic */ boolean lambda$getAllBlockStatesToRepairTheBuilding$2(class_2338 pos, PositionedState it) {
        return it.pos.equals((Object)pos);
    }

    private record PositionedState(class_2338 pos, class_2680 blockState) {
    }

    private static enum BuildingBlockState {
        DESTROYED,
        PRESERVED;

    }
}

