/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.fortress.buildings;

import java.time.LocalDateTime;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.class_1588;
import net.minecraft.class_1937;
import net.minecraft.class_2244;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2742;
import net.minecraft.class_2769;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.remmintan.mods.minefortress.core.interfaces.automation.area.IAutomationBlockInfo;
import net.remmintan.mods.minefortress.core.interfaces.buildings.IEssentialBuildingInfo;
import net.remmintan.mods.minefortress.core.interfaces.buildings.IFortressBuilding;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.minefortress.fortress.automation.iterators.FarmBuildingIterator;
import org.minefortress.fortress.buildings.EssentialBuildingInfo;
import org.minefortress.fortress.buildings.FortressBuildingBlockData;

public class FortressBuilding
implements IFortressBuilding {
    private static final int MAX_BLOCKS_PER_UPDATE = 10;
    private final UUID id;
    private final class_2338 start;
    private final class_2338 end;
    private final String requirementId;
    @Nullable
    private final String blueprintId;
    private final int floorLevel;
    @Nullable
    private FortressBuildingBlockData buildingBlockData;
    private LocalDateTime lastUpdated;
    private Iterator<IAutomationBlockInfo> currentIterator;
    private Set<class_1588> attackers = new HashSet<class_1588>();

    public FortressBuilding(UUID id, class_2338 start, class_2338 end, String requirementId, @NotNull String blueprintId, int floorLevel, Map<class_2338, class_2680> buildingBlockData) {
        this.id = id;
        this.start = start.method_10062();
        this.end = end.method_10062();
        this.requirementId = requirementId;
        Map<class_2338, class_2680> blockData = buildingBlockData.entrySet().stream().collect(Collectors.toMap(it -> ((class_2338)it.getKey()).method_10081((class_2382)start).method_10062(), Map.Entry::getValue));
        this.floorLevel = floorLevel;
        this.buildingBlockData = new FortressBuildingBlockData(blockData, start.method_10264() + floorLevel);
        this.lastUpdated = LocalDateTime.MIN;
        this.blueprintId = blueprintId;
    }

    public FortressBuilding(class_2487 tag) {
        class_2520 buildBlockDataTag;
        this.id = tag.method_10545("id") ? tag.method_25926("id") : UUID.randomUUID();
        if (!tag.method_10545("start")) {
            throw new IllegalArgumentException("Tag does not contain start");
        }
        this.start = class_2338.method_10092((long)tag.method_10537("start"));
        if (!tag.method_10545("end")) {
            throw new IllegalArgumentException("Tag does not contain end");
        }
        this.end = class_2338.method_10092((long)tag.method_10537("end"));
        this.requirementId = tag.method_10545("requirementId") ? tag.method_10558("requirementId") : "<old>";
        this.lastUpdated = tag.method_10545("lastUpdated") ? LocalDateTime.parse(tag.method_10558("lastUpdated")) : LocalDateTime.MIN;
        this.blueprintId = tag.method_10545("blueprintId") ? tag.method_10558("blueprintId") : (tag.method_10545("file") ? tag.method_10558("file") : null);
        this.buildingBlockData = tag.method_10545("buildingBlockData") ? ((buildBlockDataTag = tag.method_10580("buildingBlockData")) != null && buildBlockDataTag.method_10711() == 10 ? FortressBuildingBlockData.fromNbt((class_2487)buildBlockDataTag) : null) : null;
        this.floorLevel = tag.method_10545("floorLevel") ? tag.method_10550("floorLevel") : 0;
    }

    @Override
    public boolean updateTheHealthState(class_3218 world) {
        if (world == null || world.method_27983() != class_1937.field_25179) {
            return false;
        }
        if (this.buildingBlockData == null) {
            Map<class_2338, class_2680> blocks = class_2338.method_20437((class_2338)this.start, (class_2338)this.end).collect(Collectors.toMap(class_2338::method_10062, arg_0 -> ((class_3218)world).method_8320(arg_0)));
            this.buildingBlockData = new FortressBuildingBlockData(blocks, this.start.method_10264() + this.floorLevel);
        }
        return this.buildingBlockData.checkTheNextBlocksState(10, world);
    }

    @Override
    public int getHealth() {
        return this.buildingBlockData == null ? 0 : this.buildingBlockData.getHealth();
    }

    @Override
    public boolean isPartOfTheBuilding(class_2338 pos) {
        return this.start.method_10263() <= pos.method_10263() && pos.method_10263() <= this.end.method_10263() && this.start.method_10264() - 1 <= pos.method_10264() && pos.method_10264() <= this.end.method_10264() + 1 && this.start.method_10260() <= pos.method_10260() && pos.method_10260() <= this.end.method_10260();
    }

    @Override
    public class_2338 getStart() {
        return this.start;
    }

    @Override
    public class_2338 getEnd() {
        return this.end;
    }

    @Override
    public class_2338 getCenter() {
        return new class_2338((this.start.method_10263() + this.end.method_10263()) / 2, (this.start.method_10264() + this.end.method_10264()) / 2, (this.start.method_10260() + this.end.method_10260()) / 2);
    }

    @Override
    public class_2338 getNearestCornerXZ(class_2338 pos, class_1937 world) {
        int x = pos.method_10263() < this.start.method_10263() ? this.start.method_10263() : Math.min(pos.method_10263(), this.end.method_10263());
        int z = pos.method_10260() < this.start.method_10260() ? this.start.method_10260() : Math.min(pos.method_10260(), this.end.method_10260());
        return world.method_8598(class_2902.class_2903.field_13202, new class_2338(x, 0, z));
    }

    @Override
    public Optional<class_2338> getFreeBed(class_1937 world) {
        return this.streamBeds(world).filter(pos -> (Boolean)world.method_8320(pos).method_11654((class_2769)class_2244.field_9968) == false).findFirst();
    }

    @NotNull
    private Stream<class_2338> streamBeds(class_1937 world) {
        return StreamSupport.stream(class_2338.method_10097((class_2338)this.start, (class_2338)this.end).spliterator(), false).filter(pos -> world.method_8320(pos).method_26164(class_3481.field_16443)).filter(pos -> world.method_8320(pos).method_11654((class_2769)class_2244.field_9967) == class_2742.field_12560).map(class_2338::method_10062);
    }

    @Override
    public long getBedsCount(class_1937 world) {
        return this.streamBeds(world).count();
    }

    @Override
    public void writeToNbt(class_2487 tag) {
        tag.method_25927("id", this.id);
        tag.method_10544("start", this.start.method_10063());
        tag.method_10544("end", this.end.method_10063());
        tag.method_10582("requirementId", this.requirementId);
        tag.method_10582("lastUpdated", this.lastUpdated.toString());
        if (this.blueprintId != null) {
            tag.method_10582("blueprintId", this.blueprintId);
        }
        if (this.buildingBlockData != null) {
            tag.method_10566("buildingBlockData", (class_2520)this.buildingBlockData.toNbt());
        }
        tag.method_10569("floorLevel", this.floorLevel);
    }

    @Override
    public Iterator<IAutomationBlockInfo> iterator(class_1937 world) {
        if ((this.currentIterator == null || !this.currentIterator.hasNext()) && this.requirementId.startsWith("farm")) {
            this.currentIterator = new FarmBuildingIterator(this.start, this.end, world);
        }
        if (this.currentIterator == null) {
            throw new IllegalStateException("Iterator is not set properly");
        }
        return this.currentIterator;
    }

    @Override
    public boolean satisfiesRequirement(String requirementId) {
        return this.requirementId != null && this.requirementId.equals(requirementId);
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public void update() {
        this.lastUpdated = LocalDateTime.now();
    }

    @Override
    public LocalDateTime getUpdated() {
        return this.lastUpdated;
    }

    @Override
    public void attack(class_1588 attacker) {
        if (this.buildingBlockData != null && this.buildingBlockData.attack(attacker)) {
            this.attackers.add(attacker);
        }
    }

    @Override
    public Set<class_1588> getAttackers() {
        this.attackers.removeIf(it -> !it.method_5805());
        return this.attackers;
    }

    @Override
    public IEssentialBuildingInfo toEssentialInfo(class_1937 world) {
        return new EssentialBuildingInfo(this.id, this.start, this.end, this.requirementId, this.getBedsCount(world), this.blueprintId, this.getHealth());
    }

    @Override
    public Map<class_2338, class_2680> getAllBlockStatesToRepairTheBuilding() {
        return this.buildingBlockData == null ? Collections.emptyMap() : this.buildingBlockData.getAllBlockStatesToRepairTheBuilding();
    }
}

