/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.fortress.buildings;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.remmintan.mods.minefortress.core.interfaces.buildings.IEssentialBuildingInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EssentialBuildingInfo
implements IEssentialBuildingInfo {
    public static final String DEFAULT_BLUEPRINT_ID = "default-file-36d9a49d-4d47-45c8-9201-23d71e156da1";
    private final UUID id;
    private final class_2338 start;
    private final class_2338 end;
    private final String requirementId;
    private final long bedsCount;
    @NotNull
    private final String blueprintId;
    private final int health;

    public EssentialBuildingInfo(UUID id, class_2338 start, class_2338 end, String requirementId, long bedsCount, @Nullable String blueprintId, int health) {
        this.id = id;
        this.start = start.method_10062();
        this.end = end.method_10062();
        this.requirementId = requirementId;
        this.bedsCount = bedsCount;
        this.blueprintId = Optional.ofNullable(blueprintId).orElse(DEFAULT_BLUEPRINT_ID);
        this.health = health;
    }

    public EssentialBuildingInfo(class_2540 buf) {
        this.id = buf.method_10790();
        this.start = buf.method_10811();
        this.end = buf.method_10811();
        this.requirementId = buf.method_19772();
        this.bedsCount = buf.readLong();
        this.blueprintId = buf.method_19772();
        this.health = buf.readInt();
    }

    @Override
    public class_2338 getStart() {
        return this.start;
    }

    @Override
    public class_2338 getEnd() {
        return this.end;
    }

    @Override
    public String getRequirementId() {
        return this.requirementId;
    }

    @Override
    public long getBedsCount() {
        return this.bedsCount;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    @NotNull
    public Optional<String> getBlueprintId() {
        if (this.blueprintId.equals(DEFAULT_BLUEPRINT_ID)) {
            return Optional.empty();
        }
        return Optional.of(this.blueprintId);
    }

    @Override
    public int getHealth() {
        return this.health;
    }

    @Override
    public void write(class_2540 buffer) {
        buffer.method_10797(this.id);
        buffer.method_10807(this.start);
        buffer.method_10807(this.end);
        buffer.method_10814(this.requirementId);
        buffer.writeLong(this.bedsCount);
        buffer.method_10814(this.blueprintId);
        buffer.writeInt(this.health);
    }
}

