/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.fortress.automation.iterators;

import java.util.List;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import net.remmintan.mods.minefortress.building.BuildingHelper;
import net.remmintan.mods.minefortress.core.interfaces.automation.area.AutomationActionType;
import org.minefortress.fortress.automation.AutomationBlockInfo;
import org.minefortress.fortress.automation.iterators.AbstractFilteredIterator;

public class FarmAreaIterator
extends AbstractFilteredIterator {
    private final class_1937 world;

    public FarmAreaIterator(List<class_2338> areaBlocks, class_1937 world) {
        super(areaBlocks.listIterator());
        this.world = world;
    }

    public static boolean blockCanBeRemovedToPlantCrops(class_2680 blockState) {
        return blockState.method_27852(class_2246.field_10479) || blockState.method_26164(class_3481.field_33714) || blockState.method_26164(class_3481.field_20339);
    }

    @Override
    protected boolean filter(class_2338 pos) {
        boolean posSuitableForWater;
        int topY = this.world.method_8624(class_2902.class_2903.field_13197, pos.method_10263(), pos.method_10260());
        boolean bl = posSuitableForWater = pos.method_10264() == topY && this.isGoalCorrectForWater(pos);
        if (topY - 1 != pos.method_10264() && !posSuitableForWater) {
            return false;
        }
        class_2680 blockState = this.world.method_8320(pos);
        if (posSuitableForWater && blockState.method_26215()) {
            return true;
        }
        boolean goalCorrect = blockState.method_27852(class_2246.field_10362) || blockState.method_27852(class_2246.field_10566) || blockState.method_27852(class_2246.field_10219) || this.isGoalCorrectForWater(pos);
        class_2680 aboveGoalState = this.world.method_8320(pos.method_10084());
        boolean aboveGoalCorrect = aboveGoalState.method_26164(class_3481.field_20341) || aboveGoalState.method_26215() || FarmAreaIterator.blockCanBeRemovedToPlantCrops(aboveGoalState);
        return goalCorrect && aboveGoalCorrect;
    }

    @Override
    protected AutomationBlockInfo map(class_2338 pos) {
        AutomationActionType actionType = this.isGoalCorrectForWater(pos) ? AutomationActionType.FARM_WATER : AutomationActionType.FARM_CROPS;
        return new AutomationBlockInfo(pos, actionType);
    }

    private boolean isGoalCorrectForWater(class_2338 pos) {
        return pos.method_10263() % 4 == 0 && pos.method_10260() % 4 == 0 && this.positionSuitableForWater(pos.method_10067()) && this.positionSuitableForWater(pos.method_10078()) && this.positionSuitableForWater(pos.method_10095()) && this.positionSuitableForWater(pos.method_10072());
    }

    private boolean positionSuitableForWater(class_2338 nearPos) {
        return BuildingHelper.hasCollisions((class_1936)this.world, nearPos) || this.world.method_8320(nearPos).method_26227().method_15767(class_3486.field_15517);
    }
}

