/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.fortress.automation.areas;

import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2902;
import net.remmintan.mods.minefortress.core.interfaces.automation.IAutomationAreaInfo;
import net.remmintan.mods.minefortress.core.interfaces.automation.ProfessionsSelectionType;
import net.remmintan.mods.minefortress.core.interfaces.automation.area.IAutomationArea;
import net.remmintan.mods.minefortress.core.interfaces.automation.area.IAutomationBlockInfo;
import org.minefortress.fortress.automation.areas.AutomationAreaInfo;
import org.minefortress.fortress.automation.iterators.FarmAreaIterator;
import org.minefortress.fortress.automation.iterators.MineAreaIterator;
import org.minefortress.fortress.automation.iterators.ResetableIterator;
import org.minefortress.utils.AreasUtils;

public final class ServerAutomationAreaInfo
extends AutomationAreaInfo
implements IAutomationArea {
    private LocalDateTime updated;
    private ResetableIterator<IAutomationBlockInfo> currentIterator;
    private boolean reset = false;

    public ServerAutomationAreaInfo(IAutomationAreaInfo info) {
        this(info.getClientArea(), info.getAreaType(), info.getId(), LocalDateTime.MIN);
    }

    private ServerAutomationAreaInfo(List<class_2338> area, ProfessionsSelectionType areaType, UUID id, LocalDateTime updated) {
        super(area.stream().sorted(Comparator.comparingInt(class_2382::method_10264).reversed().thenComparingInt(class_2382::method_10263).thenComparingInt(class_2382::method_10260)).toList(), areaType, id);
        this.updated = updated;
    }

    @Override
    public Iterator<IAutomationBlockInfo> iterator(class_1937 world) {
        if (this.reset) {
            return Collections.emptyIterator();
        }
        if (this.currentIterator == null || !this.currentIterator.hasNext()) {
            this.currentIterator = switch (this.getAreaType()) {
                default -> throw new IncompatibleClassChangeError();
                case ProfessionsSelectionType.FARMING -> new FarmAreaIterator(this.getServerArea(), world);
                case ProfessionsSelectionType.QUARRY -> new MineAreaIterator(this.getServerArea(), world);
            };
        }
        return this.currentIterator;
    }

    public void refresh(class_1937 world) {
        List<class_2338> area = this.getClientArea();
        this.area = this.getRefreshedArea(world, area);
    }

    private List<class_2338> getRefreshedArea(class_1937 world, List<class_2338> area) {
        if (area.isEmpty()) {
            return area;
        }
        class_2338 first = area.get(0);
        Set<class_2338> flatBlocks = area.stream().map(it -> it.method_33096(first.method_10264())).collect(Collectors.toSet());
        return AreasUtils.buildAnAreaOnSurfaceWithinBlocks(flatBlocks, world, super.getAreaType() == ProfessionsSelectionType.QUARRY ? class_2902.class_2903.field_13202 : class_2902.class_2903.field_13197);
    }

    public List<class_2338> getServerArea() {
        return this.getClientArea();
    }

    @Override
    public void update() {
        this.updated = LocalDateTime.now();
    }

    @Override
    public LocalDateTime getUpdated() {
        return this.updated;
    }

    public void reset() {
        if (this.currentIterator != null) {
            this.currentIterator.reset();
        }
        this.reset = true;
    }

    public class_2487 toNbt() {
        class_2487 tag = new class_2487();
        tag.method_25927("id", this.getId());
        tag.method_10538("blocks", this.getClientArea().stream().map(class_2338::method_10063).toList());
        tag.method_10582("areaType", this.getAreaType().name());
        tag.method_10582("updated", this.updated.toString());
        return tag;
    }

    public static ServerAutomationAreaInfo formNbt(class_2487 tag) {
        UUID id = tag.method_25926("id");
        ProfessionsSelectionType areaType = ProfessionsSelectionType.valueOf(tag.method_10558("areaType"));
        long[] blocks = tag.method_10565("blocks");
        List<class_2338> blockPosList = Arrays.stream(blocks).mapToObj(class_2338::method_10092).toList();
        if (tag.method_10545("updated")) {
            LocalDateTime updated = LocalDateTime.parse(tag.method_10558("updated"));
            return new ServerAutomationAreaInfo(blockPosList, areaType, id, updated);
        }
        return new ServerAutomationAreaInfo(blockPosList, areaType, id, LocalDateTime.MIN);
    }
}

