/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.fortress.automation.areas;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_2338;
import net.remmintan.gobi.ClientSelection;
import net.remmintan.mods.minefortress.building.BuildingHelper;
import net.remmintan.mods.minefortress.core.interfaces.automation.IAutomationAreaInfo;
import net.remmintan.mods.minefortress.core.interfaces.tasks.IClientTask;
import net.remmintan.mods.minefortress.core.interfaces.tasks.ISavedAreasHolder;
import net.remmintan.mods.minefortress.core.interfaces.tasks.ITasksModelBuilderInfoProvider;
import net.remmintan.mods.minefortress.core.interfaces.tasks.ITasksRenderInfoProvider;

public final class SavedAreasHolder
implements ITasksModelBuilderInfoProvider,
ITasksRenderInfoProvider,
ISavedAreasHolder {
    private boolean needsUpdate = true;
    private List<IAutomationAreaInfo> savedAreas = Collections.emptyList();

    @Override
    public void setSavedAreas(List<IAutomationAreaInfo> savedAreas) {
        this.savedAreas = Collections.unmodifiableList(savedAreas);
        this.setNeedRebuild(true);
    }

    @Override
    public boolean isNeedRebuild() {
        return this.needsUpdate;
    }

    @Override
    public void setNeedRebuild(boolean rebuildNeeded) {
        this.needsUpdate = rebuildNeeded;
    }

    @Override
    public Set<IClientTask> getAllSelections() {
        return this.savedAreas.stream().map(this::toClientSelection).collect(Collectors.toSet());
    }

    @Override
    public Optional<IAutomationAreaInfo> getHovered(class_2338 pos) {
        return this.savedAreas.stream().filter(it -> it.contains(pos)).findAny();
    }

    @Override
    public boolean shouldRender() {
        return !this.savedAreas.isEmpty();
    }

    private IClientTask toClientSelection(IAutomationAreaInfo info) {
        return new ClientSelection(info.getClientArea(), info.getAreaType().getColor(), BuildingHelper::canRemoveBlock);
    }
}

