/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.fortress.automation.areas;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import net.remmintan.mods.minefortress.core.interfaces.automation.IAutomationAreaInfo;
import net.remmintan.mods.minefortress.core.interfaces.automation.area.IAutomationArea;
import net.remmintan.mods.minefortress.core.interfaces.automation.server.IServerAutomationAreaManager;
import net.remmintan.mods.minefortress.networking.helpers.FortressServerNetworkHelper;
import net.remmintan.mods.minefortress.networking.s2c.S2CSyncAreasPacket;
import org.minefortress.fortress.automation.areas.ServerAutomationAreaInfo;

public final class AreasServerManager
implements IServerAutomationAreaManager {
    private boolean needSync = false;
    private final List<ServerAutomationAreaInfo> areas = new ArrayList<ServerAutomationAreaInfo>();
    private int tickCounter = 0;
    private int refreshPointer = 0;

    @Override
    public void addArea(IAutomationAreaInfo area) {
        this.areas.add(new ServerAutomationAreaInfo(area));
        this.sync();
    }

    @Override
    public void removeArea(UUID id) {
        List<ServerAutomationAreaInfo> areasToRemove = this.areas.stream().filter(it -> it.getId().equals(id)).toList();
        areasToRemove.forEach(ServerAutomationAreaInfo::reset);
        this.areas.removeAll(areasToRemove);
        this.sync();
    }

    @Override
    public void tick(class_3222 serverPlayer) {
        if (serverPlayer == null) {
            return;
        }
        if (this.tickCounter++ % 20 == 0) {
            if (this.areas.isEmpty()) {
                return;
            }
            if (this.refreshPointer >= this.areas.size()) {
                this.refreshPointer = 0;
            }
            this.areas.get(this.refreshPointer++).refresh(serverPlayer.method_37908());
            this.sync();
        }
        if (this.needSync) {
            List<IAutomationAreaInfo> automationAreaInfos = this.areas.stream().map(IAutomationAreaInfo.class::cast).toList();
            FortressServerNetworkHelper.send(serverPlayer, "sync_areas", new S2CSyncAreasPacket(automationAreaInfos));
            this.needSync = false;
        }
    }

    @Override
    public Stream<IAutomationArea> getByRequirement(String requirement) {
        return this.areas.stream().filter(it -> it.getAreaType().satisfies(requirement)).map(ServerAutomationAreaInfo.class::cast);
    }

    @Override
    public void sync() {
        this.needSync = true;
    }

    @Override
    public void write(class_2487 tag) {
        class_2487 areas = new class_2487();
        class_2499 nbtElements = new class_2499();
        for (ServerAutomationAreaInfo area : this.areas) {
            nbtElements.add((Object)area.toNbt());
        }
        areas.method_10566("areas", (class_2520)nbtElements);
        tag.method_10566("areaManager", (class_2520)areas);
    }

    @Override
    public void read(class_2487 tag) {
        this.areas.clear();
        if (!tag.method_10545("areaManager")) {
            return;
        }
        class_2487 areas = tag.method_10562("areaManager");
        class_2499 nbtElements = areas.method_10554("areas", 10);
        for (int i = 0; i < nbtElements.size(); ++i) {
            class_2487 areaTag = nbtElements.method_10602(i);
            ServerAutomationAreaInfo area = ServerAutomationAreaInfo.formNbt(areaTag);
            this.areas.add(area);
        }
        this.sync();
    }
}

